/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.datasets;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;

public abstract class DataSetUpdater
implements OdConstants {
    public static final void updateDataSet(DataSet dataSet, AbstractDataSetHandler handler, File associatedFile) {
        if (dataSet != null && handler != null) {
            if (associatedFile != null) {
                handler.setAssociatedFile(associatedFile);
                long lastmodified = associatedFile.lastModified();
                if (lastmodified > 0L) {
                    handler.setSourceDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date(lastmodified)));
                }
            }
            if (!Main.pref.getBoolean("opendata.rawdata")) {
                handler.updateDataSet(dataSet);
            }
            handler.checkDataSetSource(dataSet);
            handler.checkNames(dataSet);
            for (Relation r : dataSet.getRelations()) {
                OsmPrimitive outer;
                if (!r.isMultipolygon() || r.getMembersCount() != 1 || (outer = r.getMember(0).getMember()).isTagged()) continue;
                r.remove("type");
                r.removeMember(0);
                outer.setKeys(r.getKeys());
                dataSet.removePrimitive((PrimitiveId)r);
            }
            for (Way w : dataSet.getWays()) {
                SequenceCommand command = Main.main.menu.simplifyWay.simplifyWay(w, 0.25);
                if (command == null) continue;
                Main.main.undoRedo.addNoRedraw((Command)command);
            }
        }
    }
}

