/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.paris.datasets.urbanisme;

import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.paris.datasets.ParisDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.paris.datasets.ParisShpHandler;
import org.openstreetmap.josm.tools.Geometry;

public class EclairagePublicHandler
extends ParisDataSetHandler {
    private final InternalShpHandler shpHandler = new InternalShpHandler();

    public EclairagePublicHandler() {
        super(94);
        this.setName("\u00c9clairage public");
        this.setShpHandler((ShpHandler)this.shpHandler);
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsShpFilename(filename, new String[]{"eclairage_public"}) || this.acceptsZipFilename(filename, new String[]{"eclairage_public"});
    }

    @Override
    protected String getDirectLink() {
        return "http://opendata.paris.fr/opendata/hn/eclairage_public.zip";
    }

    public void updateDataSet(DataSet ds) {
        this.shpHandler.nodes.clear();
    }

    private final class InternalShpHandler
    extends ParisShpHandler {
        private InternalShpHandler() {
        }

        public void notifyFeatureParsed(Object feature, DataSet result, Set<OsmPrimitive> featurePrimitives) {
            this.initFeaturesPrimitives(featurePrimitives);
            if (this.dataPrimitive == null) {
                System.err.println("Found no primitive with tags");
            } else if (this.closedWay == null) {
                this.dataPrimitive.put("FIXME", "This way is not closed and has not been recognized as highway=street_lamp.");
            } else {
                Node centroid = this.createOrGetNode(result, Geometry.getCentroid((List)this.closedWay.getNodes()));
                if (!centroid.hasKeys()) {
                    centroid.setKeys(this.dataPrimitive.getKeys());
                    centroid.put("highway", "street_lamp");
                    EclairagePublicHandler.this.replace((IPrimitive)centroid, "Libelle", "lamp_model:fr");
                } else if (!(centroid.get("lamp_model:fr") == null || this.dataPrimitive.get("Libelle") != null && this.dataPrimitive.get("Libelle").equals(centroid.get("lamp_model:fr")))) {
                    System.err.println("Found 2 street lamps at the same position with different types: '" + centroid.get("lamp_model:fr") + "' and '" + this.dataPrimitive.get("Libelle") + "'.");
                }
                this.removePrimitives(result);
                if (centroid.get("lamp_model:fr") != null) {
                    if (centroid.get("lamp_model:fr").contains("mural") && !centroid.get("lamp_model:fr").contains("au sol")) {
                        centroid.put("lamp_mount", "wall mounted");
                    } else if (centroid.get("lamp_model:fr").contains("au sol") && !centroid.get("lamp_model:fr").contains("mural")) {
                        centroid.put("lamp_mount", "ground");
                    } else {
                        centroid.put("lamp_mount", "pole");
                    }
                    centroid.remove("Info");
                }
            }
        }
    }
}

