/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.paris.datasets.environnement;

import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.paris.datasets.ParisDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.paris.datasets.ParisShpHandler;
import org.openstreetmap.josm.tools.Geometry;

public class MobilierVoiePubliqueHandler
extends ParisDataSetHandler {
    private final InternalShpHandler shpHandler = new InternalShpHandler();

    public MobilierVoiePubliqueHandler() {
        super(96);
        this.setName("Mobiliers sur voie publique");
        this.setShpHandler((ShpHandler)this.shpHandler);
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsShpFilename(filename, new String[]{"environnement"}) || this.acceptsZipFilename(filename, new String[]{"environnement"});
    }

    @Override
    protected String getDirectLink() {
        return "http://opendata.paris.fr/opendata/hn/environnement.zip";
    }

    public void updateDataSet(DataSet ds) {
        this.shpHandler.nodes.clear();
    }

    private final class InternalShpHandler
    extends ParisShpHandler {
        private InternalShpHandler() {
        }

        public void notifyFeatureParsed(Object feature, DataSet result, Set<OsmPrimitive> featurePrimitives) {
            this.initFeaturesPrimitives(featurePrimitives);
            String type = this.dataPrimitive.get("Libelle");
            if (type.startsWith("Banc ")) {
                if (this.closedWay == null && this.dataPrimitive instanceof Way && ((Way)this.dataPrimitive).getNodesCount() > 3) {
                    Way copy = new Way((Way)this.dataPrimitive);
                    while (copy.getNodesCount() > 3 && !copy.isClosed()) {
                        copy.removeNode(copy.getNode(0));
                    }
                    if (copy.isClosed()) {
                        this.closedWay = copy;
                    } else {
                        copy = new Way((Way)this.dataPrimitive);
                        while (copy.getNodesCount() > 3 && !copy.isClosed()) {
                            copy.removeNode(copy.getNode(copy.getNodesCount() - 1));
                        }
                        if (copy.isClosed()) {
                            this.closedWay = copy;
                        }
                    }
                }
                if (this.closedWay != null) {
                    Node bench = this.createOrGetNode(result, Geometry.getCentroid((List)this.closedWay.getNodes()));
                    bench.put("amenity", "bench");
                    bench.put("description", type);
                    this.removePrimitives(result);
                } else {
                    System.err.println("Bench without closed area: " + type);
                }
            } else if (type.startsWith("Poubelle") || type.startsWith("Borne de propret\u00e9")) {
                if (this.closedWay != null) {
                    Node basket = this.createOrGetNode(result, Geometry.getCentroid((List)this.closedWay.getNodes()));
                    basket.put("amenity", "waste_basket");
                    basket.put("description", type);
                    this.removePrimitives(result);
                } else {
                    System.err.println("Waste basket without closed area: " + type);
                }
            } else if (type.startsWith("Bac \u00e0 sable")) {
                if (this.closedWay == null && this.dataPrimitive instanceof Way && ((Way)this.dataPrimitive).getNodesCount() == 2) {
                    this.closedWay = (Way)this.dataPrimitive;
                    for (Way w : this.ways) {
                        if (w.getNodesCount() != 4) continue;
                        Node n1 = w.getNode(1);
                        Node n2 = w.getNode(2);
                        if (this.closedWay.getNode(1).getCoor().distance(n1.getCoor()) < this.closedWay.getNode(1).getCoor().distance(n2.getCoor())) {
                            this.closedWay.addNode(n1);
                            this.closedWay.addNode(n2);
                        } else {
                            this.closedWay.addNode(n2);
                            this.closedWay.addNode(n1);
                        }
                        this.closedWay.addNode(this.closedWay.getNode(0));
                        break;
                    }
                }
                if (this.closedWay != null) {
                    this.removePrimitives(result);
                } else {
                    System.err.println("Sandpit without closed area: " + type);
                }
            } else if (type.startsWith("Corbeille florale")) {
                if (this.closedWay != null) {
                    Node n = this.createOrGetNode(result, Geometry.getCentroid((List)this.closedWay.getNodes()));
                    n.put("man_made", "floral_basket");
                    n.put("description", type);
                    this.removePrimitives(result);
                } else {
                    System.err.println("Floral basket without closed area: " + type);
                }
            } else if (type.startsWith("Objet sans identification particuli\u00e8re")) {
                this.removePrimitives(result);
            } else {
                System.err.println("Unsupported object type: " + type);
            }
        }
    }
}

