/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.eclipse.xsd.util.XSDUtil;
import org.geotools.data.DataUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.SchemaLocationResolver;
import org.geotools.xml.SchemaLocator;
import org.geotools.xml.impl.SchemaIndexImpl;
import org.geotools.xml.impl.TypeWalker;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Schemas {
    private static final Logger LOGGER = Logging.getLogger((String)Schemas.class.getPackage().getName());

    public static final SchemaIndex findSchemas(Configuration configuration) {
        HashSet<Configuration> configurations = new HashSet<Configuration>(configuration.allDependencies());
        configurations.add(configuration);
        ArrayList<XSDSchema> resolvedSchemas = new ArrayList<XSDSchema>(configurations.size());
        for (Configuration conf : configurations) {
            XSDSchema schema;
            XSDSchemaLocator locator;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("looking up schema for " + conf.getNamespaceURI());
            }
            if ((locator = conf.getSchemaLocator()) == null) {
                LOGGER.fine("No schema locator for " + conf.getNamespaceURI());
                continue;
            }
            String namespaceURI = conf.getNamespaceURI();
            String schemaLocation = null;
            try {
                URL location = new URL(conf.getSchemaFileURL());
                schemaLocation = location.toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("schema location: " + schemaLocation);
            }
            if ((schema = locator.locateSchema(null, namespaceURI, schemaLocation, null)) == null) continue;
            resolvedSchemas.add(schema);
        }
        XSDSchema[] schemas = resolvedSchemas.toArray(new XSDSchema[resolvedSchemas.size()]);
        SchemaIndexImpl index = new SchemaIndexImpl(schemas);
        return index;
    }

    public static List findSchemaLocationResolvers(Configuration configuration2) {
        List all = configuration2.allDependencies();
        ArrayList<XSDSchemaLocationResolver> resolvers = new ArrayList<XSDSchemaLocationResolver>();
        for (Configuration configuration2 : all) {
            XSDSchemaLocationResolver resolver = configuration2.getSchemaLocationResolver();
            if (resolver == null) continue;
            resolvers.add(resolver);
        }
        return resolvers;
    }

    public static final XSDSchema parse(String location) throws IOException {
        return Schemas.parse(location, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public static final XSDSchema parse(String location, XSDSchemaLocator[] locators, XSDSchemaLocationResolver[] resolvers) throws IOException {
        return Schemas.parse(location, locators != null ? Arrays.asList(locators) : Collections.EMPTY_LIST, resolvers != null ? Arrays.asList(resolvers) : Collections.EMPTY_LIST);
    }

    public static final XSDSchema parse(String location, List locators, List resolvers) throws IOException {
        return Schemas.parse(location, locators, resolvers, null);
    }

    public static final XSDSchema parse(String location, List locators, List resolvers, List<URIHandler> uriHandlers) throws IOException {
        AdapterFactoryImpl adapterFactory;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (resolvers != null && !resolvers.isEmpty()) {
            adapterFactory = new SchemaLocationResolverAdapterFactory(resolvers);
            resourceSet.getAdapterFactories().add((Object)adapterFactory);
        }
        if (locators != null && !locators.isEmpty()) {
            adapterFactory = new SchemaLocatorAdapterFactory(locators);
            resourceSet.getAdapterFactories().add((Object)adapterFactory);
        }
        if (uriHandlers != null && !uriHandlers.isEmpty()) {
            resourceSet.getURIConverter().getURIHandlers().addAll(0, uriHandlers);
        }
        return Schemas.parse(location, (ResourceSet)resourceSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final XSDSchema parse(String location, ResourceSet resourceSet) throws IOException {
        File locationFile = null;
        try {
            locationFile = DataUtilities.urlToFile(new URL(location));
        }
        catch (MalformedURLException e) {
            locationFile = new File(location);
        }
        if (locationFile != null && locationFile.exists()) {
            location = locationFile.getCanonicalFile().toURI().toString();
        }
        URI uri = URI.createURI((String)location);
        XSDResourceImpl xsdMainResource = (XSDResourceImpl)resourceSet.createResource(URI.createURI((String)".xsd"));
        xsdMainResource.setURI(uri);
        Class<Schemas> clazz = Schemas.class;
        synchronized (Schemas.class) {
            xsdMainResource.load(resourceSet.getLoadOptions());
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return xsdMainResource.getSchema();
        }
    }

    public static final XSDImport importSchema(XSDSchema schema, final XSDSchema importee) throws IOException {
        Resource resource = schema.eResource();
        if (resource == null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resource = (XSDResourceImpl)resourceSet.createResource(URI.createURI((String)".xsd"));
            resource.getContents().add((Object)schema);
        }
        XSDImport imprt = XSDFactory.eINSTANCE.createXSDImport();
        imprt.setNamespace(importee.getTargetNamespace());
        schema.getContents().add((Object)imprt);
        ArrayList<1> locators = new ArrayList<1>();
        locators.add(new XSDSchemaLocator(){

            public XSDSchema locateSchema(XSDSchema xsdSchema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
                if (importee.getTargetNamespace().equals(namespaceURI)) {
                    return importee;
                }
                return null;
            }
        });
        SchemaLocatorAdapterFactory adapterFactory = new SchemaLocatorAdapterFactory(locators);
        resource.getResourceSet().getAdapterFactories().add((Object)adapterFactory);
        return imprt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static final void dispose(XSDSchema schema) {
        Iterator i$ = schema.getContents().iterator();
        while (i$.hasNext()) {
            XSDSchemaDirective directive;
            XSDSchema resolvedSchema;
            XSDSchemaContent content = (XSDSchemaContent)i$.next();
            if (!(content instanceof XSDSchemaDirective) || (resolvedSchema = (directive = (XSDSchemaDirective)content).getResolvedSchema()) == null) continue;
            Class<Schemas> clazz = Schemas.class;
            // MONITORENTER : org.geotools.xml.Schemas.class
            resolvedSchema.getReferencingDirectives().remove((Object)directive);
            for (XSDElementDeclaration dec : resolvedSchema.getElementDeclarations()) {
                if (dec == null) continue;
                ArrayList<XSDElementDeclaration> toRemove = new ArrayList<XSDElementDeclaration>();
                for (XSDElementDeclaration subs : dec.getSubstitutionGroup()) {
                    if (subs == null || subs.getContainer() == null || !subs.getContainer().equals(schema)) continue;
                    toRemove.add(subs);
                }
                dec.getSubstitutionGroup().removeAll(toRemove);
            }
            // MONITOREXIT : clazz
        }
    }

    public static final List validateImportsIncludes(String location) throws IOException {
        return Schemas.validateImportsIncludes(location, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public static final List validateImportsIncludes(String location, XSDSchemaLocator[] locators, XSDSchemaLocationResolver[] resolvers) throws IOException {
        return Schemas.validateImportsIncludes(location, locators != null ? Arrays.asList(locators) : Collections.EMPTY_LIST, resolvers != null ? Arrays.asList(resolvers) : Collections.EMPTY_LIST);
    }

    public static final List validateImportsIncludes(String location, List locators, List resolvers) throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = null;
        try {
            parser = factory.newSAXParser();
        }
        catch (Exception e) {
            throw (IOException)new IOException("could not create parser").initCause(e);
        }
        SchemaImportIncludeValidator validator = new SchemaImportIncludeValidator(locators, resolvers);
        LinkedList<String> q = new LinkedList<String>();
        q.add(location);
        while (!q.isEmpty()) {
            location = (String)q.removeFirst();
            validator.setBaseLocation(location);
            try {
                parser.parse(location, (DefaultHandler)validator);
            }
            catch (SAXException e) {
                throw (IOException)new IOException("parse error").initCause(e);
            }
            if (!validator.errors.isEmpty()) {
                return validator.errors;
            }
            if (validator.next.isEmpty()) continue;
            q.addAll(validator.next);
        }
        return Collections.EMPTY_LIST;
    }

    public static final List getChildElementDeclarations(XSDElementDeclaration element) {
        return Schemas.getChildElementDeclarations(element.getType());
    }

    public static final List getChildElementDeclarations(XSDTypeDefinition type) {
        return Schemas.getChildElementDeclarations(type, true);
    }

    public static final List getChildElementDeclarations(XSDElementDeclaration element, boolean includeParents) {
        return Schemas.getChildElementDeclarations(element.getType(), includeParents);
    }

    public static final XSDParticle getChildElementParticle(XSDTypeDefinition type, String name, boolean includeParents) {
        List particles = Schemas.getChildElementParticles(type, includeParents);
        for (XSDParticle particle : particles) {
            XSDElementDeclaration element = (XSDElementDeclaration)particle.getContent();
            if (element.isElementDeclarationReference()) {
                element.getResolvedElementDeclaration();
            }
            if (!name.equals(element.getName())) continue;
            return particle;
        }
        return null;
    }

    public static final List getChildElementParticles(XSDTypeDefinition type, boolean includeParents) {
        final HashSet contents = new HashSet();
        final ArrayList particles = new ArrayList();
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            @Override
            public boolean visit(XSDTypeDefinition type) {
                if (type instanceof XSDSimpleTypeDefinition) {
                    return true;
                }
                XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)type;
                ElementVisitor visitor = new ElementVisitor(){

                    @Override
                    public void visit(XSDParticle particle) {
                        XSDElementDeclaration element = (XSDElementDeclaration)particle.getContent();
                        if (element.isElementDeclarationReference()) {
                            element = element.getResolvedElementDeclaration();
                        }
                        if (!contents.contains(element)) {
                            contents.add(element);
                            particles.add(particle);
                        }
                    }
                };
                Schemas.visitElements(cType, visitor);
                return true;
            }
        };
        if (includeParents) {
            new TypeWalker().rwalk(type, visitor);
        } else {
            visitor.visit(type);
        }
        return new ArrayList(particles);
    }

    public static final List getAnyElementParticles(XSDTypeDefinition type) {
        final HashSet contents = new HashSet();
        final ArrayList particles = new ArrayList();
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            @Override
            public boolean visit(XSDTypeDefinition type) {
                if (type instanceof XSDSimpleTypeDefinition) {
                    return true;
                }
                XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)type;
                ElementVisitor visitor = new ElementVisitor(){

                    @Override
                    public void visit(XSDParticle particle) {
                        XSDWildcard element = (XSDWildcard)particle.getContent();
                        if (!contents.contains(element)) {
                            contents.add(element);
                            particles.add(particle);
                        }
                    }
                };
                Schemas.visitAnyElements(cType, visitor);
                return true;
            }
        };
        visitor.visit(type);
        return new ArrayList(particles);
    }

    private static void visitAnyElements(XSDComplexTypeDefinition cType, ElementVisitor visitor) {
        if (cType.getContent() == null || cType.getContent() instanceof XSDSimpleTypeDefinition) {
            return;
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.addLast(cType.getContent());
        while (!queue.isEmpty()) {
            XSDParticle particle = (XSDParticle)queue.removeFirst();
            int pType = XSDUtil.nodeType((Node)particle.getElement());
            if (pType == 2) {
                visitor.visit(particle);
                continue;
            }
            XSDModelGroup grp = null;
            switch (pType) {
                case 16: {
                    XSDModelGroupDefinition grpDef = (XSDModelGroupDefinition)particle.getContent();
                    if (grpDef.isModelGroupDefinitionReference()) {
                        grpDef = grpDef.getResolvedModelGroupDefinition();
                    }
                    grp = grpDef.getModelGroup();
                    break;
                }
                case 0: 
                case 7: 
                case 35: {
                    grp = (XSDModelGroup)particle.getContent();
                }
            }
            if (grp == null) continue;
            EList parts = grp.getParticles();
            if (parts.isEmpty()) {
                parts = grp.getContents();
            }
            for (int i = parts.size() - 1; i >= 0; --i) {
                queue.addFirst(parts.get(i));
            }
        }
    }

    public static final List getChildElementDeclarations(XSDTypeDefinition type, boolean includeParents) {
        List particles = Schemas.getChildElementParticles(type, includeParents);
        ArrayList<XSDElementDeclaration> elements = new ArrayList<XSDElementDeclaration>();
        for (XSDParticle particle : particles) {
            XSDElementDeclaration decl = (XSDElementDeclaration)particle.getContent();
            if (decl.isElementDeclarationReference()) {
                decl = decl.getResolvedElementDeclaration();
            }
            elements.add(decl);
        }
        return elements;
    }

    public static final XSDTypeDefinition getBaseTypeDefinition(XSDTypeDefinition type, final QName parentTypeName) {
        final ArrayList found = new ArrayList();
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            @Override
            public boolean visit(XSDTypeDefinition type) {
                if (Schemas.nameMatches((XSDNamedComponent)type, parentTypeName)) {
                    found.add(type);
                    return false;
                }
                return true;
            }
        };
        new TypeWalker().walk(type, visitor);
        return found.isEmpty() ? null : (XSDTypeDefinition)found.get(0);
    }

    public static final boolean isBaseType(XSDElementDeclaration e1, XSDElementDeclaration e2) {
        for (XSDTypeDefinition type = e1.getType(); type != null; type = type.getBaseType()) {
            if (type.equals(e2.getType())) {
                return true;
            }
            if (type.equals(type.getBaseType())) break;
        }
        return false;
    }

    public static final int getMinOccurs(XSDComplexTypeDefinition type, XSDElementDeclaration element) {
        final XSDElementDeclaration fElement = element;
        final ArrayList minOccurs = new ArrayList();
        ElementVisitor visitor = new ElementVisitor(){

            @Override
            public void visit(XSDParticle particle) {
                XSDElementDeclaration decl = (XSDElementDeclaration)particle.getContent();
                if (decl.isElementDeclarationReference()) {
                    decl = decl.getResolvedElementDeclaration();
                }
                if (decl == fElement) {
                    minOccurs.add(new Integer(particle.getMinOccurs()));
                }
            }
        };
        Schemas.visitElements(type, visitor, true);
        if (minOccurs.isEmpty()) {
            throw new IllegalArgumentException("Element: " + element + " not found in type: " + type);
        }
        return (Integer)minOccurs.get(0);
    }

    public static final int getMaxOccurs(XSDComplexTypeDefinition type, XSDElementDeclaration element) {
        final XSDElementDeclaration fElement = element;
        final ArrayList maxOccurs = new ArrayList();
        ElementVisitor visitor = new ElementVisitor(){

            @Override
            public void visit(XSDParticle particle) {
                XSDElementDeclaration decl = (XSDElementDeclaration)particle.getContent();
                if (decl.isElementDeclarationReference()) {
                    decl = decl.getResolvedElementDeclaration();
                }
                if (decl == fElement) {
                    maxOccurs.add(new Integer(particle.getMaxOccurs()));
                }
            }
        };
        Schemas.visitElements(type, visitor, true);
        if (maxOccurs.isEmpty()) {
            throw new IllegalArgumentException("Element: " + element + " not found in type: " + type);
        }
        return (Integer)maxOccurs.get(0);
    }

    private static void visitElements(XSDComplexTypeDefinition cType, ElementVisitor visitor, boolean includeParents) {
        if (includeParents) {
            LinkedList<XSDTypeDefinition> baseTypes = new LinkedList<XSDTypeDefinition>();
            for (XSDTypeDefinition baseType = cType.getBaseType(); baseType != null && baseType != baseType.getBaseType(); baseType = baseType.getBaseType()) {
                if (!(baseType instanceof XSDComplexTypeDefinition)) continue;
                baseTypes.addLast(baseType);
            }
            for (XSDTypeDefinition baseType : baseTypes) {
                Schemas.visitElements((XSDComplexTypeDefinition)baseType, visitor);
            }
        }
        Schemas.visitElements(cType, visitor);
    }

    private static void visitElements(XSDComplexTypeDefinition cType, ElementVisitor visitor) {
        if (cType.getContent() == null || cType.getContent() instanceof XSDSimpleTypeDefinition) {
            return;
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.addLast(cType.getContent());
        while (!queue.isEmpty()) {
            XSDParticle particle = (XSDParticle)queue.removeFirst();
            int pType = XSDUtil.nodeType((Node)particle.getElement());
            if (pType == 11) {
                visitor.visit(particle);
                continue;
            }
            XSDModelGroup grp = null;
            switch (pType) {
                case 16: {
                    XSDModelGroupDefinition grpDef = (XSDModelGroupDefinition)particle.getContent();
                    if (grpDef.isModelGroupDefinitionReference()) {
                        grpDef = grpDef.getResolvedModelGroupDefinition();
                    }
                    grp = grpDef.getModelGroup();
                    break;
                }
                case 0: 
                case 7: 
                case 35: {
                    grp = (XSDModelGroup)particle.getContent();
                }
            }
            if (grp == null) continue;
            EList parts = grp.getParticles();
            if (parts.isEmpty()) {
                parts = grp.getContents();
            }
            for (int i = parts.size() - 1; i >= 0; --i) {
                queue.addFirst(parts.get(i));
            }
        }
    }

    public static final XSDElementDeclaration getChildElementDeclaration(XSDElementDeclaration parent, QName qName) {
        List children = Schemas.getChildElementDeclarations(parent);
        for (XSDElementDeclaration element : children) {
            if (!Schemas.nameMatches((XSDNamedComponent)element, qName)) continue;
            return element;
        }
        ArrayList derived = new ArrayList();
        for (XSDElementDeclaration child : children) {
            derived.addAll(Schemas.getDerivedElementDeclarations(child));
        }
        for (XSDElementDeclaration child : derived) {
            if (!Schemas.nameMatches((XSDNamedComponent)child, qName)) continue;
            return child;
        }
        return null;
    }

    public static final List getDerivedElementDeclarations(XSDElementDeclaration element) {
        EList elements = element.getSchema().getElementDeclarations();
        ArrayList<XSDElementDeclaration> derived = new ArrayList<XSDElementDeclaration>();
        block0: for (XSDElementDeclaration derivee : elements) {
            if (derivee.equals(element)) continue;
            XSDTypeDefinition type = derivee.getType();
            while (true) {
                if (type.equals(element.getType())) {
                    derived.add(derivee);
                    continue block0;
                }
                if (type.equals(type.getBaseType())) continue block0;
                type = type.getBaseType();
            }
        }
        return derived;
    }

    public static final List getAttributeDeclarations(XSDElementDeclaration element) {
        return Schemas.getAttributeDeclarations(element.getType());
    }

    public static final List getAttributeDeclarations(XSDTypeDefinition type) {
        return Schemas.getAttributeDeclarations(type, true);
    }

    public static final List getAttributeDeclarations(XSDTypeDefinition type, boolean includeParents) {
        final ArrayList attributes = new ArrayList();
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            @Override
            public boolean visit(XSDTypeDefinition type) {
                if (type instanceof XSDSimpleTypeDefinition) {
                    return true;
                }
                XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)type;
                EList attContent = cType.getAttributeContents();
                for (XSDAttributeGroupContent content : attContent) {
                    if (content instanceof XSDAttributeUse) {
                        XSDAttributeUse use = (XSDAttributeUse)content;
                        attributes.add(use.getAttributeDeclaration());
                        continue;
                    }
                    if (!(content instanceof XSDAttributeGroupDefinition)) continue;
                    XSDAttributeGroupDefinition attGrp = (XSDAttributeGroupDefinition)content;
                    if (attGrp.isAttributeGroupDefinitionReference()) {
                        attGrp = attGrp.getResolvedAttributeGroupDefinition();
                    }
                    EList uses = attGrp.getAttributeUses();
                    for (XSDAttributeUse use : uses) {
                        attributes.add(use.getAttributeDeclaration());
                    }
                }
                return true;
            }
        };
        if (includeParents) {
            new TypeWalker().walk(type, visitor);
        } else {
            visitor.visit(type);
        }
        return attributes;
    }

    public static final XSDAttributeDeclaration getAttributeDeclaration(XSDElementDeclaration element, QName qName) {
        List atts = Schemas.getAttributeDeclarations(element);
        for (XSDAttributeDeclaration att : atts) {
            if (!Schemas.nameMatches((XSDNamedComponent)att, qName)) continue;
            return att;
        }
        return null;
    }

    public static final List getImports(XSDSchema schema) {
        LinkedList<XSDSchema> queue = new LinkedList<XSDSchema>();
        ArrayList<XSDImport> imports = new ArrayList<XSDImport>();
        HashSet<String> added = new HashSet<String>();
        queue.addLast(schema);
        while (!queue.isEmpty()) {
            schema = (XSDSchema)queue.removeFirst();
            EList contents = schema.getContents();
            for (XSDSchemaContent content : contents) {
                XSDImport imprt;
                if (!(content instanceof XSDImport) || added.contains((imprt = (XSDImport)content).getNamespace())) continue;
                imports.add(imprt);
                added.add(imprt.getNamespace());
                XSDSchema resolvedSchema = imprt.getResolvedSchema();
                if (resolvedSchema == null) {
                    LOGGER.info("Schema import wasn't resolved: " + imprt.getNamespace() + " declared location: " + imprt.getSchemaLocation());
                    continue;
                }
                queue.addLast(resolvedSchema);
            }
        }
        return imports;
    }

    public static final List getIncludes(XSDSchema schema) {
        LinkedList<XSDSchema> queue = new LinkedList<XSDSchema>();
        ArrayList<XSDInclude> includes = new ArrayList<XSDInclude>();
        HashSet<String> added = new HashSet<String>();
        queue.addLast(schema);
        while (!queue.isEmpty()) {
            schema = (XSDSchema)queue.removeFirst();
            EList contents = schema.getContents();
            for (XSDSchemaContent content : contents) {
                XSDInclude include;
                if (!(content instanceof XSDInclude) || added.contains((include = (XSDInclude)content).getSchemaLocation())) continue;
                includes.add(include);
                added.add(include.getSchemaLocation());
                if (include.getIncorporatedSchema() != null) {
                    queue.addLast(include.getIncorporatedSchema());
                    continue;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("include: " + include + " resulted in null schema");
            }
        }
        return includes;
    }

    public static XSDElementDeclaration getElementDeclaration(XSDSchema schema, QName name) {
        for (XSDElementDeclaration element : schema.getElementDeclarations()) {
            if (!element.getTargetNamespace().equals(name.getNamespaceURI()) || !element.getName().equals(name.getLocalPart())) continue;
            return element;
        }
        return null;
    }

    public static final boolean nameMatches(XSDNamedComponent component, QName qName) {
        String ns1 = component.getTargetNamespace();
        String ns2 = qName.getNamespaceURI();
        String n1 = component.getName();
        String n2 = qName.getLocalPart();
        ns1 = "".equals(ns1) ? null : ns1;
        ns2 = "".equals(ns2) ? null : ns2;
        n1 = "".equals(n1) ? null : n1;
        String string = n2 = "".equals(n2) ? null : n2;
        if (ns1 == null && ns2 != null && component.getSchema() != null && "".equals(ns1 = component.getSchema().getTargetNamespace())) {
            ns1 = null;
        }
        return Utilities.equals((Object)ns1, (Object)ns2) && Utilities.equals((Object)n1, (Object)n2);
    }

    public static String getTargetPrefix(XSDSchema schema) {
        String ns = schema.getTargetNamespace();
        Map pre2ns = schema.getQNamePrefixToNamespaceMap();
        for (Map.Entry entry : pre2ns.entrySet()) {
            if (entry.getKey() == null || !entry.getValue().equals(ns)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public static List getComponentInstancesOfType(PicoContainer container, Class clazz) {
        ArrayList instances = new ArrayList();
        while (container != null) {
            List l = container.getComponentInstancesOfType(clazz);
            instances.addAll(l);
            container = container.getParent();
        }
        return instances;
    }

    public static List<ComponentAdapter> getComponentAdaptersOfType(PicoContainer container, Class clazz) {
        ArrayList<ComponentAdapter> instances = new ArrayList<ComponentAdapter>();
        while (container != null) {
            List l = container.getComponentAdaptersOfType(clazz);
            instances.addAll(l);
            container = container.getParent();
        }
        return instances;
    }

    public static void unregisterComponent(PicoContainer container, final Object key) {
        while (container.getParent() != null) {
            container = container.getParent();
        }
        container.accept(new PicoVisitor(){

            public Object traverse(Object node) {
                return null;
            }

            public void visitContainer(PicoContainer container) {
                if (container instanceof MutablePicoContainer) {
                    ((MutablePicoContainer)container).unregisterComponent(key);
                }
            }

            public void visitComponentAdapter(ComponentAdapter adapter) {
            }

            public void visitParameter(Parameter parameter) {
            }
        });
    }

    public static QName getParticleName(XSDParticle particle) {
        XSDElementDeclaration content = (XSDElementDeclaration)particle.getContent();
        if (content.isElementDeclarationReference()) {
            content = content.getResolvedElementDeclaration();
        }
        return new QName(content.getTargetNamespace(), content.getName());
    }

    static {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
    }

    static class SchemaLocationResolverAdapter
    extends AdapterImpl
    implements XSDSchemaLocationResolver {
        List resolvers;

        public SchemaLocationResolverAdapter(List resolvers) {
            this.resolvers = new ArrayList(resolvers);
        }

        public boolean isAdapterForType(Object type) {
            return type == XSDSchemaLocationResolver.class;
        }

        public String resolveSchemaLocation(XSDSchema schema, String namespaceURI, String rawSchemaLocationURI) {
            for (int i = 0; i < this.resolvers.size(); ++i) {
                XSDSchemaLocationResolver resolver = (XSDSchemaLocationResolver)this.resolvers.get(i);
                String resolved = resolver.resolveSchemaLocation(schema, namespaceURI, rawSchemaLocationURI);
                if (resolved == null) continue;
                return resolved;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Could not resolve schema location: " + rawSchemaLocationURI + " to physical location.");
            }
            return null;
        }
    }

    static class SchemaLocationResolverAdapterFactory
    extends AdapterFactoryImpl {
        SchemaLocationResolverAdapter adapter;

        public SchemaLocationResolverAdapterFactory(List resolvers) {
            this.adapter = new SchemaLocationResolverAdapter(resolvers);
        }

        public boolean isFactoryForType(Object type) {
            return type == XSDSchemaLocationResolver.class;
        }

        public Adapter adaptNew(Notifier notifier, Object type) {
            return this.adapter;
        }
    }

    static class SchemaLocatorAdapter
    extends AdapterImpl
    implements XSDSchemaLocator {
        List locators;

        public SchemaLocatorAdapter(List locators) {
            this.locators = new ArrayList(locators);
        }

        public boolean isAdapterForType(Object type) {
            return type == XSDSchemaLocator.class;
        }

        public XSDSchema locateSchema(XSDSchema xsdSchema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
            for (int i = 0; i < this.locators.size(); ++i) {
                XSDSchemaLocator locator = (XSDSchemaLocator)this.locators.get(i);
                XSDSchema schema = locator.locateSchema(xsdSchema, namespaceURI, rawSchemaLocationURI, resolvedSchemaLocationURI);
                if (schema == null) continue;
                return schema;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Could not locate schema for: " + rawSchemaLocationURI + ".");
            }
            return null;
        }
    }

    static class SchemaLocatorAdapterFactory
    extends AdapterFactoryImpl {
        SchemaLocatorAdapter adapter;

        public SchemaLocatorAdapterFactory(List locators) {
            this.adapter = new SchemaLocatorAdapter(locators);
        }

        public boolean isFactoryForType(Object type) {
            return type == XSDSchemaLocator.class;
        }

        public Adapter adaptNew(Notifier notifier, Object type) {
            return this.adapter;
        }
    }

    private static interface ElementVisitor {
        public void visit(XSDParticle var1);
    }

    static final class SchemaImportIncludeValidator
    extends DefaultHandler {
        String baseLocation;
        List locators;
        List resolvers;
        Set seen;
        List errors;
        List next;

        SchemaImportIncludeValidator(List locators, List resolvers) {
            this.locators = locators;
            this.resolvers = resolvers;
            this.seen = new HashSet();
            this.errors = new ArrayList();
            this.next = new ArrayList();
        }

        public void setBaseLocation(String baseLocation) {
            this.baseLocation = baseLocation;
        }

        @Override
        public void startDocument() throws SAXException {
            this.next.clear();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("import".equals(localName)) {
                String namespace = attributes.getValue("namespace");
                String schemaLocation = attributes.getValue("schemaLocation");
                if (this.seen.contains(namespace)) {
                    return;
                }
                this.seen.add(namespace);
                if (schemaLocation != null) {
                    for (XSDSchemaLocator locator : this.locators) {
                        if (!(locator instanceof SchemaLocator) || !((SchemaLocator)locator).canHandle(null, namespace, schemaLocation, null)) continue;
                        return;
                    }
                    String resolvedSchemaLocation = this.resolve(namespace, schemaLocation);
                    if (resolvedSchemaLocation != null) {
                        this.recurse(resolvedSchemaLocation);
                    } else {
                        this.errors.add("Could not resolve import: " + namespace + "," + schemaLocation);
                    }
                } else {
                    this.errors.add("No schemaLocation attribute for namespace import: " + namespace);
                }
            } else if ("include".equals(localName)) {
                String location = attributes.getValue("location");
                String resolvedLocation = this.resolve(null, location);
                if (resolvedLocation != null) {
                    this.recurse(resolvedLocation);
                } else {
                    this.errors.add("Could not resolve include: " + location);
                }
            }
        }

        String resolve(String namespace, String location) {
            File dir;
            for (XSDSchemaLocationResolver resolver : this.resolvers) {
                String resolvedSchemaLocation;
                if (!(resolver instanceof SchemaLocationResolver) || !((SchemaLocationResolver)resolver).canHandle(null, namespace, location) || (resolvedSchemaLocation = resolver.resolveSchemaLocation(null, namespace, location)) == null) continue;
                return resolvedSchemaLocation;
            }
            File file = new File(location);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            if (!file.isAbsolute() && (dir = new File(this.baseLocation).getParentFile()) != null && (file = new File(dir, location)).exists()) {
                return file.getAbsolutePath();
            }
            return null;
        }

        void recurse(String location) {
            if (this.seen.contains(location)) {
                return;
            }
            this.seen.add(location);
            this.next.add(location);
        }
    }
}

