/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.gpsblam;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.gpsblam.GPSBlamInputData;

public class GPSBlamMarker {
    private CachedLatLon mean;
    private CachedLatLon hair1Coord1;
    private CachedLatLon hair1Coord2;
    private CachedLatLon hair2Coord1;
    private CachedLatLon hair2Coord2;
    private CachedLatLon ellipseCoord1;
    private CachedLatLon ellipseCoord2;
    private CachedLatLon ellipseCoord3;
    private int ndays;
    static final double fac = 2.45;

    public GPSBlamMarker(GPSBlamInputData inputData) {
        double mean_east = 0.0;
        double mean_north = 0.0;
        for (CachedLatLon cll : inputData) {
            EastNorth en = cll.getEastNorth();
            mean_east += en.east();
            mean_north += en.north();
        }
        double n = inputData.size();
        mean_east /= n;
        mean_north /= n;
        double ca = 0.0;
        double cb = 0.0;
        double cc = 0.0;
        double cd = 0.0;
        for (CachedLatLon cll : inputData) {
            EastNorth en = cll.getEastNorth();
            double deast = en.east() - mean_east;
            double dnorth = en.north() - mean_north;
            ca += deast * deast;
            cb += deast * dnorth;
            cd += dnorth * dnorth;
        }
        cc = cb;
        double T = (ca /= n) + (cd /= n);
        double D = ca * cd - (cb /= n) * (cc /= n);
        double variance1 = 0.5 * T + Math.sqrt(0.25 * T * T - D);
        double variance2 = 0.5 * T - Math.sqrt(0.25 * T * T - D);
        double evec1_east = variance1 - cd;
        double evec1_north = cc;
        double evec2_east = variance2 - cd;
        double evec2_north = cc;
        double evec1_fac = Math.sqrt(variance1) / Math.sqrt(evec1_east * evec1_east + evec1_north * evec1_north);
        double evec2_fac = Math.sqrt(variance2) / Math.sqrt(evec2_east * evec2_east + evec2_north * evec2_north);
        double sigma1_east = evec1_east * evec1_fac;
        double sigma1_north = evec1_north * evec1_fac;
        double sigma2_east = evec2_east * evec2_fac;
        double sigma2_north = evec2_north * evec2_fac;
        Projection proj = Main.getProjection();
        this.mean = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(mean_east, mean_north)));
        this.hair1Coord1 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(mean_east - sigma1_east * 2.45, mean_north - sigma1_north * 2.45)));
        this.hair1Coord2 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(mean_east + sigma1_east * 2.45, mean_north + sigma1_north * 2.45)));
        this.hair2Coord1 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(mean_east - sigma2_east * 2.45, mean_north - sigma2_north * 2.45)));
        this.hair2Coord2 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(mean_east + sigma2_east * 2.45, mean_north + sigma2_north * 2.45)));
        double efac = 2.45 / Math.sqrt(inputData.getNDays());
        this.ellipseCoord1 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(mean_east + (-sigma1_east + sigma2_east) * efac, mean_north + (-sigma1_north + sigma2_north) * efac)));
        this.ellipseCoord2 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(mean_east + (sigma1_east + sigma2_east) * efac, mean_north + (sigma1_north + sigma2_north) * efac)));
        this.ellipseCoord3 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(mean_east + (-sigma1_east - sigma2_east) * efac, mean_north + (-sigma1_north - sigma2_north) * efac)));
    }

    public void paint(Graphics2D g, MapView mv) {
        g.setColor(Color.GREEN);
        g.setPaintMode();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(2.0f));
        Point hair1Point1 = mv.getPoint(this.hair1Coord1.getEastNorth());
        Point hair1Point2 = mv.getPoint(this.hair1Coord2.getEastNorth());
        Point hair2Point1 = mv.getPoint(this.hair2Coord1.getEastNorth());
        Point hair2Point2 = mv.getPoint(this.hair2Coord2.getEastNorth());
        g.drawLine(hair1Point1.x, hair1Point1.y, hair1Point2.x, hair1Point2.y);
        g.drawLine(hair2Point1.x, hair2Point1.y, hair2Point2.x, hair2Point2.y);
        Point2D meanPoint = mv.getPoint2D(this.mean.getEastNorth());
        Point2D ellipsePoint1 = mv.getPoint2D(this.ellipseCoord1.getEastNorth());
        Point2D ellipsePoint2 = mv.getPoint2D(this.ellipseCoord2.getEastNorth());
        Point2D ellipsePoint3 = mv.getPoint2D(this.ellipseCoord3.getEastNorth());
        double majorAxis = ellipsePoint2.distance(ellipsePoint1);
        double minorAxis = ellipsePoint3.distance(ellipsePoint1);
        double angle = -Math.atan2(-(ellipsePoint2.getY() - ellipsePoint1.getY()), ellipsePoint2.getX() - ellipsePoint1.getX());
        Ellipse2D.Double e = new Ellipse2D.Double(meanPoint.getX() - majorAxis * 0.5, meanPoint.getY() - minorAxis * 0.5, majorAxis, minorAxis);
        g.rotate(angle, meanPoint.getX(), meanPoint.getY());
        g.draw(e);
        g.rotate(-angle, meanPoint.getX(), meanPoint.getY());
    }
}

