/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.fixtures;

import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;

public class JOSMFixture {
    private static final Logger logger = Logger.getLogger(JOSMFixture.class.getName());
    private Properties testProperties;
    private String testPropertiesResourceName;

    public static JOSMFixture createUnitTestFixture() {
        return new JOSMFixture("/test-unit-env.properties");
    }

    public JOSMFixture(String testPropertiesResourceName) {
        this.testPropertiesResourceName = testPropertiesResourceName;
    }

    public void init() {
        this.testProperties = new Properties();
        try {
            this.testProperties.load(JOSMFixture.class.getResourceAsStream(this.testPropertiesResourceName));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, MessageFormat.format("failed to load property file ''{0}''", this.testPropertiesResourceName));
            Assert.fail((String)MessageFormat.format("failed to load property file ''{0}''. \nMake sure the path ''$project_root/test/config'' is on the classpath.", this.testPropertiesResourceName));
        }
        String josmHome = this.testProperties.getProperty("josm.home");
        if (josmHome == null) {
            Assert.fail((String)MessageFormat.format("property ''{0}'' not set in test environment", "josm.home"));
        } else {
            File f = new File(josmHome);
            if (!f.exists() || !f.canRead()) {
                Assert.fail((String)MessageFormat.format("property ''{0}'' points to ''{1}'' which is either not existing or not readable.\nEdit ''{2}'' and update the value ''josm.home''. ", "josm.home", josmHome, this.testPropertiesResourceName));
            }
        }
        System.setProperty("josm.home", josmHome);
        Main.pref = new Preferences();
        I18n.init();
        Main.determinePlatformHook();
        Main.platform.preStartupHook();
        Main.pref.init(false);
        Main.setProjection((Projection)Projections.getProjectionByCode((String)"EPSG:3857"));
        String url = OsmApi.getOsmApi().getBaseUrl().toLowerCase().trim();
        if (url.startsWith("http://www.openstreetmap.org") || url.startsWith("http://api.openstreetmap.org")) {
            Assert.fail((String)MessageFormat.format("configured server url ''{0}'' seems to be a productive url, aborting.", url));
        }
    }
}

