/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ComboBoxModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionType;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TurnRestrictionComboBoxModel
implements ComboBoxModel,
Observer {
    private TurnRestrictionEditorModel model;
    private final List<Object> values = new ArrayList<Object>();
    private String selectedTagValue = null;
    private final transient EventListenerList listeners = new EventListenerList();

    protected void populate() {
        this.values.clear();
        TurnRestrictionType[] turnRestrictionTypeArray = TurnRestrictionType.values();
        int n = turnRestrictionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TurnRestrictionType type = turnRestrictionTypeArray[n2];
            this.values.add((Object)type);
            ++n2;
        }
        String tagValue = this.model.getRestrictionTagValue();
        if (tagValue.trim().equals("")) {
            this.selectedTagValue = null;
        } else {
            TurnRestrictionType type = TurnRestrictionType.fromTagValue(tagValue);
            if (type == null) {
                this.values.add(0, tagValue);
                this.selectedTagValue = tagValue;
            } else {
                this.selectedTagValue = type.getTagValue();
            }
        }
        this.fireContentsChanged();
    }

    public TurnRestrictionComboBoxModel(TurnRestrictionEditorModel model) {
        CheckParameterUtil.ensureParameterNotNull((Object)model, (String)"model");
        this.model = model;
        model.addObserver(this);
        this.populate();
    }

    @Override
    public Object getSelectedItem() {
        TurnRestrictionType type = TurnRestrictionType.fromTagValue(this.selectedTagValue);
        if (type != null) {
            return type;
        }
        return this.selectedTagValue;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        String tagValue = null;
        if (anItem instanceof String) {
            tagValue = (String)anItem;
        } else if (anItem instanceof TurnRestrictionType) {
            tagValue = ((TurnRestrictionType)((Object)anItem)).getTagValue();
        }
        this.model.setRestrictionTagValue(tagValue);
    }

    @Override
    public Object getElementAt(int index) {
        return this.values.get(index);
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(ListDataListener.class, l);
    }

    protected void fireContentsChanged() {
        ListDataListener[] listDataListenerArray = (ListDataListener[])this.listeners.getListeners(ListDataListener.class);
        int n = listDataListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ListDataListener l = listDataListenerArray[n2];
            l.contentsChanged(new ListDataEvent(this, 0, 0, this.getSize()));
            ++n2;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        String tagValue = this.model.getRestrictionTagValue();
        if (tagValue == null && this.selectedTagValue != null) {
            this.populate();
        } else if (tagValue != null && this.selectedTagValue == null) {
            this.populate();
        } else if (tagValue != null && !tagValue.equals(this.selectedTagValue)) {
            this.populate();
        }
    }
}

