/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.gui.action.AddCommentAction;
import org.openstreetmap.josm.plugins.osb.gui.action.CloseIssueAction;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbAction;

public class OsbQueueListCellRenderer
implements ListCellRenderer {
    private Color background = Color.WHITE;
    private Color altBackground = new Color(250, 250, 220);

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = new JLabel();
        label.setOpaque(true);
        if (isSelected) {
            label.setForeground(UIManager.getColor("List.selectionForeground"));
            label.setBackground(UIManager.getColor("List.selectionBackground"));
        } else {
            label.setForeground(UIManager.getColor("List.foreground"));
            label.setBackground(index % 2 == 0 ? this.background : this.altBackground);
        }
        OsbAction action = (OsbAction)value;
        ImageIcon icon = null;
        if (action instanceof AddCommentAction) {
            icon = OsbPlugin.loadIcon("add_comment16.png");
        } else if (action instanceof CloseIssueAction) {
            icon = OsbPlugin.loadIcon("icon_valid16.png");
        }
        label.setIcon(icon);
        String text = action.toString();
        if (text.indexOf("<hr />") > 0) {
            text = text.substring(0, text.indexOf("<hr />"));
        }
        label.setText("<html>" + text + "</html>");
        Dimension d = label.getPreferredSize();
        d.height += 10;
        label.setPreferredSize(d);
        return label;
    }
}

