/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb;

import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.tools.I18n;

public class OsbDownloadLoop
extends Thread {
    private static OsbDownloadLoop instance;
    private long countdown = TimeUnit.SECONDS.toMillis(1L);
    private boolean downloadDone = false;
    private final int INTERVAL = 100;
    private OsbPlugin plugin;
    private EastNorth lastCenter;

    public OsbDownloadLoop() {
        this.setName(I18n.tr((String)"OpenStreetBugs download loop", (Object[])new Object[0]));
        this.start();
    }

    public static synchronized OsbDownloadLoop getInstance() {
        if (instance == null) {
            instance = new OsbDownloadLoop();
        }
        return instance;
    }

    @Override
    public void run() {
        try {
            while (true) {
                EastNorth currentCenter;
                this.countdown -= 100L;
                if (Main.map != null && Main.map.mapView != null && (currentCenter = Main.map.mapView.getCenter()) != null && !currentCenter.equals((Object)this.lastCenter)) {
                    this.resetCountdown();
                    this.lastCenter = currentCenter;
                }
                if (Main.pref.getBoolean("osb.auto_download") && !Main.pref.getBoolean("osb.api.offline") && this.plugin != null && this.plugin.getDialog() != null && this.plugin.getDialog().isDialogShowing() && this.countdown < 0L) {
                    if (!this.downloadDone) {
                        if (this.plugin != null) {
                            this.plugin.updateData();
                            this.downloadDone = true;
                        }
                    } else {
                        this.countdown = -1L;
                    }
                }
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public void resetCountdown() {
        this.downloadDone = false;
        this.countdown = TimeUnit.SECONDS.toMillis(1L);
    }

    public void setPlugin(OsbPlugin plugin) {
        this.plugin = plugin;
    }
}

