/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0.parsers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.logging.Logger;
import net.opengis.wfs.GetFeatureType;
import org.eclipse.emf.ecore.EObject;
import org.geotools.data.wfs.protocol.wfs.WFSResponse;
import org.geotools.data.wfs.protocol.wfs.WFSResponseParser;
import org.geotools.data.wfs.protocol.wfs.WFSResponseParserFactory;
import org.geotools.data.wfs.v1_1_0.WFS_1_1_0_DataStore;
import org.geotools.data.wfs.v1_1_0.parsers.ExceptionReportParser;
import org.geotools.data.wfs.v1_1_0.parsers.FeatureCollectionParser;
import org.geotools.util.logging.Logging;

public class Gml31GetFeatureResponseParserFactory
implements WFSResponseParserFactory {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");
    private static final String SUPPORTED_OUTPUT_FORMAT1 = "text/xml; subtype=gml/3.1.1";
    private static final String SUPPORTED_OUTPUT_FORMAT2 = "GML3";

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean canProcess(EObject request) {
        if (!(request instanceof GetFeatureType)) {
            return false;
        }
        String outputFormat = ((GetFeatureType)request).getOutputFormat();
        boolean matches = this.isSupportedOutputFormat(outputFormat);
        return matches;
    }

    protected boolean isSupportedOutputFormat(String outputFormat) {
        boolean matches = SUPPORTED_OUTPUT_FORMAT1.equals(outputFormat) || SUPPORTED_OUTPUT_FORMAT2.equals(outputFormat);
        return matches;
    }

    @Override
    public WFSResponseParser createParser(WFS_1_1_0_DataStore wfs, WFSResponse response) throws IOException {
        WFSResponseParser parser;
        String contentType = response.getContentType();
        if (this.isSupportedOutputFormat(contentType)) {
            parser = new FeatureCollectionParser();
        } else {
            String line;
            int r;
            int buffSize = 256;
            PushbackInputStream pushbackIn = new PushbackInputStream(response.getInputStream(), 256);
            byte[] buff = new byte[256];
            int readCount = 0;
            while ((r = pushbackIn.read(buff, readCount, 256 - readCount)) != -1 && (readCount += r) != 256) {
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buff), response.getCharacterEncoding()));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
            String head = sb.toString();
            LOGGER.fine("response head: " + head);
            pushbackIn.unread(buff, 0, readCount);
            response.setInputStream(pushbackIn);
            if (head.contains("FeatureCollection")) {
                parser = new FeatureCollectionParser();
            } else if (head.contains("ExceptionReport")) {
                parser = new ExceptionReportParser();
            } else {
                throw new IllegalStateException("Unkown server response: " + head);
            }
        }
        return parser;
    }
}

