/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.ows10.KeywordsType;
import org.eclipse.emf.common.util.EList;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultFeatureResults;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.data.wfs.v1_0_0.FeatureSetDescription;
import org.geotools.data.wfs.v1_0_0.WFSCapabilities;
import org.geotools.data.wfs.v1_0_0.WFS_1_0_0_DataStore;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WFSFeatureSource
extends AbstractFeatureSource
implements SimpleFeatureSource {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");
    protected WFS_1_0_0_DataStore ds;
    protected String fname;
    private FeatureSetDescription featureSetDescription;

    protected WFSFeatureSource(WFS_1_0_0_DataStore ds, String fname) {
        this.ds = ds;
        this.fname = fname;
        this.featureSetDescription = WFSCapabilities.getFeatureSetDescription(ds.getCapabilities(), fname);
    }

    @Override
    public Set getSupportedHints() {
        return super.getSupportedHints();
    }

    @Override
    public Name getName() {
        if (this.featureSetDescription != null && this.featureSetDescription.getNamespace() != null) {
            return new NameImpl(this.featureSetDescription.getNamespace().toString(), this.fname);
        }
        return new NameImpl(this.fname);
    }

    @Override
    public ResourceInfo getInfo() {
        return new ResourceInfo(){

            @Override
            public ReferencedEnvelope getBounds() {
                try {
                    return WFSFeatureSource.this.ds.getBounds(new Query(WFSFeatureSource.this.fname));
                }
                catch (IOException e) {
                    return new ReferencedEnvelope();
                }
            }

            @Override
            public CoordinateReferenceSystem getCRS() {
                try {
                    return CRS.decode((String)WFSFeatureSource.this.featureSetDescription.getSRS());
                }
                catch (NoSuchAuthorityCodeException e) {
                    LOGGER.log(Level.INFO, e.getMessage(), e);
                }
                catch (FactoryException e) {
                    LOGGER.log(Level.INFO, e.getMessage(), e);
                }
                return null;
            }

            @Override
            public String getDescription() {
                return WFSFeatureSource.this.featureSetDescription.getAbstract();
            }

            @Override
            public Set<String> getKeywords() {
                return this.extractKeywords(WFSFeatureSource.this.featureSetDescription.getKeywords());
            }

            private Set<String> extractKeywords(List<?> keywordsList) {
                HashSet<String> keywords = new HashSet<String>();
                if (keywordsList != null) {
                    for (Object keys : keywordsList) {
                        if (keys instanceof KeywordsType) {
                            EList kws = ((KeywordsType)keys).getKeyword();
                            for (String kw : kws) {
                                if (kw == null || kw.trim().length() <= 0) continue;
                                keywords.add(kw);
                            }
                            continue;
                        }
                        if (!(keys instanceof String)) continue;
                        keywords.add((String)keys);
                    }
                }
                return keywords;
            }

            @Override
            public String getName() {
                return WFSFeatureSource.this.fname;
            }

            @Override
            public URI getSchema() {
                try {
                    return WFSFeatureSource.this.ds.protocolHandler.getDescribeFeatureTypeURLGet(WFSFeatureSource.this.fname).toURI();
                }
                catch (MalformedURLException e) {
                    return null;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            @Override
            public String getTitle() {
                String title = WFSFeatureSource.this.featureSetDescription.getTitle();
                if (null == title || title.trim().length() == 0) {
                    title = this.getName();
                }
                return title;
            }
        };
    }

    public DataStore getDataStore() {
        return this.ds;
    }

    @Override
    public void addFeatureListener(FeatureListener listener) {
        this.ds.listenerManager.addFeatureListener((FeatureSource)this, listener);
    }

    @Override
    public void removeFeatureListener(FeatureListener listener) {
        this.ds.listenerManager.removeFeatureListener((FeatureSource)this, listener);
    }

    @Override
    public SimpleFeatureType getSchema() {
        try {
            return this.ds.getSchema(this.fname);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(this.fname == null ? Query.ALL : new Query(this.fname));
    }

    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.ds.getBounds(this.namedQuery(query));
    }

    @Override
    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures(new Query(this.getSchema().getTypeName(), (Filter)Filter.INCLUDE));
    }

    @Override
    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new Query(this.getSchema().getTypeName(), filter));
    }

    @Override
    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        SimpleFeatureType schema = this.getSchema();
        String typeName = schema.getTypeName();
        if (query.getTypeName() == null) {
            Query Query2 = new Query(query);
            Query2.setTypeName(typeName);
            query = Query2;
        }
        if (!typeName.equals(query.getTypeName())) {
            return new EmptyFeatureCollection(schema);
        }
        return new DefaultFeatureResults((SimpleFeatureSource)this, query);
    }

    public Transaction getTransaction() {
        return Transaction.AUTO_COMMIT;
    }

    public static class WFSFeatureResults
    extends DefaultFeatureResults {
        private WFSFeatureSource fs;
        private Query query;

        public WFSFeatureResults(WFSFeatureSource fs, Query query) throws IOException {
            super((SimpleFeatureSource)fs, query);
            this.query = query;
            this.fs = fs;
        }

        public SimpleFeatureType getSchema() {
            return this.fs.getSchema();
        }

        public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
            return this.fs.ds.getFeatureReader(this.query, this.fs.getTransaction());
        }

        public ReferencedEnvelope getBounds() {
            try {
                return this.fs.getBounds(this.query);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getCount() throws IOException {
            return this.fs.getCount(this.query);
        }
    }
}

