/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.proposal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.czechaddress.PrimUtils;
import org.openstreetmap.josm.plugins.czechaddress.proposal.Proposal;

public class ProposalContainer
implements ListModel,
Comparable<ProposalContainer> {
    private List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    protected OsmPrimitive target;
    protected List<Proposal> proposals = new ArrayList<Proposal>();

    public ProposalContainer(OsmPrimitive target) {
        this.target = target;
    }

    public void setTarget(OsmPrimitive newTarget) {
        this.target = newTarget;
    }

    public OsmPrimitive getTarget() {
        return this.target;
    }

    public void addProposal(Proposal a) {
        this.proposals.add(a);
        ListDataEvent evt = new ListDataEvent(this, 1, this.proposals.size() - 1, this.proposals.size() - 1);
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(evt);
        }
    }

    public void addProposals(Collection<Proposal> a) {
        int index1 = this.proposals.size();
        this.proposals.addAll(a);
        int index2 = this.proposals.size() - 1;
        ListDataEvent evt = new ListDataEvent(this, 1, index1, index2);
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(evt);
        }
    }

    public void removeProposal(Proposal proposal) {
        int index = this.proposals.indexOf(proposal);
        if (index == -1) {
            return;
        }
        this.proposals.remove(index);
        ListDataEvent evt = new ListDataEvent(this, 2, index, index);
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(evt);
        }
    }

    public void setProposals(List<Proposal> proposals) {
        this.proposals = proposals;
        ListDataEvent evt = new ListDataEvent(this, 0, 0, proposals.size() - 1);
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(evt);
        }
    }

    public List<Proposal> getProposals() {
        return this.proposals;
    }

    public void clear() {
        ListDataEvent evt = new ListDataEvent(this, 2, 0, this.proposals.size() - 1);
        this.proposals.clear();
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(evt);
        }
    }

    public void applyAll() {
        for (Proposal proposal : this.proposals) {
            proposal.apply(this.target);
        }
    }

    public String toString() {
        return this.target.toString();
    }

    @Override
    public int getSize() {
        return this.proposals.size();
    }

    public Object getElementAt(int index) {
        return this.proposals.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    @Override
    public int compareTo(ProposalContainer o) {
        return PrimUtils.comparator.compare(this.target, o.target);
    }
}

