/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.imageutils;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import org.jaitools.imageutils.AbstractSimpleIterator;

public class WritableSimpleIterator
extends AbstractSimpleIterator {
    public WritableSimpleIterator(WritableRenderedImage image, Rectangle bounds, Number outsideValue) {
        super(new Helper(), image, bounds, outsideValue, AbstractSimpleIterator.Order.IMAGE_X_Y);
    }

    public boolean setSample(Number value) {
        return this.setSample(0, value);
    }

    public boolean setSample(Point pos, Number value) {
        if (pos == null) {
            throw new IllegalArgumentException("pos must not be null");
        }
        return this.setSample(pos.x, pos.y, value);
    }

    public boolean setSample(int x, int y, Number value) {
        return this.setPos(x, y) && this.setSample(value);
    }

    public boolean setSample(int band, Number value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (this.isInsideDelegateBounds()) {
            WritableRenderedImage image = (WritableRenderedImage)this.imageRef.get();
            if (image == null) {
                throw new IllegalStateException("Target image has been deleted");
            }
            WritableRectIter writableIter = (WritableRectIter)this.delegateIter;
            switch (this.imageDataType) {
                case 5: {
                    writableIter.setSample(band, value.doubleValue());
                    break;
                }
                case 4: {
                    writableIter.setSample(band, value.floatValue());
                    break;
                }
                default: {
                    writableIter.setSample(band, value.intValue());
                }
            }
            return true;
        }
        return false;
    }

    public boolean setSample(Point pos, int band, Number value) {
        if (pos == null) {
            throw new IllegalArgumentException("pos must not be null");
        }
        return this.setSample(pos.x, pos.y, band, value);
    }

    public boolean setSample(int x, int y, int band, Number value) {
        return this.setPos(x, y) && this.setSample(band, value);
    }

    private static class Helper
    implements AbstractSimpleIterator.DelegateHelper {
        private Helper() {
        }

        public RectIter create(RenderedImage image, Rectangle bounds) {
            if (image == null) {
                throw new IllegalArgumentException("image must not be null");
            }
            if (!(image instanceof WritableRenderedImage)) {
                throw new IllegalArgumentException("image must be a WritableRenderedImage");
            }
            if (bounds == null || bounds.isEmpty()) {
                return null;
            }
            return RectIterFactory.createWritable((WritableRenderedImage)((WritableRenderedImage)image), (Rectangle)bounds);
        }
    }
}

