/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultFeatureResults;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Diff;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractFeatureSource
implements SimpleFeatureSource {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.data");
    protected Set hints = Collections.EMPTY_SET;
    protected QueryCapabilities queryCapabilities;

    public AbstractFeatureSource() {
        this.queryCapabilities = new QueryCapabilities();
    }

    public abstract DataStore getDataStore();

    @Override
    public Name getName() {
        return ((SimpleFeatureType)this.getSchema()).getName();
    }

    public AbstractFeatureSource(Set hints) {
        this.hints = Collections.unmodifiableSet(new HashSet(hints));
        this.queryCapabilities = new QueryCapabilities(){

            @Override
            public boolean isUseProvidedFIDSupported() {
                return AbstractFeatureSource.this.hints.contains(Hints.USE_PROVIDED_FID);
            }
        };
    }

    @Override
    public ResourceInfo getInfo() {
        return new ResourceInfo(){
            final Set<String> words = new HashSet<String>();
            {
                this.words.add("features");
                this.words.add(((SimpleFeatureType)AbstractFeatureSource.this.getSchema()).getTypeName());
            }

            @Override
            public ReferencedEnvelope getBounds() {
                try {
                    return AbstractFeatureSource.this.getBounds();
                }
                catch (IOException e) {
                    return null;
                }
            }

            @Override
            public CoordinateReferenceSystem getCRS() {
                return ((SimpleFeatureType)AbstractFeatureSource.this.getSchema()).getCoordinateReferenceSystem();
            }

            @Override
            public String getDescription() {
                return null;
            }

            @Override
            public Set<String> getKeywords() {
                return this.words;
            }

            @Override
            public String getName() {
                return ((SimpleFeatureType)AbstractFeatureSource.this.getSchema()).getTypeName();
            }

            @Override
            public URI getSchema() {
                Name name = ((SimpleFeatureType)AbstractFeatureSource.this.getSchema()).getName();
                try {
                    URI namespace = new URI(name.getNamespaceURI());
                    return namespace;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            @Override
            public String getTitle() {
                Name name = ((SimpleFeatureType)AbstractFeatureSource.this.getSchema()).getName();
                return name.getLocalPart();
            }
        };
    }

    @Override
    public QueryCapabilities getQueryCapabilities() {
        return this.queryCapabilities;
    }

    public Transaction getTransaction() {
        return Transaction.AUTO_COMMIT;
    }

    @Override
    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        SimpleFeatureType schema = (SimpleFeatureType)this.getSchema();
        String typeName = schema.getTypeName();
        if (query.getTypeName() == null) {
            DefaultQuery defaultQuery = new DefaultQuery(query);
            defaultQuery.setTypeName(typeName);
        } else if (!typeName.equals(query.getTypeName())) {
            return new EmptyFeatureCollection(schema);
        }
        QueryCapabilities queryCapabilities = this.getQueryCapabilities();
        if (!queryCapabilities.supportsSorting(query.getSortBy())) {
            throw new DataSourceException("DataStore cannot provide the requested sort order");
        }
        DefaultFeatureResults collection = new DefaultFeatureResults(this, query);
        if (((SimpleFeatureType)collection.getSchema()).getGeometryDescriptor() == null) {
            return collection;
        }
        return collection;
    }

    @Override
    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new DefaultQuery(((SimpleFeatureType)this.getSchema()).getTypeName(), filter));
    }

    @Override
    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Filter.INCLUDE);
    }

    @Override
    public ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(this.getSchema() == null ? Query.ALL : new DefaultQuery(((SimpleFeatureType)this.getSchema()).getTypeName()));
    }

    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException {
        if (query.getFilter() == Filter.EXCLUDE) {
            return new ReferencedEnvelope(new Envelope(), ((SimpleFeatureType)this.getSchema()).getCoordinateReferenceSystem());
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || !(dataStore instanceof AbstractDataStore)) {
            return null;
        }
        return ((AbstractDataStore)dataStore).getBounds(this.namedQuery(query));
    }

    protected Query namedQuery(Query query) {
        String typeName = ((SimpleFeatureType)this.getSchema()).getTypeName();
        if (query.getTypeName() == null || !query.getTypeName().equals(typeName)) {
            return new DefaultQuery(typeName, query.getFilter(), query.getMaxFeatures(), query.getPropertyNames(), query.getHandle());
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount(Query query) throws IOException {
        if (query.getFilter() == Filter.EXCLUDE) {
            return 0;
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || !(dataStore instanceof AbstractDataStore)) {
            return -1;
        }
        Transaction t = this.getTransaction();
        int nativeCount = ((AbstractDataStore)dataStore).getCount(this.namedQuery(query));
        if (nativeCount == -1) {
            return -1;
        }
        int delta = 0;
        if (t != Transaction.AUTO_COMMIT) {
            Diff diff;
            if (t.getState(dataStore) == null) {
                return nativeCount;
            }
            if (!(t.getState(dataStore) instanceof TransactionStateDiff)) {
                return -1;
            }
            Diff diff2 = diff = ((AbstractDataStore)dataStore).state(t).diff(this.namedQuery(query).getTypeName());
            synchronized (diff2) {
                for (SimpleFeature feature : diff.getAdded().values()) {
                    if (!query.getFilter().evaluate(feature)) continue;
                    ++delta;
                }
                for (SimpleFeature feature : diff.getModified().values()) {
                    if (feature != TransactionStateDiff.NULL || !query.getFilter().evaluate(feature)) continue;
                    --delta;
                }
            }
        }
        return nativeCount + delta;
    }

    @Override
    public Set getSupportedHints() {
        return this.hints;
    }
}

