/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.tools.I18n;
import public_transport.StopImporterAction;
import public_transport.StopImporterDialog;
import public_transport.TrackStoplistTableModel;
import public_transport.TransText;

public class TrackSuggestStopsCommand
extends Command {
    private TrackStoplistTableModel stoplistTM = null;
    private String type = null;
    private String stopwatchStart;
    private String gpsStartTime;
    private String gpsSyncTime;
    private double timeWindow;
    private double threshold;
    private Collection<GpxTrackSegment> segments = null;
    private Vector<Vector<Object>> tableDataModel = null;
    private Vector<Node> nodes = null;
    private Vector<String> times = null;

    public TrackSuggestStopsCommand(StopImporterAction controller) {
        if (controller.getCurrentTrack() == null) {
            return;
        }
        this.stoplistTM = controller.getCurrentTrack().stoplistTM;
        this.type = controller.getDialog().getStoptype();
        this.stopwatchStart = controller.getCurrentTrack().stopwatchStart;
        this.gpsStartTime = controller.getCurrentTrack().gpsStartTime;
        this.gpsSyncTime = controller.getCurrentTrack().gpsSyncTime;
        this.timeWindow = controller.getCurrentTrack().timeWindow;
        this.threshold = controller.getCurrentTrack().threshold;
        this.segments = controller.getCurrentTrack().getGpxTrack().getSegments();
    }

    public boolean executeCommand() {
        if (this.stoplistTM == null) {
            return false;
        }
        this.tableDataModel = (Vector)this.stoplistTM.getDataVector().clone();
        this.nodes = (Vector)this.stoplistTM.getNodes().clone();
        this.times = (Vector)this.stoplistTM.getTimes().clone();
        int i = 0;
        while (i < this.stoplistTM.getNodes().size()) {
            Node node = this.stoplistTM.nodeAt(i);
            if (node != null) {
                Main.main.getCurrentDataSet().removePrimitive((PrimitiveId)node);
                node.setDeleted(true);
            }
            ++i;
        }
        this.stoplistTM.clear();
        Vector<WayPoint> wayPoints = new Vector<WayPoint>();
        Iterator<GpxTrackSegment> siter = this.segments.iterator();
        while (siter.hasNext()) {
            Iterator witer = siter.next().getWayPoints().iterator();
            while (witer.hasNext()) {
                wayPoints.add((WayPoint)witer.next());
            }
        }
        Vector<Double> wayPointsDist = new Vector<Double>(wayPoints.size());
        int i2 = 0;
        double time = -172800.0;
        double dGpsStartTime = StopImporterDialog.parseTime(this.gpsStartTime);
        while (i2 < wayPoints.size() && time < dGpsStartTime + this.timeWindow / 2.0) {
            if (((WayPoint)wayPoints.elementAt(i2)).getString("time") != null) {
                time = StopImporterDialog.parseTime(((WayPoint)wayPoints.elementAt(i2)).getString("time").substring(11, 19));
            }
            if (time < dGpsStartTime) {
                time += 86400.0;
            }
            wayPointsDist.add(Double.POSITIVE_INFINITY);
            ++i2;
        }
        while (i2 < wayPoints.size()) {
            int j = i2;
            double time2 = time;
            while (j > 0 && time - this.timeWindow / 2.0 < time2) {
                if (((WayPoint)wayPoints.elementAt(--j)).getString("time") != null) {
                    time2 = StopImporterDialog.parseTime(((WayPoint)wayPoints.elementAt(j)).getString("time").substring(11, 19));
                }
                if (!(time2 < dGpsStartTime)) continue;
                time2 += 86400.0;
            }
            int k = i2 + 1;
            time2 = time;
            while (k < wayPoints.size() && time + this.timeWindow / 2.0 > time2) {
                if (((WayPoint)wayPoints.elementAt(k)).getString("time") != null) {
                    time2 = StopImporterDialog.parseTime(((WayPoint)wayPoints.elementAt(k)).getString("time").substring(11, 19));
                }
                if (time2 < dGpsStartTime) {
                    time2 += 86400.0;
                }
                ++k;
            }
            if (j < k) {
                double dist = 0.0;
                LatLon latLonI = ((WayPoint)wayPoints.elementAt(i2)).getCoor();
                int l = j;
                while (l < k) {
                    double distL = latLonI.greatCircleDistance(((WayPoint)wayPoints.elementAt(l)).getCoor());
                    if (distL > dist) {
                        dist = distL;
                    }
                    ++l;
                }
                wayPointsDist.add(dist);
            } else {
                wayPointsDist.add(Double.POSITIVE_INFINITY);
            }
            if (((WayPoint)wayPoints.elementAt(i2)).getString("time") != null) {
                time = StopImporterDialog.parseTime(((WayPoint)wayPoints.elementAt(i2)).getString("time").substring(11, 19));
            }
            if (time < dGpsStartTime) {
                time += 86400.0;
            }
            ++i2;
        }
        LatLon lastStopCoor = null;
        i2 = 1;
        while (i2 < wayPoints.size() - 1) {
            if (!((Double)wayPointsDist.elementAt(i2) >= this.threshold) && ((Double)wayPointsDist.elementAt(i2)).compareTo((Double)wayPointsDist.elementAt(i2 - 1)) == -1 && ((Double)wayPointsDist.elementAt(i2)).compareTo((Double)wayPointsDist.elementAt(i2 + 1)) == -1) {
                LatLon latLon = ((WayPoint)wayPoints.elementAt(i2)).getCoor();
                if (lastStopCoor == null || !(lastStopCoor.greatCircleDistance(latLon) < this.threshold)) {
                    if (((WayPoint)wayPoints.elementAt(i2)).getString("time") != null) {
                        time = StopImporterDialog.parseTime(((WayPoint)wayPoints.elementAt(i2)).getString("time").substring(11, 19));
                        double gpsSyncTime = StopImporterDialog.parseTime(this.gpsSyncTime);
                        if (gpsSyncTime < dGpsStartTime - 43200.0) {
                            gpsSyncTime += 86400.0;
                        }
                        double timeDelta = gpsSyncTime - StopImporterDialog.parseTime(this.stopwatchStart);
                        Node node = StopImporterAction.createNode(latLon, this.type, "");
                        this.stoplistTM.insertRow(-1, node, StopImporterAction.timeOf(time -= timeDelta), "", new TransText(null));
                    }
                    lastStopCoor = latLon;
                }
            }
            ++i2;
        }
        return true;
    }

    public void undoCommand() {
        Node node;
        if (this.stoplistTM == null) {
            return;
        }
        int i = 0;
        while (i < this.stoplistTM.getNodes().size()) {
            node = this.stoplistTM.nodeAt(i);
            if (node != null) {
                Main.main.getCurrentDataSet().removePrimitive((PrimitiveId)node);
                node.setDeleted(true);
            }
            ++i;
        }
        this.stoplistTM.setDataVector(this.tableDataModel);
        this.stoplistTM.setNodes(this.nodes);
        this.stoplistTM.setTimes(this.times);
        i = 0;
        while (i < this.stoplistTM.getNodes().size()) {
            node = this.stoplistTM.nodeAt(i);
            if (node != null) {
                node.setDeleted(false);
                Main.main.getCurrentDataSet().addPrimitive((OsmPrimitive)node);
            }
            ++i;
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Public Transport: Suggest stops", (Object[])new Object[0]);
    }

    private class NodeSortEntry
    implements Comparable<NodeSortEntry> {
        public Node node = null;
        public String time = null;
        public String name = null;
        public double startTime = 0.0;

        public NodeSortEntry(Node node, String time, String name, double startTime) {
            this.node = node;
            this.time = time;
            this.name = name;
        }

        @Override
        public int compareTo(NodeSortEntry nse) {
            double nseTime;
            double time = StopImporterDialog.parseTime(this.time);
            if (time - this.startTime > 43200.0) {
                time -= 86400.0;
            }
            if ((nseTime = StopImporterDialog.parseTime(nse.time)) - this.startTime > 43200.0) {
                nseTime -= 86400.0;
            }
            if (time < nseTime) {
                return -1;
            }
            if (time > nseTime) {
                return 1;
            }
            return 0;
        }
    }
}

