/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import public_transport.StopImporterAction;
import public_transport.StopImporterDialog;
import public_transport.TrackStoplistNameCommand;
import public_transport.TrackStoplistTableModel;

public class TrackReference
implements Comparable<TrackReference>,
TableModelListener {
    public GpxTrack track;
    public TrackStoplistTableModel stoplistTM;
    public String stopwatchStart;
    public String gpsStartTime;
    public String gpsSyncTime;
    public double timeWindow;
    public double threshold;
    private StopImporterAction controller = null;
    public boolean inEvent = false;

    public TrackReference(GpxTrack track, StopImporterAction controller) {
        this.track = track;
        this.stoplistTM = new TrackStoplistTableModel(this);
        this.stopwatchStart = "00:00:00";
        this.gpsStartTime = null;
        this.gpsSyncTime = null;
        this.controller = controller;
        if (track != null) {
            Iterator siter = track.getSegments().iterator();
            while (siter.hasNext() && this.gpsSyncTime == null) {
                Iterator witer = ((GpxTrackSegment)siter.next()).getWayPoints().iterator();
                if (!witer.hasNext()) continue;
                this.gpsStartTime = ((WayPoint)witer.next()).getString("time");
                if (this.gpsStartTime == null) continue;
                this.gpsSyncTime = this.gpsStartTime.substring(11, 19);
            }
            if (this.gpsSyncTime == null) {
                JOptionPane.showMessageDialog(null, I18n.tr((String)"The GPX file doesn''t contain valid trackpoints. Please use a GPX file that has trackpoints.", (Object[])new Object[0]), I18n.tr((String)"GPX File Trouble", (Object[])new Object[0]), 0);
                this.gpsStartTime = "1970-01-01T00:00:00Z";
                this.gpsSyncTime = this.stopwatchStart;
            }
        } else {
            this.gpsSyncTime = this.stopwatchStart;
        }
        this.timeWindow = 20.0;
        this.threshold = 20.0;
    }

    public GpxTrack getGpxTrack() {
        return this.track;
    }

    @Override
    public int compareTo(TrackReference tr) {
        String name = (String)this.track.getAttributes().get("name");
        String tr_name = (String)tr.track.getAttributes().get("name");
        if (name != null) {
            if (tr_name == null) {
                return -1;
            }
            return name.compareTo(tr_name);
        }
        return 1;
    }

    public String toString() {
        String buf = (String)this.track.getAttributes().get("name");
        if (buf == null) {
            return I18n.tr((String)"unnamed", (Object[])new Object[0]);
        }
        return buf;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0 && e.getFirstRow() >= 0) {
            if (this.inEvent) {
                return;
            }
            double time = StopImporterDialog.parseTime((String)this.stoplistTM.getValueAt(e.getFirstRow(), 0));
            if (time < 0.0) {
                this.stoplistTM.setValueAt(this.stoplistTM.timeAt(e.getFirstRow()), e.getFirstRow(), 0);
                JOptionPane.showMessageDialog(null, I18n.tr((String)"Can''t parse a time from this string.", (Object[])new Object[0]), I18n.tr((String)"Invalid value", (Object[])new Object[0]), 0);
                return;
            }
            Main.main.undoRedo.add((Command)new TrackStoplistNameCommand(this, e.getFirstRow()));
            this.stoplistTM.setTimeAt(e.getFirstRow(), (String)this.stoplistTM.getValueAt(e.getFirstRow(), 0));
        }
    }

    public LatLon computeCoor(double time) {
        double dGpsStartTime;
        double gpsSyncTime = StopImporterDialog.parseTime(this.gpsSyncTime);
        if (gpsSyncTime < (dGpsStartTime = StopImporterDialog.parseTime(this.gpsStartTime)) - 43200.0) {
            gpsSyncTime += 86400.0;
        }
        double timeDelta = gpsSyncTime - StopImporterDialog.parseTime(this.stopwatchStart);
        time += timeDelta;
        WayPoint wayPoint2 = null;
        WayPoint lastWayPoint = null;
        double wayPointTime = 0.0;
        double lastWayPointTime = 0.0;
        Iterator siter = this.track.getSegments().iterator();
        while (siter.hasNext()) {
            for (WayPoint wayPoint2 : ((GpxTrackSegment)siter.next()).getWayPoints()) {
                String startTime = wayPoint2.getString("time");
                wayPointTime = StopImporterDialog.parseTime(startTime.substring(11, 19));
                if (startTime.substring(11, 19).compareTo(this.gpsStartTime.substring(11, 19)) == -1) {
                    wayPointTime += 86400.0;
                }
                if (wayPointTime >= time) break;
                lastWayPoint = wayPoint2;
                lastWayPointTime = wayPointTime;
            }
            if (wayPointTime >= time) break;
        }
        double lat = 0.0;
        lat = wayPointTime == lastWayPointTime || lastWayPoint == null ? wayPoint2.getCoor().lat() : wayPoint2.getCoor().lat() * (time - lastWayPointTime) / (wayPointTime - lastWayPointTime) + lastWayPoint.getCoor().lat() * (wayPointTime - time) / (wayPointTime - lastWayPointTime);
        double lon = 0.0;
        lon = wayPointTime == lastWayPointTime || lastWayPoint == null ? wayPoint2.getCoor().lon() : wayPoint2.getCoor().lon() * (time - lastWayPointTime) / (wayPointTime - lastWayPointTime) + lastWayPoint.getCoor().lon() * (wayPointTime - time) / (wayPointTime - lastWayPointTime);
        return new LatLon(lat, lon);
    }

    public void relocateNodes() {
        int i = 0;
        while (i < this.stoplistTM.getNodes().size()) {
            Node node = this.stoplistTM.nodeAt(i);
            if (node != null) {
                double time = StopImporterDialog.parseTime((String)this.stoplistTM.getValueAt(i, 0));
                LatLon latLon = this.computeCoor(time);
                Node newNode = new Node(node);
                newNode.setCoor(latLon);
                ChangeCommand cmd = new ChangeCommand((OsmPrimitive)node, (OsmPrimitive)newNode);
                if (cmd != null) {
                    Main.main.undoRedo.add((Command)cmd);
                }
            }
            ++i;
        }
    }
}

