/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;
import public_transport.SettingsStoptypeCommand;
import public_transport.StopImporterDialog;
import public_transport.TrackReference;
import public_transport.TrackStoplistAddCommand;
import public_transport.TrackStoplistDeleteCommand;
import public_transport.TrackStoplistDetachCommand;
import public_transport.TrackStoplistRelocateCommand;
import public_transport.TrackStoplistSortCommand;
import public_transport.TrackSuggestStopsCommand;
import public_transport.WaypointTableModel;
import public_transport.WaypointsDetachCommand;
import public_transport.WaypointsDisableCommand;
import public_transport.WaypointsEnableCommand;

public class StopImporterAction
extends JosmAction {
    private static StopImporterDialog dialog = null;
    private static DefaultListModel tracksListModel = null;
    private static GpxData data = null;
    private static TrackReference currentTrack = null;
    private static WaypointTableModel waypointTM = null;
    public boolean inEvent = false;

    public StopImporterAction() {
        super(I18n.tr((String)"Create Stops from GPX ...", (Object[])new Object[0]), null, I18n.tr((String)"Create Stops from a GPX file", (Object[])new Object[0]), null, false);
        this.putValue("toolbar", "publictransport/stopimporter");
        Main.toolbar.register((Action)((Object)this));
    }

    public WaypointTableModel getWaypointTableModel() {
        return waypointTM;
    }

    public StopImporterDialog getDialog() {
        return dialog;
    }

    public DefaultListModel getTracksListModel() {
        if (tracksListModel == null) {
            tracksListModel = new DefaultListModel();
        }
        return tracksListModel;
    }

    public TrackReference getCurrentTrack() {
        return currentTrack;
    }

    public void actionPerformed(ActionEvent event) {
        if (dialog == null) {
            dialog = new StopImporterDialog(this);
        }
        dialog.setVisible(true);
        if (I18n.tr((String)"Create Stops from GPX ...", (Object[])new Object[0]).equals(event.getActionCommand())) {
            String curDir = Main.pref.get("lastDirectory");
            if (curDir.equals("")) {
                curDir = ".";
            }
            JFileChooser fc = new JFileChooser(new File(curDir));
            fc.setDialogTitle(I18n.tr((String)"Select GPX file", (Object[])new Object[0]));
            fc.setMultiSelectionEnabled(false);
            int answer = fc.showOpenDialog(Main.parent);
            if (answer != 0) {
                return;
            }
            if (!fc.getCurrentDirectory().getAbsolutePath().equals(curDir)) {
                Main.pref.put("lastDirectory", fc.getCurrentDirectory().getAbsolutePath());
            }
            this.importData(fc.getSelectedFile());
            this.refreshData();
        } else if ("stopImporter.settingsGPSTimeStart".equals(event.getActionCommand())) {
            if (!this.inEvent && dialog.gpsTimeStartValid() && currentTrack != null) {
                Main.main.undoRedo.add((Command)new TrackStoplistRelocateCommand(this));
            }
        } else if ("stopImporter.settingsStopwatchStart".equals(event.getActionCommand())) {
            if (!this.inEvent && dialog.stopwatchStartValid() && currentTrack != null) {
                Main.main.undoRedo.add((Command)new TrackStoplistRelocateCommand(this));
            }
        } else if ("stopImporter.settingsTimeWindow".equals(event.getActionCommand())) {
            if (currentTrack != null) {
                StopImporterAction.currentTrack.timeWindow = dialog.getTimeWindow();
            }
        } else if ("stopImporter.settingsThreshold".equals(event.getActionCommand())) {
            if (currentTrack != null) {
                StopImporterAction.currentTrack.threshold = dialog.getThreshold();
            }
        } else if ("stopImporter.settingsSuggestStops".equals(event.getActionCommand())) {
            Main.main.undoRedo.add((Command)new TrackSuggestStopsCommand(this));
        } else if ("stopImporter.stoplistFind".equals(event.getActionCommand())) {
            StopImporterAction.findNodesInTable(dialog.getStoplistTable(), StopImporterAction.currentTrack.stoplistTM.getNodes());
        } else if ("stopImporter.stoplistShow".equals(event.getActionCommand())) {
            StopImporterAction.showNodesFromTable(dialog.getStoplistTable(), StopImporterAction.currentTrack.stoplistTM.getNodes());
        } else if ("stopImporter.stoplistMark".equals(event.getActionCommand())) {
            StopImporterAction.markNodesFromTable(dialog.getStoplistTable(), StopImporterAction.currentTrack.stoplistTM.getNodes());
        } else if ("stopImporter.stoplistDetach".equals(event.getActionCommand())) {
            Main.main.undoRedo.add((Command)new TrackStoplistDetachCommand(this));
            dialog.getStoplistTable().clearSelection();
        } else if ("stopImporter.stoplistAdd".equals(event.getActionCommand())) {
            Main.main.undoRedo.add((Command)new TrackStoplistAddCommand(this));
        } else if ("stopImporter.stoplistDelete".equals(event.getActionCommand())) {
            Main.main.undoRedo.add((Command)new TrackStoplistDeleteCommand(this));
        } else if ("stopImporter.stoplistSort".equals(event.getActionCommand())) {
            Main.main.undoRedo.add((Command)new TrackStoplistSortCommand(this));
        } else if ("stopImporter.waypointsFind".equals(event.getActionCommand())) {
            StopImporterAction.findNodesInTable(dialog.getWaypointsTable(), StopImporterAction.waypointTM.nodes);
        } else if ("stopImporter.waypointsShow".equals(event.getActionCommand())) {
            StopImporterAction.showNodesFromTable(dialog.getWaypointsTable(), StopImporterAction.waypointTM.nodes);
        } else if ("stopImporter.waypointsMark".equals(event.getActionCommand())) {
            StopImporterAction.markNodesFromTable(dialog.getWaypointsTable(), StopImporterAction.waypointTM.nodes);
        } else if ("stopImporter.waypointsDetach".equals(event.getActionCommand())) {
            Main.main.undoRedo.add((Command)new WaypointsDetachCommand(this));
            dialog.getWaypointsTable().clearSelection();
        } else if ("stopImporter.waypointsAdd".equals(event.getActionCommand())) {
            Main.main.undoRedo.add((Command)new WaypointsEnableCommand(this));
        } else if ("stopImporter.waypointsDelete".equals(event.getActionCommand())) {
            Main.main.undoRedo.add((Command)new WaypointsDisableCommand(this));
        } else if ("stopImporter.settingsStoptype".equals(event.getActionCommand())) {
            Main.main.undoRedo.add((Command)new SettingsStoptypeCommand(this));
        }
    }

    private void importData(File file) {
        try {
            InputStream is = file.getName().endsWith(".gpx.gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
            if (is.read() != 239 || is.read() != 187 || is.read() != 191) {
                is.close();
                is = file.getName().endsWith(".gpx.gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
            }
            GpxReader r = new GpxReader(is);
            boolean parsedProperly = r.parse(true);
            data = r.getGpxData();
            if (!parsedProperly) {
                JOptionPane.showMessageDialog(null, I18n.tr((String)"Error occurred while parsing gpx file {0}. Only a part of the file will be available.", (Object[])new Object[]{file.getName()}));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, I18n.tr((String)"File \"{0}\" does not exist", (Object[])new Object[]{file.getName()}));
        }
        catch (SAXException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, I18n.tr((String)"Parsing file \"{0}\" failed", (Object[])new Object[]{file.getName()}));
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, I18n.tr((String)"IOException \"{0}\" occurred", (Object[])new Object[]{e.toString()}));
        }
    }

    private void refreshData() {
        tracksListModel.clear();
        if (data != null) {
            Vector<TrackReference> trackRefs = new Vector<TrackReference>();
            for (GpxTrack track : StopImporterAction.data.tracks) {
                trackRefs.add(new TrackReference(track, this));
            }
            Collections.sort(trackRefs);
            Iterator iter = trackRefs.iterator();
            while (iter.hasNext()) {
                tracksListModel.addElement(iter.next());
            }
            waypointTM = new WaypointTableModel(this);
            for (WayPoint waypoint : StopImporterAction.data.waypoints) {
                waypointTM.addRow(waypoint);
            }
            dialog.setWaypointsTableModel(waypointTM);
        } else {
            JOptionPane.showMessageDialog(null, I18n.tr((String)"The GPX file contained no tracks or waypoints.", (Object[])new Object[0]), I18n.tr((String)"No data found", (Object[])new Object[0]), 0);
        }
    }

    public void tracksSelectionChanged(int selectedPos) {
        if (selectedPos >= 0) {
            currentTrack = (TrackReference)tracksListModel.elementAt(selectedPos);
            dialog.setTrackValid(true);
            dialog.setSettings(StopImporterAction.currentTrack.gpsSyncTime, StopImporterAction.currentTrack.stopwatchStart, StopImporterAction.currentTrack.timeWindow, StopImporterAction.currentTrack.threshold);
            dialog.setStoplistTableModel(((TrackReference)StopImporterAction.tracksListModel.elementAt((int)selectedPos)).stoplistTM);
        } else {
            currentTrack = null;
            dialog.setTrackValid(false);
        }
    }

    public Node createNode(LatLon latLon, String name) {
        return StopImporterAction.createNode(latLon, dialog.getStoptype(), name);
    }

    public static Node createNode(LatLon latLon, String type, String name) {
        Node node = new Node(latLon);
        StopImporterAction.setTagsWrtType(node, type);
        node.put("name", name);
        if (Main.main.getCurrentDataSet() == null) {
            JOptionPane.showMessageDialog(null, I18n.tr((String)"There exists no dataset. Try to download data from the server or open an OSM file.", (Object[])new Object[0]), I18n.tr((String)"No data found", (Object[])new Object[0]), 0);
            return null;
        }
        Main.main.getCurrentDataSet().addPrimitive((OsmPrimitive)node);
        return node;
    }

    public static void setTagsWrtType(Node node, String type) {
        node.remove("highway");
        node.remove("railway");
        if ("bus".equals(type)) {
            node.put("highway", "bus_stop");
        } else if ("tram".equals(type)) {
            node.put("railway", "tram_stop");
        } else if ("light_rail".equals(type)) {
            node.put("railway", "station");
        } else if ("subway".equals(type)) {
            node.put("railway", "station");
        } else if ("rail".equals(type)) {
            node.put("railway", "station");
        }
    }

    public static Vector<Integer> getConsideredLines(JTable table) {
        int[] selectedLines = table.getSelectedRows();
        Vector<Integer> consideredLines = new Vector<Integer>();
        if (selectedLines.length > 0) {
            int i = 0;
            while (i < selectedLines.length) {
                consideredLines.add(selectedLines[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < table.getRowCount()) {
                consideredLines.add(new Integer(i));
                ++i;
            }
        }
        return consideredLines;
    }

    public static void findNodesInTable(JTable table, Vector<Node> nodes) {
        if (Main.main.getCurrentDataSet() == null) {
            return;
        }
        table.clearSelection();
        int i = 0;
        while (i < table.getRowCount()) {
            if (nodes.elementAt(i) != null && Main.main.getCurrentDataSet().isSelected((OsmPrimitive)nodes.elementAt(i))) {
                table.addRowSelectionInterval(i, i);
            }
            ++i;
        }
    }

    public static void showNodesFromTable(JTable table, Vector<Node> nodes) {
        BoundingXYVisitor box = new BoundingXYVisitor();
        Vector<Integer> consideredLines = StopImporterAction.getConsideredLines(table);
        int i = 0;
        while (i < consideredLines.size()) {
            int j = consideredLines.elementAt(i);
            if (nodes.elementAt(j) != null) {
                nodes.elementAt(j).accept((Visitor)box);
            }
            ++i;
        }
        if (box.getBounds() == null) {
            return;
        }
        box.enlargeBoundingBox();
        Main.map.mapView.recalculateCenterScale(box);
    }

    public static void markNodesFromTable(JTable table, Vector<Node> nodes) {
        OsmPrimitive[] osmp = new OsmPrimitive[1];
        Main.main.getCurrentDataSet().setSelected((PrimitiveId[])osmp);
        Vector<Integer> consideredLines = StopImporterAction.getConsideredLines(table);
        int i = 0;
        while (i < consideredLines.size()) {
            int j = consideredLines.elementAt(i);
            if (nodes.elementAt(j) != null) {
                Main.main.getCurrentDataSet().addSelected(new PrimitiveId[]{(PrimitiveId)nodes.elementAt(j)});
            }
            ++i;
        }
    }

    public static String timeOf(double t) {
        t -= Math.floor(t / 24.0 / 60.0 / 60.0) * 24.0 * 60.0 * 60.0;
        int hour = (int)Math.floor(t / 60.0 / 60.0);
        t -= Math.floor(t / 60.0 / 60.0) * 60.0 * 60.0;
        int minute = (int)Math.floor(t / 60.0);
        t -= Math.floor(t / 60.0) * 60.0;
        double second = t;
        DecimalFormat format = new DecimalFormat("00");
        DecimalFormat formatS = new DecimalFormat("00.###");
        return String.valueOf(format.format((Object)hour)) + ":" + format.format((Object)minute) + ":" + formatS.format((Object)second);
    }

    public Action getFocusWaypointNameAction() {
        return new FocusWaypointNameAction();
    }

    public Action getFocusWaypointShelterAction(String shelter) {
        return new FocusWaypointShelterAction(shelter);
    }

    public Action getFocusWaypointDeleteAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table = dialog.getWaypointsTable();
                int row = table.getEditingRow();
                if (row < 0) {
                    return;
                }
                table.clearSelection();
                table.addRowSelectionInterval(row, row);
                Main.main.undoRedo.add((Command)new WaypointsDisableCommand(StopImporterAction.this));
            }
        };
    }

    public Action getFocusTrackStoplistNameAction() {
        return new FocusTrackStoplistNameAction();
    }

    public Action getFocusTrackStoplistShelterAction(String shelter) {
        return new FocusTrackStoplistShelterAction(shelter);
    }

    public Action getFocusStoplistDeleteAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table = dialog.getStoplistTable();
                int row = table.getEditingRow();
                if (row < 0) {
                    return;
                }
                table.clearSelection();
                table.addRowSelectionInterval(row, row);
                Main.main.undoRedo.add((Command)new TrackStoplistDeleteCommand(StopImporterAction.this));
            }
        };
    }

    private class FocusTrackStoplistNameAction
    extends AbstractAction {
        private FocusTrackStoplistNameAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = dialog.getStoplistTable();
            StopImporterAction.showNodesFromTable(table, currentTrack.stoplistTM.getNodes());
            StopImporterAction.markNodesFromTable(table, currentTrack.stoplistTM.getNodes());
            int row = table.getEditingRow();
            if (row < 0) {
                row = 0;
            }
            currentTrack.inEvent = true;
            if (table.getCellEditor() != null && !table.getCellEditor().stopCellEditing()) {
                table.getCellEditor().cancelCellEditing();
            }
            table.editCellAt(row, 1);
            table.getCellEditor().getTableCellEditorComponent(table, "", true, row, 1);
            currentTrack.inEvent = false;
        }
    }

    private class FocusTrackStoplistShelterAction
    extends AbstractAction {
        private String defaultShelter = null;

        public FocusTrackStoplistShelterAction(String defaultShelter) {
            this.defaultShelter = defaultShelter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = dialog.getStoplistTable();
            StopImporterAction.showNodesFromTable(table, currentTrack.stoplistTM.getNodes());
            StopImporterAction.markNodesFromTable(table, currentTrack.stoplistTM.getNodes());
            int row = table.getEditingRow();
            if (row < 0) {
                row = 0;
            }
            currentTrack.inEvent = true;
            if (table.getCellEditor() != null && !table.getCellEditor().stopCellEditing()) {
                table.getCellEditor().cancelCellEditing();
            }
            table.editCellAt(row, 2);
            currentTrack.inEvent = false;
            table.getCellEditor().getTableCellEditorComponent(table, this.defaultShelter, true, row, 2);
        }
    }

    private class FocusWaypointNameAction
    extends AbstractAction {
        private FocusWaypointNameAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = dialog.getWaypointsTable();
            StopImporterAction.showNodesFromTable(table, waypointTM.nodes);
            StopImporterAction.markNodesFromTable(table, waypointTM.nodes);
            int row = table.getEditingRow();
            if (row < 0) {
                row = 0;
            }
            waypointTM.inEvent = true;
            if (table.getCellEditor() != null && !table.getCellEditor().stopCellEditing()) {
                table.getCellEditor().cancelCellEditing();
            }
            table.editCellAt(row, 1);
            table.getCellEditor().getTableCellEditorComponent(table, "", true, row, 1);
            waypointTM.inEvent = false;
        }
    }

    private class FocusWaypointShelterAction
    extends AbstractAction {
        private String defaultShelter = null;

        public FocusWaypointShelterAction(String defaultShelter) {
            this.defaultShelter = defaultShelter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = dialog.getWaypointsTable();
            StopImporterAction.showNodesFromTable(table, waypointTM.nodes);
            StopImporterAction.markNodesFromTable(table, waypointTM.nodes);
            int row = table.getEditingRow();
            if (row < 0) {
                row = 0;
            }
            waypointTM.inEvent = true;
            if (table.getCellEditor() != null && !table.getCellEditor().stopCellEditing()) {
                table.getCellEditor().cancelCellEditing();
            }
            table.editCellAt(row, 2);
            waypointTM.inEvent = false;
            table.getCellEditor().getTableCellEditorComponent(table, this.defaultShelter, true, row, 2);
        }
    }
}

