/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import java.util.Vector;
import javax.swing.DefaultListModel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import public_transport.StopImporterAction;
import public_transport.TrackReference;
import public_transport.WaypointTableModel;

public class SettingsStoptypeCommand
extends Command {
    private Vector<HighwayRailway> oldStrings = null;
    private WaypointTableModel waypointTM = null;
    private DefaultListModel tracksListModel = null;
    private String type = null;

    public SettingsStoptypeCommand(StopImporterAction controller) {
        this.waypointTM = controller.getWaypointTableModel();
        this.tracksListModel = controller.getTracksListModel();
        this.type = controller.getDialog().getStoptype();
        this.oldStrings = new Vector();
    }

    public boolean executeCommand() {
        this.oldStrings.clear();
        int i = 0;
        while (i < this.waypointTM.getRowCount()) {
            if (this.waypointTM.nodes.elementAt(i) != null) {
                Node node = this.waypointTM.nodes.elementAt(i);
                this.oldStrings.add(new HighwayRailway(node));
                StopImporterAction.setTagsWrtType(node, this.type);
            }
            ++i;
        }
        int j = 0;
        while (j < this.tracksListModel.size()) {
            TrackReference track = (TrackReference)this.tracksListModel.elementAt(j);
            int i2 = 0;
            while (i2 < track.stoplistTM.getRowCount()) {
                if (track.stoplistTM.nodeAt(i2) != null) {
                    Node node = track.stoplistTM.nodeAt(i2);
                    this.oldStrings.add(new HighwayRailway(node));
                    StopImporterAction.setTagsWrtType(node, this.type);
                }
                ++i2;
            }
            ++j;
        }
        return true;
    }

    public void undoCommand() {
        int i = 0;
        while (i < this.oldStrings.size()) {
            HighwayRailway hr = this.oldStrings.elementAt(i);
            hr.node.put("highway", hr.highway);
            hr.node.put("railway", hr.railway);
            ++i;
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Public Transport: Change stop type", (Object[])new Object[0]);
    }

    private class HighwayRailway {
        public Node node;
        public String highway;
        public String railway;

        public HighwayRailway(Node node) {
            this.node = node;
            this.highway = node.get("highway");
            this.railway = node.get("railway");
        }
    }
}

