/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.tools.I18n;
import public_transport.GTFSImporterAction;

public class GTFSStopTableModel
extends DefaultTableModel
implements TableModelListener {
    private GTFSImporterAction controller = null;
    public Vector<Node> nodes = new Vector();
    public Vector<LatLon> coors = new Vector();
    private int idCol = -1;
    private int nameCol = -1;
    private int latCol = -1;
    private int lonCol = -1;
    private char separator = (char)44;

    public GTFSStopTableModel(GTFSImporterAction controller, String columnConfig) {
        String title;
        int pos = columnConfig.indexOf(this.separator);
        if (pos == -1) {
            this.separator = (char)59;
            pos = columnConfig.indexOf(this.separator);
        }
        if (pos == -1) {
            this.separator = (char)9;
            pos = columnConfig.indexOf(this.separator);
        }
        int oldPos = 0;
        int i = 0;
        while (pos > -1) {
            title = this.stripQuot(columnConfig.substring(oldPos, pos));
            if ("stop_id".equals(title)) {
                this.idCol = i;
            } else if ("stop_name".equals(title)) {
                this.nameCol = i;
            } else if ("stop_lat".equals(title)) {
                this.latCol = i;
            } else if ("stop_lon".equals(title)) {
                this.lonCol = i;
            }
            ++i;
            oldPos = pos + 1;
            pos = columnConfig.indexOf(this.separator, oldPos);
        }
        title = columnConfig.substring(oldPos);
        if ("stop_id".equals(title)) {
            this.idCol = i;
        } else if ("stop_name".equals(title)) {
            this.nameCol = i;
        } else if ("stop_lat".equals(title)) {
            this.latCol = i;
        } else if ("stop_lon".equals(title)) {
            this.lonCol = i;
        }
        this.controller = controller;
        this.addColumn(I18n.tr((String)"Id", (Object[])new Object[0]));
        this.addColumn(I18n.tr((String)"Name", (Object[])new Object[0]));
        this.addColumn(I18n.tr((String)"State", (Object[])new Object[0]));
        this.addTableModelListener(this);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void addRow(Object[] obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertRow(int insPos, Object[] obj) {
        throw new UnsupportedOperationException();
    }

    public void addRow(String s) {
        this.insertRow(-1, s, new Vector<Node>());
    }

    public void addRow(String s, Vector<Node> existingStops) {
        this.insertRow(-1, s, existingStops);
    }

    private int tokenize(String s, int startPos) {
        int pos = startPos;
        boolean insideDoubleQuoted = false;
        while (pos < s.length()) {
            if ('\"' == s.charAt(pos)) {
                insideDoubleQuoted = !insideDoubleQuoted;
            } else if (this.separator == s.charAt(pos) && !insideDoubleQuoted) break;
            ++pos;
        }
        if (pos < s.length()) {
            return pos;
        }
        return -1;
    }

    private String stripQuot(String s) {
        int pos = s.indexOf(34);
        while (pos > -1) {
            s = String.valueOf(s.substring(0, pos)) + s.substring(pos + 1);
            pos = s.indexOf(34);
        }
        return s;
    }

    public void insertRow(int insPos, String s, Vector<Node> existingStops) {
        Node node2;
        Object[] buf = new String[]{"", "", I18n.tr((String)"pending", (Object[])new Object[0])};
        int pos = this.tokenize(s, 0);
        int oldPos = 0;
        int i = 0;
        double lat = 0.0;
        double lon = 0.0;
        while (pos > -1) {
            if (i == this.idCol) {
                buf[0] = this.stripQuot(s.substring(oldPos, pos));
            } else if (i == this.nameCol) {
                buf[1] = this.stripQuot(s.substring(oldPos, pos));
            } else if (i == this.latCol) {
                lat = Double.parseDouble(this.stripQuot(s.substring(oldPos, pos)));
            } else if (i == this.lonCol) {
                lon = Double.parseDouble(this.stripQuot(s.substring(oldPos, pos)));
            }
            ++i;
            oldPos = pos + 1;
            pos = this.tokenize(s, oldPos);
        }
        if (i == this.idCol) {
            buf[0] = this.stripQuot(s.substring(oldPos));
        } else if (i == this.nameCol) {
            buf[1] = this.stripQuot(s.substring(oldPos));
        } else if (i == this.latCol) {
            lat = Double.parseDouble(this.stripQuot(s.substring(oldPos)));
        } else if (i == this.lonCol) {
            lon = Double.parseDouble(this.stripQuot(s.substring(oldPos)));
        }
        LatLon coor = new LatLon(lat, lon);
        if (Main.main.getCurrentDataSet() != null) {
            boolean inside = false;
            Iterator<Object> iter = Main.main.getCurrentDataSet().dataSources.iterator();
            while (iter.hasNext()) {
                if (!((DataSource)iter.next()).bounds.contains(coor)) continue;
                inside = true;
                break;
            }
            if (!inside) {
                buf[2] = I18n.tr((String)"outside", (Object[])new Object[0]);
            }
        }
        boolean nearBusStop = false;
        for (Node node2 : existingStops) {
            if (!(coor.greatCircleDistance(node2.getCoor()) < 1000.0)) continue;
            nearBusStop = true;
            break;
        }
        if (insPos == -1) {
            if (nearBusStop || !I18n.tr((String)"pending", (Object[])new Object[0]).equals(buf[2])) {
                this.nodes.addElement(null);
            } else {
                node2 = GTFSImporterAction.createNode(coor, (String)buf[0], (String)buf[1]);
                this.nodes.addElement(node2);
                buf[2] = I18n.tr((String)"added", (Object[])new Object[0]);
            }
            this.coors.addElement(coor);
            super.addRow(buf);
        } else {
            if (nearBusStop || !I18n.tr((String)"pending", (Object[])new Object[0]).equals(buf[2])) {
                this.nodes.insertElementAt(null, insPos);
            } else {
                node2 = GTFSImporterAction.createNode(coor, (String)buf[0], (String)buf[1]);
                this.nodes.insertElementAt(node2, insPos);
                buf[2] = I18n.tr((String)"added", (Object[])new Object[0]);
            }
            this.coors.insertElementAt(coor, insPos);
            super.insertRow(insPos, buf);
        }
    }

    public void clear() {
        this.nodes.clear();
        super.setRowCount(0);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }
}

