/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photoadjust;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

class ToggleGeoImageThumbAction
extends AbstractAction
implements Layer.LayerAction {
    public ToggleGeoImageThumbAction() {
        super(I18n.tr((String)"Toggle the image thumbnail preview", (Object[])new Object[0]), ImageProvider.get((String)"togglegit"));
    }

    private GeoImageLayer getSelectedLayer() {
        return (GeoImageLayer)LayerListDialog.getInstance().getModel().getSelectedLayers().get(0);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        GeoImageLayer layer;
        layer.setUseThumbs(!(layer = this.getSelectedLayer()).isUseThumbs());
        Main.map.mapView.repaint();
    }

    private boolean enabled(GeoImageLayer layer) {
        return layer.getImages().size() > 0;
    }

    public Component createMenuComponent() {
        JMenuItem toggleItem = new JMenuItem(this);
        toggleItem.setEnabled(this.enabled(this.getSelectedLayer()));
        return toggleItem;
    }

    public boolean supportLayers(List<Layer> layers) {
        return layers.size() == 1 && layers.get(0) instanceof GeoImageLayer;
    }
}

