/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.geotools.data.shapefile.FileWriter;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StorageFile;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.indexed.IndexedFidReader;
import org.geotools.resources.NIOUtilities;

public class IndexedFidWriter
implements FileWriter {
    public static final int HEADER_SIZE = 13;
    public static final int RECORD_SIZE = 12;
    private FileChannel channel;
    private ByteBuffer writeBuffer;
    private IndexedFidReader reader;
    long fidIndex;
    private int recordIndex;
    private boolean closed;
    private long current;
    private long position;
    private int removes;
    StreamLogging streamLogger = new StreamLogging("IndexedFidReader");
    private StorageFile storageFile;
    public static final IndexedFidWriter EMPTY_WRITER = new IndexedFidWriter(){

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean hasNext() throws IOException {
            return false;
        }

        @Override
        public boolean isClosed() {
            return false;
        }

        @Override
        public void write() throws IOException {
        }

        @Override
        public long next() throws IOException {
            return 0L;
        }

        @Override
        public void remove() throws IOException {
        }
    };

    public IndexedFidWriter(ShpFiles shpFiles) throws IOException {
        this.storageFile = shpFiles.getStorageFile(ShpFileType.FIX);
        this.init(shpFiles, this.storageFile);
    }

    public IndexedFidWriter(ShpFiles shpFiles, StorageFile storageFile) throws IOException {
        this.init(shpFiles, storageFile);
    }

    private void init(ShpFiles shpFiles, StorageFile storageFile) throws IOException {
        if (!shpFiles.isLocal()) {
            throw new IllegalArgumentException("Currently only local files are supported for writing");
        }
        try {
            this.reader = new IndexedFidReader(shpFiles);
        }
        catch (FileNotFoundException e) {
            this.reader = new IndexedFidReader(shpFiles, storageFile.getWriteChannel());
        }
        this.channel = storageFile.getWriteChannel();
        this.streamLogger.open();
        this.allocateBuffers();
        this.removes = this.reader.getRemoves();
        this.writeBuffer.position(13);
        this.closed = false;
        this.position = 0L;
        this.current = -1L;
        this.recordIndex = 0;
        this.fidIndex = 0L;
    }

    private IndexedFidWriter() {
    }

    private void allocateBuffers() {
        this.writeBuffer = NIOUtilities.allocate(12301);
    }

    private void drain() throws IOException {
        this.writeBuffer.flip();
        int written = 0;
        while (this.writeBuffer.remaining() > 0) {
            written += this.channel.write(this.writeBuffer, this.position);
        }
        this.position += (long)written;
        this.writeBuffer.flip().limit(this.writeBuffer.capacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeader() throws IOException {
        ByteBuffer buffer = NIOUtilities.allocate(13);
        try {
            buffer.put((byte)1);
            buffer.putLong(this.recordIndex);
            buffer.putInt(this.removes);
            buffer.flip();
            this.channel.write(buffer, 0L);
        }
        finally {
            NIOUtilities.clean(buffer, false);
        }
    }

    public boolean hasNext() throws IOException {
        return this.reader.hasNext();
    }

    public long next() throws IOException {
        if (this.current != -1L) {
            this.write();
        }
        if (this.reader.hasNext()) {
            this.reader.next();
            this.fidIndex = this.reader.getCurrentFIDIndex();
        } else {
            ++this.fidIndex;
        }
        this.current = this.fidIndex;
        return this.fidIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.finishLastWrite();
        }
        finally {
            try {
                this.reader.close();
            }
            finally {
                this.closeWriterChannels();
            }
            if (this.storageFile != null) {
                this.storageFile.replaceOriginal();
            }
        }
        this.closed = true;
    }

    private void closeWriterChannels() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.close();
        }
        this.streamLogger.close();
        if (this.writeBuffer != null) {
            NIOUtilities.clean(this.writeBuffer, false);
            this.writeBuffer = null;
        }
    }

    private void finishLastWrite() throws IOException {
        while (this.hasNext()) {
            this.next();
        }
        if (this.current != -1L) {
            this.write();
        }
        this.drain();
        this.writeHeader();
    }

    public void remove() throws IOException {
        if (this.current == -1L) {
            throw new IOException("Current fid index is null, next must be called before remove");
        }
        if (this.hasNext()) {
            ++this.removes;
            this.current = -1L;
        }
    }

    public void write() throws IOException {
        if (this.current == -1L) {
            throw new IOException("Current fid index is null, next must be called before write()");
        }
        if (this.writeBuffer == null) {
            this.allocateBuffers();
        }
        if (this.writeBuffer.remaining() < 12) {
            this.drain();
        }
        this.writeBuffer.putLong(this.current);
        this.writeBuffer.putInt(this.recordIndex);
        ++this.recordIndex;
        this.current = -1L;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public String id() {
        return this.getClass().getName();
    }
}

