/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.styling.Displacement;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.style.GraphicalSymbol;

public class UomRescaleStyleVisitor
extends DuplicatingStyleVisitor {
    private double mapScale = 1.0;

    public UomRescaleStyleVisitor(double mapScale) {
        if (mapScale <= 0.0) {
            throw new IllegalArgumentException("The mapScale is out of range. Value is " + Double.toString(mapScale) + ". It must be positive.");
        }
        this.mapScale = mapScale;
    }

    protected double computeRescaleMultiplier(double mapScale, Unit<Length> uom) {
        if (uom == null || uom.equals(NonSI.PIXEL)) {
            return 1.0;
        }
        UnitConverter converter = uom.getConverterTo(SI.METER);
        return converter.convert(mapScale);
    }

    protected Expression rescale(Expression unscaled, double mapScale, Unit<Length> uom) {
        if (unscaled == null || unscaled.equals(Expression.NIL)) {
            return unscaled;
        }
        if (unscaled instanceof Literal && unscaled.evaluate(null, Double.class) != null) {
            double rescaled = this.rescale(unscaled.evaluate(null, Double.class), mapScale, uom);
            return this.ff.literal(rescaled);
        }
        double rescaleMultiplier = this.computeRescaleMultiplier(mapScale, uom);
        return this.ff.multiply(unscaled, this.ff.literal(rescaleMultiplier));
    }

    protected double rescale(double unscaled, double mapScale, Unit<Length> uom) {
        return unscaled * this.computeRescaleMultiplier(mapScale, uom);
    }

    protected float[] rescale(float[] dashArray, double mapScale, Unit<Length> unitOfMeasure) {
        if (dashArray == null) {
            return null;
        }
        if (unitOfMeasure == null || unitOfMeasure.equals(NonSI.PIXEL)) {
            return dashArray;
        }
        float[] rescaledDashArray = new float[dashArray.length];
        for (int i = 0; i < rescaledDashArray.length; ++i) {
            rescaledDashArray[i] = (float)this.rescale(dashArray[i], mapScale, unitOfMeasure);
        }
        return rescaledDashArray;
    }

    protected void rescaleStroke(Stroke stroke, double mapScale, Unit<Length> uom) {
        if (stroke != null) {
            stroke.setWidth(this.rescale(stroke.getWidth(), mapScale, uom));
            stroke.setDashArray(this.rescale(stroke.getDashArray(), mapScale, uom));
            stroke.setDashOffset(this.rescale(stroke.getDashOffset(), mapScale, uom));
            this.rescale(stroke.getGraphicFill(), mapScale, uom);
            this.rescale(stroke.getGraphicStroke(), mapScale, uom);
        }
    }

    @Override
    public void visit(PointSymbolizer ps) {
        super.visit(ps);
        PointSymbolizer copy = (PointSymbolizer)this.pages.peek();
        Unit<Length> uom = copy.getUnitOfMeasure();
        if (uom == null || uom.equals(NonSI.PIXEL)) {
            return;
        }
        Graphic copyGraphic = copy.getGraphic();
        this.rescale(copyGraphic, this.mapScale, uom);
        copy.setUnitOfMeasure(NonSI.PIXEL);
    }

    private void rescale(Graphic graphic, double mapScale, Unit<Length> unit) {
        if (graphic != null) {
            graphic.setSize(this.rescale(graphic.getSize(), mapScale, unit));
            graphic.setGap(this.rescale(graphic.getGap(), mapScale, unit));
            Displacement disp = graphic.getDisplacement();
            if (disp != null) {
                disp.setDisplacementX(this.rescale(disp.getDisplacementX(), mapScale, unit));
                disp.setDisplacementY(this.rescale(disp.getDisplacementY(), mapScale, unit));
                graphic.setDisplacement(disp);
            }
            if (graphic.graphicalSymbols() != null) {
                for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
                    if (!(gs instanceof Mark)) continue;
                    Mark mark = (Mark)gs;
                    this.rescaleStroke(mark.getStroke(), mapScale, unit);
                    this.rescaleFill(mark.getFill(), mapScale, unit);
                }
            }
        }
    }

    @Override
    public void visit(LineSymbolizer line) {
        super.visit(line);
        LineSymbolizer copy = (LineSymbolizer)this.pages.peek();
        Unit<Length> uom = copy.getUnitOfMeasure();
        if (uom == null || uom.equals(NonSI.PIXEL)) {
            return;
        }
        Stroke copyStroke = copy.getStroke();
        this.rescaleStroke(copyStroke, this.mapScale, uom);
        copy.setUnitOfMeasure(NonSI.PIXEL);
    }

    @Override
    public void visit(PolygonSymbolizer poly) {
        super.visit(poly);
        PolygonSymbolizer copy = (PolygonSymbolizer)this.pages.peek();
        Unit<Length> uom = copy.getUnitOfMeasure();
        if (uom == null || uom.equals(NonSI.PIXEL)) {
            return;
        }
        this.rescaleStroke(copy.getStroke(), this.mapScale, uom);
        this.rescaleFill(copy.getFill(), this.mapScale, uom);
        copy.setUnitOfMeasure(NonSI.PIXEL);
    }

    private void rescaleFill(Fill copyFill, double mapScale, Unit<Length> unit) {
        if (copyFill != null) {
            this.rescale(copyFill.getGraphicFill(), mapScale, unit);
        }
    }

    @Override
    public void visit(TextSymbolizer text) {
        Font[] fonts;
        super.visit(text);
        TextSymbolizer copy = (TextSymbolizer)this.pages.peek();
        Unit<Length> uom = copy.getUnitOfMeasure();
        if (uom == null || uom.equals(NonSI.PIXEL)) {
            return;
        }
        for (Font font : fonts = copy.getFonts()) {
            font.setSize(this.rescale(font.getSize(), this.mapScale, uom));
        }
        copy.setFonts(fonts);
        LabelPlacement placement = copy.getLabelPlacement();
        if (placement instanceof PointPlacement) {
            PointPlacement pointPlacement = (PointPlacement)placement;
            Displacement disp = pointPlacement.getDisplacement();
            if (disp != null) {
                disp.setDisplacementX(this.rescale(disp.getDisplacementX(), this.mapScale, uom));
                disp.setDisplacementY(this.rescale(disp.getDisplacementY(), this.mapScale, uom));
                pointPlacement.setDisplacement(disp);
            }
        } else if (placement instanceof LinePlacement) {
            LinePlacement linePlacement = (LinePlacement)placement;
            linePlacement.setGap(this.rescale(linePlacement.getGap(), this.mapScale, uom));
            linePlacement.setInitialGap(this.rescale(linePlacement.getInitialGap(), this.mapScale, uom));
            linePlacement.setPerpendicularOffset(this.rescale(linePlacement.getPerpendicularOffset(), this.mapScale, uom));
        }
        copy.setLabelPlacement(placement);
        if (copy.getHalo() != null) {
            copy.getHalo().setRadius(this.rescale(copy.getHalo().getRadius(), this.mapScale, uom));
        }
        if (copy instanceof TextSymbolizer2) {
            TextSymbolizer2 copy2 = (TextSymbolizer2)copy;
            this.rescale(copy2.getGraphic(), this.mapScale, uom);
        }
        Map<String, String> options = copy.getOptions();
        this.scaleIntOption(options, "maxDisplacement", uom);
        this.scaleIntOption(options, "spaceAround", uom);
        this.scaleIntOption(options, "minGroupDistance", uom);
        this.scaleIntOption(options, "repeat", uom);
        this.scaleIntOption(options, "autoWrap", uom);
        this.scaleIntArrayOption(options, "graphic-margin", uom);
        copy.setUnitOfMeasure(NonSI.PIXEL);
    }

    private void scaleIntOption(Map<String, String> options, String optionName, Unit<Length> uom) {
        if (options.containsKey(optionName)) {
            double v = this.rescale(Double.parseDouble(options.get(optionName)), this.mapScale, uom);
            options.put(optionName, Integer.toString((int)v));
        }
    }

    private void scaleIntArrayOption(Map<String, String> options, String optionName, Unit<Length> uom) {
        if (options.containsKey(optionName)) {
            String strValue = options.get(optionName);
            String[] splitted = strValue.split("\\s+");
            StringBuilder sb = new StringBuilder();
            for (String value : splitted) {
                double rescaled = this.rescale(Double.parseDouble(value), this.mapScale, uom);
                sb.append((int)rescaled).append(" ");
            }
            sb.setLength(sb.length() - 1);
            options.put(optionName, sb.toString());
        }
    }
}

