/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class CLibPNGImageWriterSpi
extends ImageWriterSpi {
    private static final String[] names = new String[]{"png", "PNG"};
    private static final String[] suffixes = new String[]{"png"};
    private static final String[] MIMETypes = new String[]{"image/png", "image/x-png"};
    private static final String writerClassName = "com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter";
    private static final String[] readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.png.CLibPNGImageReaderSpi"};
    private boolean registered = false;

    public CLibPNGImageWriterSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), names, suffixes, MIMETypes, writerClassName, STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, "javax_imageio_png_1.0", "com.sun.media.imageioimpl.plugins.png.CLibPNGMetadataFormat", null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        if (!PackageUtil.isCodecLibAvailable()) {
            registry.deregisterServiceProvider(this);
        } else {
            List list = ImageUtil.getJDKImageReaderWriterSPI(registry, "PNG", false);
            for (int i = 0; i < list.size(); ++i) {
                registry.setOrdering(category, this, list.get(i));
            }
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier type) {
        boolean hasAlpha;
        SampleModel sampleModel = type.getSampleModel();
        ColorModel colorModel = type.getColorModel();
        int[] sampleSize = sampleModel.getSampleSize();
        int bitDepth = sampleSize[0];
        for (int i = 1; i < sampleSize.length; ++i) {
            if (sampleSize[i] == bitDepth) continue;
            return false;
        }
        if (bitDepth != 1 && bitDepth != 8 && bitDepth != 16) {
            return false;
        }
        int numBands = sampleModel.getNumBands();
        if (numBands < 1 || numBands > 4) {
            return false;
        }
        if (colorModel instanceof IndexColorModel) {
            return true;
        }
        boolean bl = hasAlpha = colorModel != null && colorModel.hasAlpha();
        if ((numBands == 1 || numBands == 3) && hasAlpha) {
            return false;
        }
        return numBands != 2 && numBands != 4 || hasAlpha;
    }

    public String getDescription(Locale locale) {
        String desc = PackageUtil.getSpecificationTitle() + " natively-accelerated PNG Image Writer";
        return desc;
    }

    public ImageWriter createWriterInstance(Object extension) {
        return new CLibPNGImageWriter(this);
    }
}

