/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.rangelookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jaitools.media.jai.rangelookup.LookupItem;
import org.jaitools.media.jai.rangelookup.LookupItemComparator;
import org.jaitools.numeric.NumberOperations;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.RangeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeLookupTable<T extends Number, U extends Number> {
    private final List<LookupItem<T, U>> items;

    private RangeLookupTable(Builder builder) {
        this.items = new ArrayList<LookupItem<T, U>>(builder.items);
        Collections.sort(this.items, new LookupItemComparator());
    }

    public LookupItem<T, U> getLookupItem(T srcValue) {
        if (this.items.isEmpty()) {
            return null;
        }
        int lo = 0;
        int hi = this.items.size() - 1;
        while (hi >= lo) {
            int mid = lo + (hi - lo) / 2;
            LookupItem<T, U> item = this.items.get(mid);
            Range<T> r = item.getRange();
            if (r.contains(srcValue)) {
                return item;
            }
            if (!r.isMinNegInf() && NumberOperations.compare(srcValue, (Number)r.getMin()) <= 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (LookupItem<T, U> item : this.items) {
            sb.append(item).append("; ");
        }
        return sb.toString();
    }

    List<LookupItem<T, U>> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T extends Number, U extends Number> {
        private final List<LookupItem<T, U>> items = new ArrayList<LookupItem<T, U>>();

        public RangeLookupTable<T, U> build() {
            return new RangeLookupTable(this);
        }

        public Builder add(Range<T> srcRange, U resultValue) {
            if (srcRange == null || resultValue == null) {
                throw new IllegalArgumentException("arguments must not be null");
            }
            for (LookupItem<T, U> item : this.items) {
                if (!srcRange.intersects(item.getRange())) continue;
                List diffs = RangeUtils.subtract(item.getRange(), srcRange);
                for (Range diff : diffs) {
                    this.add(diff, resultValue);
                }
                return this;
            }
            this.items.add(new LookupItem<T, U>(srcRange, resultValue));
            return this;
        }
    }
}

