/*
 * Decompiled with CFR 0.152.
 */
package terracer;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import terracer.HouseNumberInputHandler;

public class HouseNumberInputDialog
extends ExtendedDialog {
    static final String HANDLE_RELATION = "plugins.terracer.handle_relation";
    static final String DELETE_OUTLINE = "plugins.terracer.delete_outline";
    static final String INTERPOLATION = "plugins.terracer.interpolation";
    private final String streetName;
    private final String buildingType;
    private final boolean relationExists;
    final ArrayList<Node> housenumbers;
    protected static final String DEFAULT_MESSAGE = I18n.tr((String)"Enter housenumbers or amount of segments", (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;
    private Container jContentPane;
    private JPanel inputPanel;
    private JLabel loLabel;
    JTextField lo;
    private JLabel hiLabel;
    JTextField hi;
    private JLabel numbersLabel;
    JTextField numbers;
    private JLabel streetLabel;
    AutoCompletingComboBox streetComboBox;
    private JLabel buildingLabel;
    AutoCompletingComboBox buildingComboBox;
    private JLabel segmentsLabel;
    JTextField segments;
    JTextArea messageLabel;
    private JLabel interpolationLabel;
    Choice interpolation;
    JCheckBox handleRelationCheckBox;
    JCheckBox deleteOutlineCheckBox;
    HouseNumberInputHandler inputHandler;

    public HouseNumberInputDialog(HouseNumberInputHandler handler, Way street, String streetName, String buildingType, boolean relationExists, ArrayList<Node> housenumbers) {
        super(Main.parent, I18n.tr((String)"Terrace a house", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, true);
        this.inputHandler = handler;
        this.streetName = streetName;
        this.buildingType = buildingType;
        this.relationExists = relationExists;
        this.housenumbers = housenumbers;
        handler.dialog = this;
        JPanel content = this.getInputPanel();
        this.setContent(content);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.getJContentPane();
        this.initialize();
        this.setDefaultButton(1);
        this.setupDialog();
        this.getRootPane().setDefaultButton(this.defaultButton);
        this.setVisible(true);
        this.lo.requestFocus();
    }

    private void initialize() {
        this.lo.addFocusListener(this.inputHandler);
        this.hi.addFocusListener(this.inputHandler);
        this.segments.addFocusListener(this.inputHandler);
        this.interpolation.addItemListener(this.inputHandler);
    }

    private Container getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = this.getContentPane();
            this.jContentPane.setLayout(new BoxLayout(this.jContentPane, 1));
            this.jContentPane.add((Component)this.getInputPanel(), (Object)this.jContentPane);
        }
        return this.jContentPane;
    }

    private JPanel getInputPanel() {
        if (this.inputPanel == null) {
            GridBagConstraints c = new GridBagConstraints();
            this.messageLabel = new JTextArea();
            this.messageLabel.setText(DEFAULT_MESSAGE);
            this.messageLabel.setAutoscrolls(true);
            this.messageLabel.setLineWrap(true);
            this.messageLabel.setRows(2);
            this.messageLabel.setBackground(new Color(238, 238, 238));
            this.messageLabel.setEditable(false);
            this.messageLabel.setFocusable(false);
            this.interpolationLabel = new JLabel(I18n.tr((String)"Interpolation", (Object[])new Object[0]));
            this.segmentsLabel = new JLabel(I18n.tr((String)"Segments", (Object[])new Object[0]));
            this.streetLabel = new JLabel(I18n.tr((String)"Street", (Object[])new Object[0]));
            this.buildingLabel = new JLabel(I18n.tr((String)"Building", (Object[])new Object[0]));
            this.loLabel = new JLabel(I18n.tr((String)"Lowest Number", (Object[])new Object[0]));
            this.loLabel.setPreferredSize(new Dimension(111, 16));
            this.loLabel.setToolTipText(I18n.tr((String)"Lowest housenumber of the terraced house", (Object[])new Object[0]));
            this.hiLabel = new JLabel(I18n.tr((String)"Highest Number", (Object[])new Object[0]));
            this.numbersLabel = new JLabel(I18n.tr((String)"List of Numbers", (Object[])new Object[0]));
            this.loLabel.setPreferredSize(new Dimension(111, 16));
            String txt = this.relationExists ? I18n.tr((String)"add to existing associatedStreet relation", (Object[])new Object[0]) : I18n.tr((String)"create an associatedStreet relation", (Object[])new Object[0]);
            this.handleRelationCheckBox = new JCheckBox(txt, Main.pref.getBoolean(HANDLE_RELATION, true));
            this.deleteOutlineCheckBox = new JCheckBox(I18n.tr((String)"delete outline way", (Object[])new Object[0]), Main.pref.getBoolean(DELETE_OUTLINE, true));
            this.inputPanel = new JPanel();
            this.inputPanel.setLayout(new GridBagLayout());
            c.fill = 2;
            c.gridwidth = 0;
            this.inputPanel.add((Component)this.messageLabel, c);
            this.inputPanel.add((Component)this.loLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getLo(), GBC.eol().fill(2).insets(5, 3, 0, 0));
            this.inputPanel.add((Component)this.hiLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getHi(), GBC.eol().fill(2).insets(5, 3, 0, 0));
            this.inputPanel.add((Component)this.numbersLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getNumbers(), GBC.eol().fill(2).insets(5, 3, 0, 0));
            this.inputPanel.add((Component)this.interpolationLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getInterpolation(), GBC.eol().insets(5, 3, 0, 0));
            this.inputPanel.add((Component)this.segmentsLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getSegments(), GBC.eol().fill(2).insets(5, 3, 0, 0));
            if (this.streetName == null) {
                this.inputPanel.add((Component)this.streetLabel, GBC.std().insets(3, 3, 0, 0));
                this.inputPanel.add((Component)this.getStreet(), GBC.eol().insets(5, 3, 0, 0));
            } else {
                this.inputPanel.add((Component)new JLabel(String.valueOf(I18n.tr((String)"Street name: ", (Object[])new Object[0])) + "\"" + this.streetName + "\""), GBC.eol().insets(3, 3, 0, 0));
            }
            if (this.buildingType == null) {
                this.inputPanel.add((Component)this.buildingLabel, GBC.std().insets(3, 3, 0, 0));
                this.inputPanel.add((Component)this.getBuilding(), GBC.eol().insets(5, 3, 0, 0));
            } else {
                this.inputPanel.add((Component)new JLabel(String.valueOf(I18n.tr((String)"Building: ", (Object[])new Object[0])) + "\"" + this.buildingType + "\""), GBC.eol().insets(3, 3, 0, 0));
            }
            this.inputPanel.add((Component)this.handleRelationCheckBox, GBC.eol().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.deleteOutlineCheckBox, GBC.eol().insets(3, 3, 0, 0));
            if (this.numbers.isVisible()) {
                this.loLabel.setVisible(false);
                this.lo.setVisible(false);
                this.lo.setEnabled(false);
                this.hiLabel.setVisible(false);
                this.hi.setVisible(false);
                this.hi.setEnabled(false);
                this.interpolationLabel.setVisible(false);
                this.interpolation.setVisible(false);
                this.interpolation.setEnabled(false);
                this.segments.setText(String.valueOf(this.housenumbers.size()));
                this.segments.setEditable(false);
            }
        }
        return this.inputPanel;
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        this.inputHandler.actionPerformed(evt);
    }

    private JTextField getLo() {
        if (this.lo == null) {
            this.lo = new JTextField();
            this.lo.setText("");
        }
        return this.lo;
    }

    private JTextField getHi() {
        if (this.hi == null) {
            this.hi = new JTextField();
            this.hi.setText("");
        }
        return this.hi;
    }

    private JTextField getNumbers() {
        if (this.numbers == null) {
            this.numbers = new JTextField();
            Iterator<Node> it = this.housenumbers.iterator();
            StringBuilder s = new StringBuilder(256);
            if (it.hasNext()) {
                s.append(it.next().get("addr:housenumber"));
                while (it.hasNext()) {
                    s.append(';').append(it.next().get("addr:housenumber"));
                }
            } else {
                this.numbersLabel.setVisible(false);
                this.numbers.setVisible(false);
            }
            this.numbers.setText(s.toString());
            this.numbers.setEditable(false);
        }
        return this.numbers;
    }

    private AutoCompletingComboBox getStreet() {
        if (this.streetComboBox == null) {
            TreeSet<String> names = this.createAutoCompletionInfo();
            this.streetComboBox = new AutoCompletingComboBox();
            this.streetComboBox.setPossibleItems(names);
            this.streetComboBox.setEditable(true);
            this.streetComboBox.setSelectedItem(null);
        }
        return this.streetComboBox;
    }

    private AutoCompletingComboBox getBuilding() {
        if (this.buildingComboBox == null) {
            List values = Main.main.getCurrentDataSet().getAutoCompletionManager().getValues("building");
            this.buildingComboBox = new AutoCompletingComboBox();
            this.buildingComboBox.setPossibleACItems((Collection)values);
            this.buildingComboBox.setEditable(true);
            this.buildingComboBox.setSelectedItem((Object)"yes");
        }
        return this.buildingComboBox;
    }

    private JTextField getSegments() {
        if (this.segments == null) {
            this.segments = new JTextField();
            this.segments.setText("1");
        }
        return this.segments;
    }

    private Choice getInterpolation() {
        if (this.interpolation == null) {
            this.interpolation = new Choice();
            this.interpolation.add(I18n.tr((String)"All", (Object[])new Object[0]));
            this.interpolation.add(I18n.tr((String)"Even/Odd", (Object[])new Object[0]));
            if (Main.pref.getInteger(INTERPOLATION, 2) == 1) {
                this.interpolation.select(I18n.tr((String)"All", (Object[])new Object[0]));
            } else {
                this.interpolation.select(I18n.tr((String)"Even/Odd", (Object[])new Object[0]));
            }
        }
        return this.interpolation;
    }

    TreeSet<String> createAutoCompletionInfo() {
        TreeSet<String> names = new TreeSet<String>();
        for (OsmPrimitive osm : Main.main.getCurrentDataSet().allNonDeletedPrimitives()) {
            if (osm.getKeys() == null || !osm.keySet().contains("highway") || !osm.keySet().contains("name")) continue;
            names.add(osm.get("name"));
        }
        return names;
    }
}

