/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.list;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnrestrictions.list.TurnRestrictionsListModel;

public class TurnRestrictionsInDatasetListModel
extends TurnRestrictionsListModel
implements MapView.EditLayerChangeListener,
DataSetListener {
    public TurnRestrictionsInDatasetListModel(DefaultListSelectionModel selectionModel) {
        super(selectionModel);
    }

    protected List<Relation> filterTurnRestrictions(Collection<? extends OsmPrimitive> primitives) {
        LinkedList<Relation> ret = new LinkedList<Relation>();
        if (primitives == null) {
            return ret;
        }
        for (OsmPrimitive osmPrimitive : primitives) {
            if (!this.isTurnRestriction(osmPrimitive)) continue;
            ret.add((Relation)osmPrimitive);
        }
        return ret;
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        if (newLayer == null) {
            this.setTurnRestrictions(null);
            return;
        }
        LinkedList<Relation> turnRestrictions = new LinkedList<Relation>();
        for (Relation r : newLayer.data.getRelations()) {
            if (!this.isValid(r) || !this.isTurnRestriction((OsmPrimitive)r)) continue;
            turnRestrictions.add(r);
        }
        this.setTurnRestrictions(turnRestrictions);
    }

    public void dataChanged(DataChangedEvent event) {
        OsmDataLayer layer = Main.map.mapView.getEditLayer();
        if (layer == null) {
            this.setTurnRestrictions(null);
        } else {
            List<Relation> turnRestrictions = this.filterTurnRestrictions(layer.data.getRelations());
            this.setTurnRestrictions(turnRestrictions);
        }
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
        List<Relation> turnRestrictions = this.filterTurnRestrictions(event.getPrimitives());
        if (!turnRestrictions.isEmpty()) {
            this.addTurnRestrictions(turnRestrictions);
        }
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        List<Relation> turnRestrictions = this.filterTurnRestrictions(event.getPrimitives());
        if (!turnRestrictions.isEmpty()) {
            this.removeTurnRestrictions(turnRestrictions);
        }
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
        List<Relation> turnRestrictions = this.filterTurnRestrictions(event.getPrimitives());
        if (!turnRestrictions.isEmpty()) {
            List<Relation> sel = this.getSelectedTurnRestrictions();
            for (Relation tr : turnRestrictions) {
                int idx = this.getTurnRestrictionIndex(tr);
                this.fireContentsChanged(this, idx, idx);
            }
            this.setSelectedTurnRestrictions(sel);
        }
    }

    public void tagsChanged(TagsChangedEvent event) {
        List<Relation> turnRestrictions = this.filterTurnRestrictions(event.getPrimitives());
        if (!turnRestrictions.isEmpty()) {
            List<Relation> sel = this.getSelectedTurnRestrictions();
            for (Relation tr : turnRestrictions) {
                int idx = this.getTurnRestrictionIndex(tr);
                this.fireContentsChanged(this, idx, idx);
            }
            this.setSelectedTurnRestrictions(sel);
        }
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }
}

