/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdListProvider;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdListTransferHandler;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.JosmSelectionListModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class JosmSelectionPanel
extends JPanel {
    private JList lstSelection;
    private JosmSelectionListModel model;
    private CopyAction actCopy;
    private TransferHandler transferHandler;

    protected void build(OsmDataLayer layer) {
        this.setLayout(new BorderLayout());
        this.lstSelection = new JList(this.model);
        this.lstSelection.setSelectionMode(2);
        this.lstSelection.setSelectionModel(this.model.getListSelectionModel());
        this.lstSelection.setCellRenderer(new OsmPrimitivRenderer());
        this.transferHandler = new JosmSelectionTransferHandler(this.model);
        this.lstSelection.setTransferHandler(this.transferHandler);
        this.lstSelection.setDragEnabled(true);
        this.add((Component)new JScrollPane(this.lstSelection), "Center");
        this.add((Component)new JLabel(I18n.tr((String)"Selection", (Object[])new Object[0])), "North");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.actCopy = new CopyAction();
        this.lstSelection.addMouseListener((MouseListener)((Object)new PopupLauncher()));
    }

    public JosmSelectionPanel(OsmDataLayer layer, JosmSelectionListModel model) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)layer, (String)"layer");
        this.model = model;
        this.build(layer);
    }

    public void wireListeners() {
        MapView.addEditLayerChangeListener((MapView.EditLayerChangeListener)this.model);
        DatasetEventManager.getInstance().addDatasetListener((DataSetListener)this.model, DatasetEventManager.FireMode.IN_EDT);
        SelectionEventManager.getInstance().addSelectionListener((SelectionChangedListener)this.model, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
    }

    public void unwireListeners() {
        MapView.removeEditLayerChangeListener((MapView.EditLayerChangeListener)this.model);
        DatasetEventManager.getInstance().removeDatasetListener((DataSetListener)this.model);
        SelectionEventManager.getInstance().removeSelectionListener((SelectionChangedListener)this.model);
    }

    class CopyAction
    extends AbstractAction {
        private Action delegate;

        public CopyAction() {
            this.putValue("Name", I18n.tr((String)"Copy", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Copy to the clipboard", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"copy"));
            this.putValue("AcceleratorKey", Shortcut.getCopyKeyStroke());
            this.delegate = JosmSelectionPanel.this.lstSelection.getActionMap().get("copy");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.delegate.actionPerformed(e);
        }
    }

    private static class JosmSelectionTransferHandler
    extends PrimitiveIdListTransferHandler {
        public JosmSelectionTransferHandler(PrimitiveIdListProvider provider) {
            super(provider);
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return false;
        }
    }

    class PopupLauncher
    extends PopupMenuLauncher {
        PopupLauncher() {
        }

        public void launch(MouseEvent evt) {
            new PopupMenu().show(JosmSelectionPanel.this.lstSelection, evt.getX(), evt.getY());
        }
    }

    class PopupMenu
    extends JPopupMenu {
        public PopupMenu() {
            JMenuItem item = this.add(JosmSelectionPanel.this.actCopy);
            item.setTransferHandler(JosmSelectionPanel.this.transferHandler);
            JosmSelectionPanel.this.actCopy.setEnabled(!JosmSelectionPanel.this.model.getSelected().isEmpty());
        }
    }
}

