/*
 * Decompiled with CFR 0.152.
 */
package mirrored_download;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import mirrored_download.MirroredDownloadPlugin;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MirroredDownloadAction
extends JosmAction {
    static final String XAPI_QUERY_HISTORY_KEY = "plugin.mirrored_download.query-history";
    static final String XAPI_QUERY_TOOLTIP = I18n.tr((String)"XAPI query, e.g., '''' (to download all data), ''[highway=*]'', or ''[[network=VRR][ref=603|613]''", (Object[])new Object[0]);

    public MirroredDownloadAction() {
        super(I18n.tr((String)"Download from OSM mirror...", (Object[])new Object[0]), "download_mirror", I18n.tr((String)"Download map data from the OSM server.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"mirror:download", (String)I18n.tr((String)"File: {0}", (Object[])new Object[]{I18n.tr((String)"Download from OSM mirror...", (Object[])new Object[0])}), (int)40, (int)5007), true, "mirroreddownload/download", true);
        this.putValue("help", HelpUtil.ht((String)"/Action/MirroredDownload"));
    }

    public void actionPerformed(ActionEvent e) {
        MirroredDownloadDialog dialog = MirroredDownloadDialog.getInstance();
        dialog.restoreSettings();
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            dialog.rememberSettings();
            Bounds area = dialog.getSelectedDownloadArea();
            DownloadOsmTask task = new DownloadOsmTask();
            Future future = task.download((OsmServerReader)new MirroredDownloadReader(area, dialog.getOverpassType(), dialog.getOverpassQuery()), dialog.isNewLayerRequired(), area, null);
            Main.worker.submit((Runnable)new PostDownloadHandler((DownloadTask)task, future));
        }
    }

    static class MirroredDownloadReader
    extends BoundingBoxDownloader {
        final String overpassType;
        final String overpassQuery;

        public MirroredDownloadReader(Bounds downloadArea, String overpassType, String overpassQuery) {
            super(downloadArea);
            this.overpassType = overpassType;
            this.overpassQuery = overpassQuery.trim();
        }

        protected String getBaseUrl() {
            return MirroredDownloadPlugin.getDownloadUrl();
        }

        protected String getRequestForBbox(double lon1, double lat1, double lon2, double lat2) {
            if (this.overpassQuery.isEmpty() && "*".equals(this.overpassType)) {
                return super.getRequestForBbox(lon1, lat1, lon2, lat2);
            }
            if (MirroredDownloadPlugin.getAddMeta()) {
                String url = this.overpassType + (this.overpassQuery.contains("[bbox=") ? "" : "[bbox=" + lon1 + "," + lat1 + "," + lon2 + "," + lat2 + "]") + (this.overpassQuery.contains("[@meta]") ? "" : "[@meta]") + this.overpassQuery;
                try {
                    url = URLEncoder.encode(url, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                return url;
            }
            return this.overpassType + "[bbox=" + lon1 + "," + lat1 + "," + lon2 + "," + lat2 + "]" + this.overpassQuery;
        }

        public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
            DataSet ds = super.parseOsm(progressMonitor);
            if (ds != null && ds.dataSources.isEmpty()) {
                if (this.crosses180th) {
                    Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, 180.0);
                    DataSource src = new DataSource(bounds, MirroredDownloadPlugin.getDownloadUrl());
                    ds.dataSources.add(src);
                    bounds = new Bounds(this.lat1, -180.0, this.lat2, this.lon2);
                    src = new DataSource(bounds, MirroredDownloadPlugin.getDownloadUrl());
                    ds.dataSources.add(src);
                } else {
                    Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, this.lon2);
                    DataSource src = new DataSource(bounds, MirroredDownloadPlugin.getDownloadUrl());
                    ds.dataSources.add(src);
                }
            }
            return ds;
        }
    }

    static class MirroredDownloadDialog
    extends DownloadDialog {
        protected JComboBox overpassType;
        protected HistoryComboBox overpassQuery;
        private static MirroredDownloadDialog instance;

        private MirroredDownloadDialog(Component parent) {
            super(parent);
            this.cbDownloadOsmData.setEnabled(false);
            this.cbDownloadGpxData.setEnabled(false);
            this.cbStartup.setEnabled(false);
        }

        public static MirroredDownloadDialog getInstance() {
            if (instance == null) {
                instance = new MirroredDownloadDialog(Main.parent);
            }
            return instance;
        }

        protected void buildMainPanelAboveDownloadSelections(JPanel pnl) {
            this.overpassType = new JComboBox<String>(new String[]{"*", "node", "way", "relation"});
            pnl.add((Component)new JLabel(I18n.tr((String)"Object type: ", (Object[])new Object[0])), GBC.std().insets(5, 5, 5, 5));
            pnl.add((Component)this.overpassType, GBC.eol().fill(2));
            this.overpassType.setToolTipText(I18n.tr((String)"OSM object type to download (''*'' stands for any)", (Object[])new Object[0]));
            this.overpassQuery = new HistoryComboBox();
            pnl.add((Component)new JLabel(I18n.tr((String)"XAPI query: ", (Object[])new Object[0])), GBC.std().insets(5, 5, 5, 5));
            new XAPIQueryValidator((JTextComponent)this.overpassQuery.getEditor().getEditorComponent());
            pnl.add((Component)this.overpassQuery, GBC.eol().fill(2));
            this.overpassQuery.setToolTipText(XAPI_QUERY_TOOLTIP);
        }

        public String getOverpassQuery() {
            return this.overpassQuery.getText();
        }

        public String getOverpassType() {
            return (String)this.overpassType.getItemAt(this.overpassType.getSelectedIndex());
        }

        public void restoreSettings() {
            super.restoreSettings();
            this.overpassQuery.setPossibleItems(Main.pref.getCollection(MirroredDownloadAction.XAPI_QUERY_HISTORY_KEY, new LinkedList()));
        }

        public void rememberSettings() {
            super.rememberSettings();
            this.overpassQuery.addCurrentItemToHistory();
            Main.pref.putCollection(MirroredDownloadAction.XAPI_QUERY_HISTORY_KEY, (Collection)this.overpassQuery.getHistory());
        }
    }

    static class XAPIQueryValidator
    extends AbstractTextComponentValidator {
        static final Pattern pattern = Pattern.compile("^(\\[([^=]+=[^=]*)\\])*$");

        public XAPIQueryValidator(JTextComponent tc) throws IllegalArgumentException {
            super(tc);
        }

        public void validate() {
            if (pattern.matcher(this.getComponent().getText().trim()).matches()) {
                this.feedbackValid(XAPI_QUERY_TOOLTIP);
            } else {
                this.feedbackInvalid(I18n.tr((String)"This XAPI query seems to be invalid, please doublecheck", (Object[])new Object[0]));
            }
        }

        public boolean isValid() {
            return pattern.matcher(this.getComponent().getText().trim()).matches();
        }
    }
}

