/*
 * Decompiled with CFR 0.152.
 */
package panels;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import messages.Messages;
import seamarks.SeaMark;
import smed.SmedAction;

public class PanelSaw
extends JPanel {
    private SmedAction dlg;
    public ButtonGroup shapeButtons = new ButtonGroup();
    public JRadioButton pillarButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/PillarButton.png")));
    public JRadioButton sparButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/SparButton.png")));
    public JRadioButton sphereButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/SphereButton.png")));
    public JRadioButton floatButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/FloatButton.png")));
    public JRadioButton beaconButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/BeaconButton.png")));
    public EnumMap<SeaMark.Shp, JRadioButton> shapes = new EnumMap(SeaMark.Shp.class);
    public EnumMap<SeaMark.Shp, SeaMark.Obj> objects = new EnumMap(SeaMark.Shp.class);
    public ActionListener alShape = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Shp shp : PanelSaw.this.shapes.keySet()) {
                JRadioButton button = PanelSaw.this.shapes.get((Object)shp);
                if (button.isSelected()) {
                    PanelSaw.this.dlg;
                    SmedAction.panelMain.mark.setShape(shp);
                    PanelSaw.this.dlg;
                    SmedAction.panelMain.mark.setObject(PanelSaw.this.objects.get((Object)shp));
                    button.setBorderPainted(true);
                    continue;
                }
                button.setBorderPainted(false);
            }
            PanelSaw.this.dlg;
            if (SmedAction.panelMain.mark.testValid()) {
                PanelSaw.this.dlg;
                SmedAction.panelMain.panelChan.topmarkButton.setVisible(true);
                PanelSaw.this.dlg;
                SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.VSTRP);
                PanelSaw.this.dlg;
                SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                PanelSaw.this.dlg;
                SmedAction.panelMain.mark.addObjColour(SeaMark.Col.WHITE);
            } else {
                PanelSaw.this.dlg;
                SmedAction.panelMain.panelChan.topmarkButton.setVisible(false);
            }
            PanelSaw.this.dlg;
            SmedAction.panelMain.panelMore.syncPanel();
        }
    };

    public PanelSaw(SmedAction dia) {
        this.dlg = dia;
        this.setLayout(null);
        this.add(this.getShapeButton(this.pillarButton, 0, 0, 34, 32, "Pillar", SeaMark.Shp.PILLAR, SeaMark.Obj.BOYSAW));
        this.add(this.getShapeButton(this.sparButton, 0, 32, 34, 32, "Spar", SeaMark.Shp.SPAR, SeaMark.Obj.BOYSAW));
        this.add(this.getShapeButton(this.sphereButton, 0, 64, 34, 32, "Sphere", SeaMark.Shp.SPHERI, SeaMark.Obj.BOYSAW));
        this.add(this.getShapeButton(this.floatButton, 0, 96, 34, 32, "Float", SeaMark.Shp.FLOAT, SeaMark.Obj.FLTSAW));
        this.add(this.getShapeButton(this.beaconButton, 0, 128, 34, 32, "Beacon", SeaMark.Shp.BEACON, SeaMark.Obj.BCNSAW));
    }

    public void syncPanel() {
        for (SeaMark.Shp shp : this.shapes.keySet()) {
            JRadioButton button = this.shapes.get((Object)shp);
            if (SmedAction.panelMain.mark.getShape() == shp) {
                button.setBorderPainted(true);
                continue;
            }
            button.setBorderPainted(false);
        }
        SmedAction.panelMain.mark.testValid();
    }

    private JRadioButton getShapeButton(JRadioButton button, int x, int y, int w, int h, String tip, SeaMark.Shp shp, SeaMark.Obj obj) {
        button.setBounds(new Rectangle(x, y, w, h));
        button.setBorder(BorderFactory.createLoweredBevelBorder());
        button.setToolTipText(Messages.getString(tip));
        button.addActionListener(this.alShape);
        this.shapeButtons.add(button);
        this.shapes.put(shp, button);
        this.objects.put(shp, obj);
        return button;
    }
}

