/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.urbanisme;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.opendata.core.util.NamesFrUtils;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class VoirieHandler
extends ToulouseDataSetHandler {
    protected final Map<String, Collection<String>> map = new HashMap<String, Collection<String>>();
    private String streetField;

    public VoirieHandler() {
        this(12693, "lib_off", "highway");
        this.setName("Filaire de voirie");
        this.setCategory(CAT_URBANISME);
        this.setMenuIcon("presets/way_secondary.png");
    }

    protected VoirieHandler(int portalId, String streetField, String relevantTag) {
        super(portalId, relevantTag);
        this.streetField = streetField;
        this.map.put("motorway", Arrays.asList("A6", "AUTOROUTE "));
        this.map.put("trunk", Arrays.asList("ROCADE "));
        this.map.put("secondary", Arrays.asList("AV ", "BD ", "ALL ", "PONT ", "RTE ", "PORT ", "BOULINGRIN"));
        this.map.put("residential", Arrays.asList("RUE ", "GRANDE-RUE ", "PROM ", "CHE", "CAMINOT ", "IMP ", "COURS ", "LOT ", "ANC", "VIEUX ", "PL ", "CLOS ", "CITE ", "RESIDENCE ", "SENTIER ", "QU ", "SQ ", "VOIE ", "ESP "));
        this.map.put("unclassified", Arrays.asList("ZONE "));
        this.map.put("road", Arrays.asList("VA "));
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsKmzTabFilename(filename, new String[]{"Voies"});
    }

    private String applyHighwayTag(String name, IPrimitive p) {
        if (name != null && p != null) {
            for (String key : this.map.keySet()) {
                for (String value : this.map.get(key)) {
                    if (!name.startsWith(value)) continue;
                    p.put("highway", key);
                    return key;
                }
            }
        }
        return null;
    }

    protected String getStreetId(Way w) {
        return w.get("sti");
    }

    public void updateDataSet(DataSet ds) {
        HashMap<String, Relation> associatedStreets = new HashMap<String, Relation>();
        for (Way w : ds.getWays()) {
            String name = w.get(this.streetField);
            if (name == null) continue;
            w.remove(this.streetField);
            w.remove("mot_directeur");
            w.remove("color");
            w.remove("rivoli");
            w.remove("nrivoli");
            if (this.applyHighwayTag(name, (IPrimitive)w) == null) {
                w.put("highway", "road");
            }
            if (name.startsWith("RPT ") || name.startsWith("GIRATOIRE ")) {
                w.put("junction", "roundabout");
            } else if (name.matches("RTE D[0-9]+")) {
                w.put("ref", name.split(" ")[1]);
            }
            w.put("name", name);
            if (name.matches("D[0-9]+.*")) {
                w.put("highway", "secondary");
                this.replace((IPrimitive)w, "name", "ref");
            } else if (!name.startsWith("VA ")) {
                name = NamesFrUtils.checkStreetName((OsmPrimitive)w, (String)"name");
            }
            if (name.startsWith("VA ")) continue;
            Relation street = (Relation)associatedStreets.get(this.getStreetId(w));
            if (street == null) {
                street = new Relation();
                associatedStreets.put(this.getStreetId(w), street);
                street.put("type", "associatedStreet");
                street.put("name", name);
                ds.addPrimitive((OsmPrimitive)street);
            }
            street.addMember(new RelationMember("street", (OsmPrimitive)w));
        }
    }
}

