/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.sncf.datasets;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.sncf.datasets.SncfDataSetHandler;

public class EquipementsHandler
extends SncfDataSetHandler {
    public EquipementsHandler() {
        super("equipementsgares");
        this.setCsvHandler((CsvHandler)new LambertIICsvHandler());
        this.setSingleProjection(lambert4Zones[1]);
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsCsvXlsFilename(filename, new String[]{"gare_20......"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            this.replace((IPrimitive)n, "nom gare", "name");
            n.put("railway", "station");
        }
    }

    private class LambertIICsvHandler
    extends FrenchDataSetHandler.InternalCsvHandler {
        private LambertIICsvHandler() {
            super((FrenchDataSetHandler)EquipementsHandler.this);
        }

        public LatLon getCoor(EastNorth en, String[] fields) {
            return super.getCoor(new EastNorth(en.getX(), en.getY() - 2000000.0), fields);
        }
    }
}

