/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditor;

public class TurnRestrictionEditorManager
extends WindowAdapter
implements MapView.LayerChangeListener {
    static TurnRestrictionEditorManager instance;
    private final HashMap<DialogContext, TurnRestrictionEditor> openDialogs = new HashMap();

    public static TurnRestrictionEditorManager getInstance() {
        if (instance == null) {
            instance = new TurnRestrictionEditorManager();
            MapView.addLayerChangeListener((MapView.LayerChangeListener)instance);
        }
        return instance;
    }

    public void register(OsmDataLayer layer, Relation relation, TurnRestrictionEditor editor) {
        if (relation == null) {
            relation = new Relation();
        }
        DialogContext context = new DialogContext(layer, relation.getPrimitiveId());
        this.openDialogs.put(context, editor);
        editor.addWindowListener(this);
    }

    public void updateContext(OsmDataLayer layer, Relation relation, TurnRestrictionEditor editor) {
        DialogContext context2;
        for (DialogContext context2 : this.openDialogs.keySet()) {
            if (this.openDialogs.get(context2) != editor) continue;
            this.openDialogs.remove(context2);
            break;
        }
        context2 = new DialogContext(layer, relation.getPrimitiveId());
        this.openDialogs.put(context2, editor);
    }

    public void close(OsmDataLayer layer, Relation relation) {
        DialogContext context = new DialogContext(layer, (PrimitiveId)relation);
        TurnRestrictionEditor editor = this.openDialogs.get(context);
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public boolean isOpenInEditor(OsmDataLayer layer, Relation relation) {
        if (relation == null) {
            return false;
        }
        DialogContext context = new DialogContext(layer, relation.getPrimitiveId());
        return this.openDialogs.keySet().contains(context);
    }

    public TurnRestrictionEditor getEditorForRelation(OsmDataLayer layer, Relation relation) {
        if (relation == null) {
            return null;
        }
        DialogContext context = new DialogContext(layer, relation.getPrimitiveId());
        return this.openDialogs.get(context);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        TurnRestrictionEditor editor = (TurnRestrictionEditor)e.getWindow();
        DialogContext context = null;
        for (DialogContext c : this.openDialogs.keySet()) {
            if (!editor.equals(this.openDialogs.get(c))) continue;
            context = c;
            break;
        }
        if (context != null) {
            this.openDialogs.remove(context);
        }
    }

    protected void centerOnScreen(TurnRestrictionEditor editor) {
        Point p = new Point(0, 0);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        p.x = (d.width - editor.getSize().width) / 2;
        p.y = (d.height - editor.getSize().height) / 2;
        p.x = Math.max(p.x, 0);
        p.y = Math.max(p.y, 0);
        editor.setLocation(p);
    }

    protected boolean hasEditorWithCloseUpperLeftCorner(Point p) {
        for (TurnRestrictionEditor editor : this.openDialogs.values()) {
            Point corner = editor.getLocation();
            if (p.x < corner.x - 5 || corner.x + 5 < p.x || p.y < corner.y - 5 || corner.y + 5 < p.y) continue;
            return true;
        }
        return false;
    }

    protected void positionCloseToScreenCenter(TurnRestrictionEditor editor) {
        Point p = new Point(0, 0);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        p.x = (d.width - editor.getSize().width) / 2;
        p.y = (d.height - editor.getSize().height) / 2;
        p.x = Math.max(p.x, 0);
        p.y = Math.max(p.y, 0);
        while (this.hasEditorWithCloseUpperLeftCorner(p)) {
            p.x += 20;
            p.y += 20;
        }
        editor.setLocation(p);
    }

    public void positionOnScreen(TurnRestrictionEditor editor) {
        if (editor == null) {
            return;
        }
        if (this.openDialogs.isEmpty()) {
            this.centerOnScreen(editor);
        } else {
            this.positionCloseToScreenCenter(editor);
        }
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer == null || !(oldLayer instanceof OsmDataLayer)) {
            return;
        }
        OsmDataLayer dataLayer = (OsmDataLayer)oldLayer;
        Iterator<Map.Entry<DialogContext, TurnRestrictionEditor>> it = this.openDialogs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<DialogContext, TurnRestrictionEditor> entry = it.next();
            if (!entry.getKey().matchesLayer(dataLayer)) continue;
            TurnRestrictionEditor editor = entry.getValue();
            it.remove();
            editor.setVisible(false);
            editor.dispose();
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
    }

    private static class DialogContext {
        public final PrimitiveId primitiveId;
        public final OsmDataLayer layer;

        public DialogContext(OsmDataLayer layer, PrimitiveId id) {
            this.layer = layer;
            this.primitiveId = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.layer == null ? 0 : this.layer.hashCode());
            result = 31 * result + (this.primitiveId == null ? 0 : this.primitiveId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DialogContext other = (DialogContext)obj;
            if (this.layer == null ? other.layer != null : !this.layer.equals(other.layer)) {
                return false;
            }
            return !(this.primitiveId == null ? other.primitiveId != null : !this.primitiveId.equals(other.primitiveId));
        }

        public boolean matchesLayer(OsmDataLayer layer) {
            if (layer == null) {
                return false;
            }
            return this.layer.equals(layer);
        }

        public String toString() {
            return "[Context: layer=" + this.layer.getName() + ",relation=" + this.primitiveId + "]";
        }
    }
}

