/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdListProvider;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdTransferable;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class PrimitiveIdListTransferHandler
extends TransferHandler {
    private static final Logger logger = Logger.getLogger(PrimitiveIdListTransferHandler.class.getName());
    private PrimitiveIdListProvider provider;

    public static boolean isSupportedFlavor(DataFlavor[] transferFlavors) {
        DataFlavor[] dataFlavorArray = transferFlavors;
        int n = transferFlavors.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor df = dataFlavorArray[n2];
            if (df.equals(PrimitiveIdTransferable.PRIMITIVE_ID_LIST_FLAVOR)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public PrimitiveIdListTransferHandler(PrimitiveIdListProvider provider) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)provider, (String)"provider");
        this.provider = provider;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new PrimitiveIdTransferable(this.provider.getSelectedPrimitiveIds());
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return PrimitiveIdListTransferHandler.isSupportedFlavor(transferFlavors);
    }
}

