/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public final class NodeWayUtils {
    static final int maxLevel = Main.pref.getInteger("selection.maxrecursion", 15);
    static final int maxWays = Main.pref.getInteger("selection.maxfoundways", 2000);
    static final int maxWays1 = Main.pref.getInteger("selection.maxfoundways.intersection", 500);

    static void addNeighbours(Way w, Node n, Collection<Node> nodes) {
        List nodeList = w.getNodes();
        int idx = nodeList.indexOf(n);
        if (idx == -1) {
            return;
        }
        if (idx > 0) {
            nodes.add((Node)nodeList.get(idx - 1));
        }
        if (idx < nodeList.size() - 1) {
            nodes.add((Node)nodeList.get(idx + 1));
        }
        if (w.isClosed()) {
            if (idx == 0) {
                nodes.add((Node)nodeList.get(nodeList.size() - 2));
            }
            if (idx == nodeList.size() - 1) {
                nodes.add((Node)nodeList.get(1));
            }
        }
    }

    static int addWaysConnectedToWay(Way w, Set<Way> ways) {
        int s = ways.size();
        List nodes = w.getNodes();
        boolean flag = ways.contains(w);
        for (Node n : nodes) {
            ways.addAll(OsmPrimitive.getFilteredList((Collection)n.getReferrers(), Way.class));
        }
        if (!flag) {
            ways.remove(w);
        }
        return ways.size() - s;
    }

    static int addWaysConnectedToNode(Node n, Set<Way> ways) {
        int s = ways.size();
        ways.addAll(OsmPrimitive.getFilteredList((Collection)n.getReferrers(), Way.class));
        return ways.size() - s;
    }

    static int addWaysIntersectingWay(Collection<Way> ways, Way w, Set<Way> newWays, Set<Way> excludeWays) {
        List nodePairs = w.getNodePairs(false);
        int count = 0;
        block0: for (Way anyway : ways) {
            if (anyway == w || newWays.contains(anyway) || excludeWays.contains(anyway)) continue;
            List nodePairs2 = anyway.getNodePairs(false);
            for (Pair p1 : nodePairs) {
                for (Pair p2 : nodePairs2) {
                    if (null == Geometry.getSegmentSegmentIntersection((EastNorth)((Node)p1.a).getEastNorth(), (EastNorth)((Node)p1.b).getEastNorth(), (EastNorth)((Node)p2.a).getEastNorth(), (EastNorth)((Node)p2.b).getEastNorth())) continue;
                    newWays.add(anyway);
                    ++count;
                    continue block0;
                }
            }
        }
        return count;
    }

    static int addWaysIntersectingWay(Collection<Way> ways, Way w, Set<Way> newWays) {
        List nodePairs = w.getNodePairs(false);
        int count = 0;
        block0: for (Way anyway : ways) {
            if (anyway == w || newWays.contains(anyway)) continue;
            List nodePairs2 = anyway.getNodePairs(false);
            for (Pair p1 : nodePairs) {
                for (Pair p2 : nodePairs2) {
                    if (null == Geometry.getSegmentSegmentIntersection((EastNorth)((Node)p1.a).getEastNorth(), (EastNorth)((Node)p1.b).getEastNorth(), (EastNorth)((Node)p2.a).getEastNorth(), (EastNorth)((Node)p2.b).getEastNorth())) continue;
                    newWays.add(anyway);
                    ++count;
                    continue block0;
                }
            }
        }
        return count;
    }

    public static int addWaysIntersectingWays(Collection<Way> allWays, Collection<Way> initWays, Set<Way> newWays) {
        int count = 0;
        for (Way w : initWays) {
            count += NodeWayUtils.addWaysIntersectingWay(allWays, w, newWays);
        }
        return count;
    }

    public static void addWaysConnectedToWays(Collection<Way> ways, Set<Way> newWays) {
        for (Way w : ways) {
            NodeWayUtils.addWaysConnectedToWay(w, newWays);
        }
    }

    public static int addWaysConnectedToNodes(Set<Node> selectedNodes, Set<Way> newWays) {
        int s = newWays.size();
        for (Node node : selectedNodes) {
            NodeWayUtils.addWaysConnectedToNode(node, newWays);
        }
        return newWays.size() - s;
    }

    public static int addNodesConnectedToWays(Set<Way> initWays, Set<Node> newNodes) {
        int s = newNodes.size();
        for (Way w : initWays) {
            newNodes.addAll(w.getNodes());
        }
        return newNodes.size() - s;
    }

    public static void addWaysIntersectingWaysRecursively(Collection<Way> allWays, Collection<Way> initWays, Set<Way> newWays) {
        int c;
        HashSet<Way> foundWays = new HashSet<Way>();
        foundWays.addAll(initWays);
        newWays.addAll(initWays);
        int level = 0;
        do {
            c = 0;
            HashSet<Way> newFoundWays = new HashSet<Way>();
            for (Way w : foundWays) {
                c += NodeWayUtils.addWaysIntersectingWay(allWays, w, newFoundWays, newWays);
            }
            foundWays = newFoundWays;
            newWays.addAll(newFoundWays);
            ++level;
            if (c <= maxWays1) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Too many ways are added: {0}!", (Object[])new Object[]{c}), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
            return;
        } while (c > 0 && level < maxLevel);
    }

    public static void addWaysConnectedToWaysRecursively(Collection<Way> initWays, Set<Way> newWays) {
        int c;
        int level = 0;
        newWays.addAll(initWays);
        do {
            c = 0;
            HashSet<Way> foundWays = new HashSet<Way>();
            foundWays.addAll(newWays);
            for (Way w : foundWays) {
                c += NodeWayUtils.addWaysConnectedToWay(w, newWays);
            }
            ++level;
            if (c <= maxWays) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Too many ways are added: {0}!", (Object[])new Object[]{c}), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
            return;
        } while (c > 0 && level < maxLevel);
    }

    static void addMiddle(Set<Node> selectedNodes, Set<Node> newNodes) {
        Iterator<Node> it = selectedNodes.iterator();
        Node n1 = it.next();
        Node n2 = it.next();
        HashSet ways = new HashSet();
        ways.addAll(OsmPrimitive.getFilteredList((Collection)n1.getReferrers(), Way.class));
        for (Way w : ways) {
            int i;
            if (!w.isUsable() || !w.containsNode(n2) || !w.containsNode(n1)) continue;
            List nodes = w.getNodes();
            int i1 = nodes.indexOf(n1);
            int i2 = nodes.indexOf(n2);
            int n = nodes.size();
            if (i1 > i2) {
                int p = i2;
                i2 = i1;
                i1 = p;
            }
            if (w.isClosed()) {
                if ((i2 - i1) * 2 <= n) {
                    for (i = i1 + 1; i != i2; ++i) {
                        newNodes.add((Node)nodes.get(i));
                    }
                    continue;
                }
                i = i2 + 1;
                while (i != i1) {
                    newNodes.add((Node)nodes.get(i));
                    i = (i + 1) % n;
                }
                continue;
            }
            for (i = i1 + 1; i < i2; ++i) {
                newNodes.add((Node)nodes.get(i));
            }
        }
        if (newNodes.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select two nodes connected by way!", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
        }
    }

    static boolean addAreaBoundary(Way firstWay, Set<Way> newWays, boolean goingLeft) {
        Way w = firstWay;
        Node curNode = w.lastNode();
        Node prevNode = w.getNode(w.getNodes().size() - 2);
        HashSet<Way> newestWays = new HashSet<Way>();
        while (true) {
            EastNorth en = curNode.getEastNorth();
            double startHeading = prevNode.getEastNorth().heading(en);
            double bestAngle = goingLeft ? -100000.0 : 100000.0;
            Node otherEnd = null;
            Way nextWay = null;
            for (OsmPrimitive ref : curNode.getReferrers()) {
                double angle;
                Node endNode;
                Node preLast;
                Node nextNode;
                Way w2;
                if (!(ref instanceof Way) || ref == w || !ref.isSelectable() || (w2 = (Way)ref).getNodesCount() < 2 || w2.isClosed()) continue;
                if (curNode == w2.firstNode()) {
                    nextNode = w2.getNode(1);
                    preLast = w2.getNode(w2.getNodesCount() - 2);
                    endNode = w2.lastNode();
                } else {
                    if (curNode != w2.lastNode()) continue;
                    nextNode = w2.getNode(w2.getNodesCount() - 2);
                    preLast = w2.getNode(1);
                    endNode = w2.firstNode();
                }
                for (angle = startHeading - Math.PI - en.heading(nextNode.getEastNorth()); angle < 0.0; angle += Math.PI * 2) {
                }
                if (!(angle < bestAngle ^ goingLeft)) continue;
                bestAngle = angle;
                otherEnd = endNode;
                prevNode = preLast;
                nextWay = w2;
            }
            if (firstWay == nextWay) {
                if (otherEnd == firstWay.firstNode()) {
                    return false;
                }
                newWays.addAll(newestWays);
                return true;
            }
            if (newestWays.contains(nextWay)) {
                return false;
            }
            if (nextWay == null) break;
            newestWays.add(nextWay);
            curNode = otherEnd;
            w = nextWay;
        }
        return false;
    }

    static void addAllInsideMultipolygon(DataSet data, Relation rel, Set<Way> newWays, Set<Node> newNodes) {
        if (!rel.isMultipolygon()) {
            return;
        }
        BBox box = rel.getBBox();
        LinkedHashSet usedWays = OsmPrimitive.getFilteredSet((Collection)rel.getMemberPrimitives(), Way.class);
        ArrayList<EastNorth> polyPoints = new ArrayList<EastNorth>(10000);
        for (Way way : usedWays) {
            List polyNodes = way.getNodes();
            for (Node n : polyNodes) {
                polyPoints.add(n.getEastNorth());
            }
            polyPoints.add(null);
        }
        List searchNodes = data.searchNodes(box);
        HashSet<Node> newestNodes = new HashSet<Node>();
        HashSet<Way> newestWays = new HashSet<Way>();
        for (Node n : searchNodes) {
            if (!NodeWayUtils.isPointInsidePolygon(n.getEastNorth(), polyPoints)) continue;
            newestNodes.add(n);
        }
        List searchWays = data.searchWays(box);
        for (Way w : searchWays) {
            if (!newestNodes.containsAll(w.getNodes())) continue;
            newestWays.add(w);
        }
        for (Way w : newestWays) {
            newestNodes.removeAll(w.getNodes());
        }
        newNodes.addAll(newestNodes);
        newWays.addAll(newestWays);
    }

    static void addAllInsideWay(DataSet data, Way way, Set<Way> newWays, Set<Node> newNodes) {
        if (!way.isClosed()) {
            return;
        }
        BBox box = way.getBBox();
        List polyNodes = way.getNodes();
        ArrayList<EastNorth> polyPoints = new ArrayList<EastNorth>(polyNodes.size() + 5);
        for (Node n : polyNodes) {
            polyPoints.add(n.getEastNorth());
        }
        List searchNodes = data.searchNodes(box);
        HashSet<Node> newestNodes = new HashSet<Node>();
        HashSet<Way> newestWays = new HashSet<Way>();
        for (Node n : searchNodes) {
            if (!NodeWayUtils.isPointInsidePolygon(n.getEastNorth(), polyPoints)) continue;
            newestNodes.add(n);
        }
        List searchWays = data.searchWays(box);
        for (Way w : searchWays) {
            if (!newestNodes.containsAll(w.getNodes())) continue;
            newestWays.add(w);
        }
        for (Way w : newestWays) {
            newestNodes.removeAll(w.getNodes());
        }
        newNodes.addAll(newestNodes);
        newWays.addAll(newestWays);
    }

    public static boolean isPointInsidePolygon(EastNorth point, List<EastNorth> polygonPoints) {
        int n = NodeWayUtils.getRayIntersectionsCount(point, polygonPoints);
        if (n < 0) {
            return true;
        }
        return n % 2 == 1;
    }

    public static int getRayIntersectionsCount(EastNorth point, List<EastNorth> polygonPoints) {
        if (point == null) {
            return 0;
        }
        EastNorth oldPoint = null;
        int interCount = 0;
        for (EastNorth curPoint : polygonPoints) {
            double d;
            if (oldPoint == null || curPoint == null) {
                oldPoint = curPoint;
                continue;
            }
            double n1 = curPoint.north();
            double n2 = oldPoint.north();
            double n3 = point.north();
            double e1 = curPoint.east();
            double e2 = oldPoint.east();
            double e3 = point.east();
            if (Math.abs(n1 - n3) < 1.0E-5 && Math.abs(e1 - e3) < 1.0E-5) {
                return -3;
            }
            if (Math.abs(n2 - n3) < 1.0E-5 && Math.abs(e2 - e3) < 1.0E-5) {
                return -3;
            }
            if (n1 > n2) {
                if (n1 > n3 && n3 >= n2) {
                    d = (e1 -= e3) * (n2 -= n3) - (n1 -= n3) * (e2 -= e3);
                    if (d < -1.0E-5) {
                        ++interCount;
                    } else if (d <= 1.0E-5) {
                        return -2;
                    }
                }
            } else if (n1 == n2) {
                if (n1 == n3) {
                    e1 -= e3;
                    e2 -= e3;
                    if (e1 <= 0.0 && e2 >= 0.0 || e1 >= 0.0 && e2 <= 0.0) {
                        return -2;
                    }
                }
            } else if (n1 <= n3 && n3 < n2) {
                d = (e1 -= e3) * (n2 -= n3) - (n1 -= n3) * (e2 -= e3);
                if (d > 1.0E-5) {
                    ++interCount;
                } else if (d >= -1.0E-5) {
                    return -2;
                }
            }
            oldPoint = curPoint;
        }
        return interCount;
    }

    public static Collection<OsmPrimitive> selectAllInside(Collection<OsmPrimitive> selected, DataSet dataset) {
        LinkedHashSet selectedWays = OsmPrimitive.getFilteredSet(selected, Way.class);
        LinkedHashSet selectedRels = OsmPrimitive.getFilteredSet(selected, Relation.class);
        Iterator it = selectedRels.iterator();
        while (it.hasNext()) {
            Relation r = (Relation)it.next();
            if (r.isMultipolygon()) continue;
            it.remove();
        }
        HashSet<Way> newWays = new HashSet<Way>();
        HashSet<Node> newNodes = new HashSet<Node>();
        if (!selectedWays.isEmpty()) {
            for (Way w : selectedWays) {
                NodeWayUtils.addAllInsideWay(dataset, w, newWays, newNodes);
            }
        }
        if (!selectedRels.isEmpty()) {
            for (Relation r : selectedRels) {
                NodeWayUtils.addAllInsideMultipolygon(dataset, r, newWays, newNodes);
            }
        }
        HashSet<OsmPrimitive> insideSelection = new HashSet<OsmPrimitive>();
        if (!newWays.isEmpty() || !newNodes.isEmpty()) {
            insideSelection.addAll(newWays);
            insideSelection.addAll(newNodes);
        }
        return insideSelection;
    }
}

