/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

final class DataSetCommandMerger {
    private final ConflictCollection conflicts = new ConflictCollection();
    private final DataSet sourceDataSet;
    private final DataSet targetDataSet;
    private final List<Command> cmds = new LinkedList<Command>();
    private final List<OsmPrimitive> undeletedPrimitives = new LinkedList<OsmPrimitive>();

    public DataSetCommandMerger(DataSet sourceDataSet, DataSet targetDataSet) {
        this.sourceDataSet = sourceDataSet;
        this.targetDataSet = targetDataSet;
        this.merge();
    }

    private void addChangeCommandIfNotEquals(OsmPrimitive target, OsmPrimitive newTarget) {
        if (!target.hasEqualSemanticAttributes(newTarget)) {
            this.cmds.add((Command)new ChangeCommand(target, newTarget));
            this.undeletedPrimitives.add(target);
        }
    }

    private OsmPrimitive getMergeTarget(OsmPrimitive mergeSource) {
        OsmPrimitive p = this.targetDataSet.getPrimitiveById(mergeSource.getId(), mergeSource.getType());
        if (p == null) {
            throw new IllegalStateException(I18n.tr((String)"Missing merge target of type {0} with id {1}", (Object[])new Object[]{mergeSource.getType(), mergeSource.getUniqueId()}));
        }
        return p;
    }

    private void mergePrimitive(OsmPrimitive source, OsmPrimitive target, OsmPrimitive newTarget) {
        newTarget.mergeFrom(source);
        newTarget.setOsmId(target.getId(), target.getVersion());
        newTarget.setVisible(target.isVisible());
        newTarget.setDeleted(false);
    }

    private void mergeNode(Node source) {
        if (source.isIncomplete()) {
            return;
        }
        if (!source.isVisible()) {
            return;
        }
        Node target = (Node)this.getMergeTarget((OsmPrimitive)source);
        Node newTarget = new Node(target);
        this.mergePrimitive((OsmPrimitive)source, (OsmPrimitive)target, (OsmPrimitive)newTarget);
        this.addChangeCommandIfNotEquals((OsmPrimitive)target, (OsmPrimitive)newTarget);
    }

    private void mergeWay(Way source) throws IllegalStateException {
        if (source.isIncomplete()) {
            return;
        }
        if (!source.isVisible()) {
            return;
        }
        Way target = (Way)this.getMergeTarget((OsmPrimitive)source);
        ArrayList<Node> newNodes = new ArrayList<Node>(source.getNodesCount());
        for (Node sourceNode : source.getNodes()) {
            Node targetNode = (Node)this.getMergeTarget((OsmPrimitive)sourceNode);
            if (!targetNode.isDeleted() || this.undeletedPrimitives.contains(targetNode)) {
                newNodes.add(targetNode);
                continue;
            }
            if (!sourceNode.isIncomplete() || this.conflicts.hasConflictForMy((OsmPrimitive)targetNode)) continue;
            this.conflicts.add(new Conflict((OsmPrimitive)targetNode, (OsmPrimitive)sourceNode, true));
            Node undeletedTargetNode = new Node(targetNode);
            undeletedTargetNode.setDeleted(false);
            this.addChangeCommandIfNotEquals((OsmPrimitive)targetNode, (OsmPrimitive)undeletedTargetNode);
        }
        Way newTarget = new Way(target);
        this.mergePrimitive((OsmPrimitive)source, (OsmPrimitive)target, (OsmPrimitive)newTarget);
        newTarget.setNodes(newNodes);
        this.addChangeCommandIfNotEquals((OsmPrimitive)target, (OsmPrimitive)newTarget);
    }

    private void mergeRelation(Relation source) throws IllegalStateException {
        if (source.isIncomplete()) {
            return;
        }
        if (!source.isVisible()) {
            return;
        }
        Relation target = (Relation)this.getMergeTarget((OsmPrimitive)source);
        LinkedList<RelationMember> newMembers = new LinkedList<RelationMember>();
        for (RelationMember sourceMember : source.getMembers()) {
            OsmPrimitive targetMember = this.getMergeTarget(sourceMember.getMember());
            if (targetMember.isDeleted() && sourceMember.getMember().isIncomplete() && !this.conflicts.hasConflictForMy(targetMember)) {
                Node undeletedTargetMember;
                this.conflicts.add(new Conflict(targetMember, sourceMember.getMember(), true));
                switch (targetMember.getType()) {
                    case NODE: {
                        undeletedTargetMember = new Node((Node)targetMember);
                        break;
                    }
                    case WAY: {
                        undeletedTargetMember = new Way((Way)targetMember);
                        break;
                    }
                    case RELATION: {
                        undeletedTargetMember = new Relation((Relation)targetMember);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                undeletedTargetMember.setDeleted(false);
                this.addChangeCommandIfNotEquals(targetMember, (OsmPrimitive)undeletedTargetMember);
            }
            newMembers.add(new RelationMember(sourceMember.getRole(), targetMember));
        }
        Relation newRelation = new Relation(target);
        this.mergePrimitive((OsmPrimitive)source, (OsmPrimitive)target, (OsmPrimitive)newRelation);
        newRelation.setMembers(newMembers);
        this.addChangeCommandIfNotEquals((OsmPrimitive)target, (OsmPrimitive)newRelation);
    }

    private void merge() {
        for (Node node : this.sourceDataSet.getNodes()) {
            this.mergeNode(node);
        }
        for (Way way : this.sourceDataSet.getWays()) {
            this.mergeWay(way);
        }
        for (Relation relation : this.sourceDataSet.getRelations()) {
            this.mergeRelation(relation);
        }
    }

    public List<Command> getCommandList() {
        return this.cmds;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }
}

