/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.tests;

import java.awt.Color;
import java.util.List;
import junit.framework.TestCase;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.elevation.ColorMap;
import org.openstreetmap.josm.plugins.elevation.EleCoordinate;
import org.openstreetmap.josm.plugins.elevation.EleVertex;
import org.openstreetmap.josm.plugins.elevation.GridRenderer;

public class EleVertexTest
extends TestCase {
    public void setUp() {
        Main.pref = new Preferences();
    }

    public void testDivide() {
        EleCoordinate p1 = new EleCoordinate(30.0, 30.0, 100.0);
        EleCoordinate p2 = new EleCoordinate(35.0, 30.0, 120.0);
        EleCoordinate p3 = new EleCoordinate(35.0, 40.0, 110.0);
        EleVertex ev = new EleVertex(p1, p2, p3);
        List<EleVertex> list = ev.divide();
        EleVertexTest.assertEquals((int)2, (int)list.size());
        EleVertex v1 = list.get(0);
        EleVertexTest.assertEquals((Object)108.33333333333333, (Object)v1.getEle());
        this.assertCoorEq(v1, 30.0, 30.0, 0);
        this.assertCoorEq(v1, 30.0, 35.0, 1);
        this.assertCoorEq(v1, 35.0, 32.5, 2);
        EleVertex v2 = list.get(1);
        EleVertexTest.assertEquals((Object)111.66666666666667, (Object)v2.getEle());
        this.assertCoorEq(v2, 40.0, 35.0, 0);
        this.assertCoorEq(v2, 30.0, 35.0, 1);
        this.assertCoorEq(v2, 35.0, 32.5, 2);
    }

    public void testSimpleRecurse() {
        EleCoordinate c1 = new EleCoordinate(new LatLon(50.8328, 8.1337), 300.0);
        EleCoordinate c2 = new EleCoordinate(new LatLon(50.8328, 7.9217), 200.0);
        EleCoordinate c3 = new EleCoordinate(new LatLon(50.9558, 7.9217), 400.0);
        EleCoordinate c4 = new EleCoordinate(new LatLon(50.5767627, 9.1938483), 100.0);
        EleVertex v1 = new EleVertex(c1, c2, c3);
        System.out.println("Start recurse");
        this.recurse(v1, 0);
    }

    private void recurse(EleVertex v, int depth) {
        if (!v.isFinished() && depth < 100) {
            System.out.println("\tDivide: " + v);
            List<EleVertex> list = v.divide();
            EleVertexTest.assertNotNull(list);
            EleVertexTest.assertEquals((int)2, (int)list.size());
            EleVertexTest.assertTrue((depth < 50 ? 1 : 0) != 0);
            for (EleVertex eleVertex : list) {
                EleVertexTest.assertTrue((String)("Area is larger " + v.getArea() + " > " + eleVertex.getArea()), (eleVertex.getArea() < v.getArea() ? 1 : 0) != 0);
                this.recurse(eleVertex, depth + 1);
            }
        } else {
            System.out.println("Finished: " + depth);
        }
    }

    public void testRenderer() {
        GridRenderer er = new GridRenderer("Ele", new Bounds(new LatLon(50.6607106, 8.7337029), new LatLon(50.5767627, 9.1938483)), null);
        er.run();
    }

    public void testColorMap() {
        int[] nArray = new int[2];
        nArray[1] = 1000;
        ColorMap testMap = ColorMap.create("Test", new Color[]{Color.white, Color.black}, nArray);
        Color c1 = testMap.getColor(-100);
        EleVertexTest.assertEquals((Object)Color.white, (Object)c1);
        Color c2 = testMap.getColor(1100);
        EleVertexTest.assertEquals((Object)Color.black, (Object)c2);
        Color c3 = testMap.getColor(500);
        EleVertexTest.assertEquals((Object)Color.gray, (Object)c3);
        Color c4 = testMap.getColor(751);
        EleVertexTest.assertEquals((Object)Color.lightGray, (Object)c4);
        Color c5 = testMap.getColor(251);
        EleVertexTest.assertEquals((Object)Color.darkGray, (Object)c5);
    }

    private void assertCoorEq(EleVertex v1, double x, double y, int n) {
        EleVertexTest.assertEquals((Object)x, (Object)v1.get(n).getX());
        EleVertexTest.assertEquals((Object)y, (Object)v1.get(n).getY());
    }
}

