/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.awt.Component;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.elevation.EleCoordinate;
import org.openstreetmap.josm.plugins.elevation.EleVertex;
import org.openstreetmap.josm.plugins.elevation.ElevationHelper;
import org.openstreetmap.josm.plugins.elevation.IEleRenderingListener;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class GridRenderer
extends PleaseWaitRunnable {
    private Bounds box;
    private IEleRenderingListener listener;
    private BlockingDeque<EleVertex> toDo = new LinkedBlockingDeque<EleVertex>();
    private BlockingDeque<EleVertex> vertices = new LinkedBlockingDeque<EleVertex>();
    private volatile boolean stop = false;

    public GridRenderer(String title, Bounds box, IEleRenderingListener listener) {
        this(title, NullProgressMonitor.INSTANCE, true, box, listener);
    }

    public GridRenderer(String title, boolean ignoreException, Bounds box, IEleRenderingListener listener) {
        this(title, NullProgressMonitor.INSTANCE, ignoreException, box, listener);
    }

    public GridRenderer(Component parent, String title, boolean ignoreException, Bounds box) throws IllegalArgumentException {
        super(parent, title, ignoreException);
        this.box = box;
        this.initQueue();
    }

    public GridRenderer(String title, ProgressMonitor progressMonitor, boolean ignoreException, Bounds box, IEleRenderingListener listener) {
        super(title, progressMonitor, ignoreException);
        this.box = box;
        this.listener = listener;
        this.initQueue();
    }

    private void initQueue() {
        LatLon min = this.box.getMin();
        LatLon max = this.box.getMax();
        LatLon h1 = new LatLon(min.lat(), max.lon());
        LatLon h2 = new LatLon(max.lat(), min.lon());
        EleCoordinate p0 = new EleCoordinate(min, ElevationHelper.getElevation(min));
        EleCoordinate p1 = new EleCoordinate(h1, ElevationHelper.getElevation(h1));
        EleCoordinate p2 = new EleCoordinate(max, ElevationHelper.getElevation(max));
        EleCoordinate p3 = new EleCoordinate(h2, ElevationHelper.getElevation(h2));
        EleVertex v1 = new EleVertex(p0, p1, p2);
        EleVertex v2 = new EleVertex(p2, p3, p0);
        this.toDo.add(v1);
        this.toDo.add(v2);
        System.out.println("Inited queue");
    }

    public BlockingDeque<EleVertex> getVertices() {
        return this.vertices;
    }

    protected void cancel() {
        this.stop = true;
    }

    protected void realRun() throws SAXException, IOException, OsmTransferException {
        if (this.stop) {
            return;
        }
        super.getProgressMonitor().indeterminateSubTask(I18n.tr((String)"Render vertices...", (Object[])new Object[0]));
        System.out.println("Queue size " + this.toDo.size());
        while (this.toDo.size() > 0) {
            if (this.stop) break;
            EleVertex vertex = this.toDo.poll();
            if (vertex.isFinished()) {
                this.vertices.add(vertex);
                if (this.listener == null) continue;
                this.listener.finished(vertex);
                continue;
            }
            List<EleVertex> newV = vertex.divide();
            for (EleVertex eleVertex : newV) {
                System.out.print(".");
                this.toDo.add(eleVertex);
            }
        }
        if (this.listener != null) {
            this.listener.finishedAll();
        }
    }

    protected void finish() {
    }
}

