/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.gui;

import java.awt.GridLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.elevation.ElevationHelper;
import org.openstreetmap.josm.plugins.elevation.IElevationModelListener;
import org.openstreetmap.josm.plugins.elevation.gpx.ElevationModel;
import org.openstreetmap.josm.plugins.elevation.gpx.IElevationModel;
import org.openstreetmap.josm.plugins.elevation.gpx.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.gui.ElevationProfileLayer;
import org.openstreetmap.josm.plugins.elevation.gui.ElevationProfilePanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ElevationProfileDialog
extends ToggleDialog
implements MapView.LayerChangeListener,
ComponentListener {
    private static final String EMPTY_DATA_STRING = "-";
    private static final long serialVersionUID = -868463893732535577L;
    private IElevationModel model;
    private GpxLayer activeLayer = null;
    private HashMap<GpxLayer, ElevationModel> layerMap = new HashMap();
    private ElevationProfilePanel profPanel;
    private JLabel minHeightLabel;
    private JLabel maxHeightLabel;
    private JLabel avrgHeightLabel;
    private JLabel elevationGainLabel;
    private JLabel totalTimeLabel;
    private JLabel distLabel;
    private List<IElevationModelListener> listeners = new ArrayList<IElevationModelListener>();
    private ElevationProfileLayer profileLayer;

    public ElevationProfileDialog() {
        this(I18n.tr((String)"Elevation Profile", (Object[])new Object[0]), "elevation", I18n.tr((String)"Open the elevation profile window.", (Object[])new Object[0]), null, 200, true);
    }

    public ElevationProfileDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight) {
        this(name, iconName, tooltip, shortcut, preferredHeight, false);
    }

    public ElevationProfileDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight, boolean defShow) {
        super(name, iconName, tooltip, shortcut, preferredHeight, defShow);
        JPanel dataPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(2, 6);
        dataPanel.setLayout(gridLayout);
        JLabel lbl = new JLabel(I18n.tr((String)"Min", (Object[])new Object[0]));
        lbl.setFont(this.getFont().deriveFont(1));
        dataPanel.add(lbl);
        lbl = new JLabel(I18n.tr((String)"Avrg", (Object[])new Object[0]));
        lbl.setFont(this.getFont().deriveFont(1));
        dataPanel.add(lbl);
        lbl = new JLabel(I18n.tr((String)"Max", (Object[])new Object[0]));
        lbl.setFont(this.getFont().deriveFont(1));
        dataPanel.add(lbl);
        lbl = new JLabel(I18n.tr((String)"Dist", (Object[])new Object[0]));
        lbl.setFont(this.getFont().deriveFont(1));
        dataPanel.add(lbl);
        lbl = new JLabel(I18n.tr((String)"Gain", (Object[])new Object[0]));
        lbl.setFont(this.getFont().deriveFont(1));
        dataPanel.add(lbl);
        lbl = new JLabel(I18n.tr((String)"Time", (Object[])new Object[0]));
        lbl.setFont(this.getFont().deriveFont(1));
        dataPanel.add(lbl);
        this.minHeightLabel = new JLabel("0 m");
        dataPanel.add(this.minHeightLabel);
        this.avrgHeightLabel = new JLabel("0 m");
        dataPanel.add(this.avrgHeightLabel);
        this.maxHeightLabel = new JLabel("0 m");
        dataPanel.add(this.maxHeightLabel);
        this.distLabel = new JLabel("0 km");
        dataPanel.add(this.distLabel);
        this.elevationGainLabel = new JLabel("0 m");
        dataPanel.add(this.elevationGainLabel);
        this.totalTimeLabel = new JLabel("0");
        dataPanel.add(this.totalTimeLabel);
        this.add(dataPanel, "Last");
        this.model = new ElevationModel();
        this.profPanel = new ElevationProfilePanel(null);
        this.add(this.profPanel, "Center");
        this.profPanel.addComponentListener(this);
        this.dock();
    }

    public void showNotify() {
        Layer layer;
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
        if (Main.isDisplayingMapView() && (layer = Main.map.mapView.getActiveLayer()) instanceof GpxLayer) {
            this.setActiveLayer((GpxLayer)layer);
        }
    }

    public void hideNotify() {
        MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
    }

    public IElevationModel getModel() {
        return this.model;
    }

    public void setModel(IElevationModel model) {
        if (this.model != model) {
            this.model = model;
            this.profPanel.setElevationModel(model);
            this.updateView();
        }
    }

    public ElevationProfileLayer getProfileLayer() {
        return this.profileLayer;
    }

    public void setProfileLayer(ElevationProfileLayer profileLayer) {
        if (this.profileLayer != profileLayer) {
            if (this.profileLayer != null) {
                this.profPanel.removeSelectionListener(this.profileLayer);
            }
            this.profileLayer = profileLayer;
            this.profPanel.addSelectionListener(this.profileLayer);
        }
    }

    private void updateView() {
        if (this.model == null) {
            return;
        }
        IElevationProfile profile = this.model.getCurrentProfile();
        if (profile != null) {
            this.setTitle(String.format("%s: %s", I18n.tr((String)"Elevation Profile", (Object[])new Object[0]), profile.getName()));
            if (profile.hasElevationData()) {
                this.minHeightLabel.setText(ElevationHelper.getElevationText(profile.getMinHeight()));
                this.maxHeightLabel.setText(ElevationHelper.getElevationText(profile.getMaxHeight()));
                this.avrgHeightLabel.setText(ElevationHelper.getElevationText(profile.getAverageHeight()));
                this.elevationGainLabel.setText(ElevationHelper.getElevationText(profile.getGain()));
            }
            long diff = profile.getTimeDifference();
            long minutes = diff / 60000L;
            long hours = minutes / 60L;
            double dist = profile.getDistance();
            this.totalTimeLabel.setText(String.format("%d:%d h", hours, minutes %= 60L));
            this.distLabel.setText(NavigatableComponent.getSystemOfMeasurement().getDistText(dist));
        } else {
            this.setTitle(String.format("%s: (No data)", I18n.tr((String)"Elevation Profile", (Object[])new Object[0])));
            this.minHeightLabel.setText(EMPTY_DATA_STRING);
            this.maxHeightLabel.setText(EMPTY_DATA_STRING);
            this.avrgHeightLabel.setText(EMPTY_DATA_STRING);
            this.elevationGainLabel.setText(EMPTY_DATA_STRING);
            this.totalTimeLabel.setText(EMPTY_DATA_STRING);
            this.distLabel.setText(EMPTY_DATA_STRING);
        }
        this.fireModelChanged();
        this.repaint();
    }

    protected void fireModelChanged() {
        for (IElevationModelListener listener : this.listeners) {
            listener.elevationProfileChanged(this.getModel().getCurrentProfile());
        }
    }

    public void addModelListener(IElevationModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelListener(IElevationModelListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer instanceof GpxLayer) {
            this.setActiveLayer((GpxLayer)newLayer);
        }
    }

    private void setActiveLayer(GpxLayer newLayer) {
        if (this.activeLayer != newLayer) {
            this.activeLayer = newLayer;
            if (!this.layerMap.containsKey(newLayer)) {
                GpxData gpxData = newLayer.data;
                ElevationModel newEM = new ElevationModel(newLayer.getName(), gpxData);
                this.layerMap.put(newLayer, newEM);
            }
            ElevationModel em = this.layerMap.get(newLayer);
            this.setModel(em);
        }
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof GpxLayer) {
            GpxLayer gpxLayer = (GpxLayer)newLayer;
            this.setActiveLayer(gpxLayer);
        }
    }

    public void layerRemoved(Layer oldLayer) {
        if (this.layerMap.containsKey(oldLayer)) {
            this.layerMap.remove(oldLayer);
        }
        if (this.layerMap.size() == 0) {
            this.setModel(null);
            if (this.profileLayer != null) {
                this.profileLayer.setProfile(null);
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

