/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.gpx;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.elevation.IElevationModelListener;
import org.openstreetmap.josm.plugins.elevation.gpx.ElevationProfileBase;
import org.openstreetmap.josm.plugins.elevation.gpx.GpxIterator;
import org.openstreetmap.josm.plugins.elevation.gpx.IElevationModel;
import org.openstreetmap.josm.plugins.elevation.gpx.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.gpx.IGpxVisitor;
import org.openstreetmap.josm.plugins.elevation.gpx.WayPointMap;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class ElevationModel
implements IGpxVisitor,
IElevationModel {
    private int trackCounter;
    private GpxData gpxData;
    private WayPointMap children = new WayPointMap();
    private List<IElevationModelListener> listeners = new ArrayList<IElevationModelListener>();
    private List<WayPoint> buffer = new ArrayList<WayPoint>();
    private int currentProfileIndex = 0;

    public ElevationModel() {
        this("", null);
    }

    public ElevationModel(String name, GpxData data) {
        this.gpxData = data;
        GpxIterator.visit(data, (IGpxVisitor)this);
    }

    public GpxData getGpxData() {
        return this.gpxData;
    }

    protected WayPointMap getTracks() {
        return this.children;
    }

    protected void fireModelChanged() {
        for (IElevationModelListener listener : this.listeners) {
            if (this.children == null || this.children.size() <= 0) continue;
            listener.elevationProfileChanged(this.getCurrentProfile());
        }
    }

    @Override
    public void addModelListener(IElevationModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeModelListener(IElevationModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void visit(GpxRoute route, WayPoint wp) {
        this.processWayPoint(wp);
    }

    public void visit(GpxTrack track, GpxTrackSegment segment, WayPoint wp) {
        this.processWayPoint(wp);
    }

    @Override
    public void visit(WayPoint wp) {
        this.processWayPoint(wp);
    }

    @Override
    public void start() {
        this.children.clear();
    }

    @Override
    public void end() {
        String trackName = "Track#" + this.trackCounter;
        this.addTrackOrRoute(trackName);
    }

    private void addTrackOrRoute(String trackName) {
        if (this.buffer.size() > 0) {
            System.out.println("Add track " + trackName + ", n =  " + this.buffer.size());
            ElevationProfileBase ep = new ElevationProfileBase(trackName);
            ep.setWayPoints(this.buffer);
            ep.setName(trackName);
            this.children.add(ep);
            this.buffer.clear();
        }
    }

    private void processWayPoint(WayPoint wp) {
        if (wp == null) {
            throw new RuntimeException("WPT must not be null!");
        }
        this.buffer.add(wp);
    }

    @Override
    public List<IElevationProfile> getProfiles() {
        return this.children;
    }

    @Override
    public IElevationProfile getCurrentProfile() {
        if (this.currentProfileIndex < 0 || this.currentProfileIndex >= this.profileCount()) {
            return null;
        }
        return (IElevationProfile)this.children.get(this.currentProfileIndex);
    }

    @Override
    public void setCurrentProfile(IElevationProfile newProfile) {
        CheckParameterUtil.ensureParameterNotNull((Object)newProfile);
        if (!this.children.contains(newProfile)) {
            this.children.add(newProfile);
        }
        this.setCurrentProfile(this.children.indexOf(newProfile));
    }

    @Override
    public void setCurrentProfile(int index) {
        if (index < 0 || index >= this.profileCount()) {
            throw new RuntimeException("Invalid arg for setCurrentProfile: " + index + ", value must be 0.." + this.profileCount());
        }
        this.currentProfileIndex = index;
        this.fireModelChanged();
    }

    @Override
    public int profileCount() {
        return this.children != null ? this.children.size() : 0;
    }
}

