/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.awt.Graphics2D;
import java.awt.Point;
import java.util.concurrent.BlockingDeque;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.elevation.EleVertex;
import org.openstreetmap.josm.plugins.elevation.GridRenderer;
import org.openstreetmap.josm.plugins.elevation.IEleRenderingListener;
import org.openstreetmap.josm.plugins.elevation.IVertexRenderer;
import org.openstreetmap.josm.plugins.elevation.SimpleVertexRenderer;
import org.openstreetmap.josm.plugins.elevation.gui.Triangle;
import org.openstreetmap.josm.tools.ImageProvider;

public class ColoredElevationLayer
extends Layer
implements IEleRenderingListener {
    private GridRenderer gridRenderer;
    private IVertexRenderer vertexRenderer;

    public ColoredElevationLayer(String name) {
        super(name);
        this.setOpacity(0.8);
        this.vertexRenderer = new SimpleVertexRenderer();
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        if (this.gridRenderer == null) {
            this.gridRenderer = new GridRenderer(this.getName(), box, this);
            System.out.println("Start renderer...");
            Main.worker.submit((Runnable)((Object)this.gridRenderer));
        }
        if (this.gridRenderer.getVertices().size() > 0) {
            BlockingDeque<EleVertex> list = this.gridRenderer.getVertices();
            for (EleVertex eleVertex : list) {
                Point p0 = mv.getPoint((LatLon)eleVertex.get(0));
                Point p1 = mv.getPoint((LatLon)eleVertex.get(1));
                Point p2 = mv.getPoint((LatLon)eleVertex.get(2));
                Triangle t = new Triangle(p0, p1, p2);
                g.setColor(this.vertexRenderer.getElevationColor(eleVertex));
                g.fill(t);
            }
        }
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"elevation_small");
    }

    public String getToolTipText() {
        return null;
    }

    public void mergeFrom(Layer from) {
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return null;
    }

    public Action[] getMenuEntries() {
        return new Action[]{new LayerListPopup.InfoAction((Layer)this)};
    }

    @Override
    public void finished(EleVertex vertex) {
    }

    @Override
    public void finishedAll() {
        Main.map.mapView.repaint();
    }

    public IVertexRenderer getVertexRenderer() {
        return this.vertexRenderer;
    }

    public void setVertexRenderer(IVertexRenderer vertexRenderer) {
        this.vertexRenderer = vertexRenderer;
    }
}

