/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.LongMap;

public class LongConcurrentLRUMap<V>
extends LongMap<V> {
    private static Logger log = Logger.getLogger(LongConcurrentLRUMap.class.getName());
    private final LongConcurrentHashMap<CacheEntry<V>> map;
    private final int upperWaterMark;
    private final int lowerWaterMark;
    private final ReentrantLock markAndSweepLock = new ReentrantLock(true);
    private boolean isCleaning = false;
    private final boolean newThreadForCleanup;
    private volatile boolean islive = true;
    private final Stats stats = new Stats();
    private final int acceptableWaterMark;
    private long oldestEntry = 0L;
    private CleanupThread cleanupThread;
    private boolean isDestroyed = false;

    public LongConcurrentLRUMap(int upperWaterMark, int lowerWaterMark, int acceptableWatermark, int initialSize, boolean runCleanupThread, boolean runNewThreadForCleanup) {
        if (upperWaterMark < 1) {
            throw new IllegalArgumentException("upperWaterMark must be > 0");
        }
        if (lowerWaterMark >= upperWaterMark) {
            throw new IllegalArgumentException("lowerWaterMark must be  < upperWaterMark");
        }
        this.map = new LongConcurrentHashMap(initialSize);
        this.newThreadForCleanup = runNewThreadForCleanup;
        this.upperWaterMark = upperWaterMark;
        this.lowerWaterMark = lowerWaterMark;
        this.acceptableWaterMark = acceptableWatermark;
        if (runCleanupThread) {
            this.cleanupThread = new CleanupThread(this);
            this.cleanupThread.start();
        }
    }

    public LongConcurrentLRUMap(int size, int lowerWatermark) {
        this(size, lowerWatermark, (int)Math.floor((lowerWatermark + size) / 2), (int)Math.ceil(0.75 * (double)size), false, false);
    }

    public void setAlive(boolean live) {
        this.islive = live;
    }

    @Override
    public V get(long key) {
        CacheEntry<V> e = this.map.get(key);
        if (e == null) {
            if (this.islive) {
                this.stats.missCounter.incrementAndGet();
            }
            return null;
        }
        if (this.islive) {
            e.lastAccessed = this.stats.accessCounter.incrementAndGet();
        }
        return e.value;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public V remove(long key) {
        CacheEntry<V> cacheEntry = this.map.remove(key);
        if (cacheEntry != null) {
            this.stats.size.decrementAndGet();
            return cacheEntry.value;
        }
        return null;
    }

    @Override
    public V put(long key, V val) {
        if (val == null) {
            return null;
        }
        CacheEntry<V> e = new CacheEntry<V>(key, val, this.stats.accessCounter.incrementAndGet());
        CacheEntry<V> oldCacheEntry = this.map.put(key, e);
        int currentSize = oldCacheEntry == null ? this.stats.size.incrementAndGet() : this.stats.size.get();
        if (this.islive) {
            this.stats.putCounter.incrementAndGet();
        } else {
            this.stats.nonLivePutCounter.incrementAndGet();
        }
        if (currentSize > this.upperWaterMark && !this.isCleaning) {
            if (this.newThreadForCleanup) {
                new Thread(){

                    @Override
                    public void run() {
                        LongConcurrentLRUMap.this.markAndSweep();
                    }
                }.start();
            } else if (this.cleanupThread != null) {
                this.cleanupThread.wakeThread();
            } else {
                this.markAndSweep();
            }
        }
        return oldCacheEntry == null ? null : (V)oldCacheEntry.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAndSweep() {
        if (!this.markAndSweepLock.tryLock()) {
            return;
        }
        try {
            long oldestEntry = this.oldestEntry;
            this.isCleaning = true;
            this.oldestEntry = oldestEntry;
            long timeCurrent = this.stats.accessCounter.get();
            int sz = this.stats.size.get();
            int numRemoved = 0;
            int numKept = 0;
            long newestEntry = timeCurrent;
            long newNewestEntry = -1L;
            long newOldestEntry = Long.MAX_VALUE;
            int wantToKeep = this.lowerWaterMark;
            int wantToRemove = sz - this.lowerWaterMark;
            CacheEntry[] eset = new CacheEntry[sz];
            int eSize = 0;
            Iterator<CacheEntry<V>> iter = this.map.valuesIterator();
            while (iter.hasNext()) {
                CacheEntry<V> ce = iter.next();
                ce.lastAccessedCopy = ce.lastAccessed;
                long thisEntry = ce.lastAccessedCopy;
                if (thisEntry > newestEntry - (long)wantToKeep) {
                    ++numKept;
                    newOldestEntry = Math.min(thisEntry, newOldestEntry);
                    continue;
                }
                if (thisEntry < oldestEntry + (long)wantToRemove) {
                    this.evictEntry(ce.key);
                    ++numRemoved;
                    continue;
                }
                if (eSize >= eset.length - 1) continue;
                eset[eSize++] = ce;
                newNewestEntry = Math.max(thisEntry, newNewestEntry);
                newOldestEntry = Math.min(thisEntry, newOldestEntry);
            }
            int numPasses = 1;
            while (sz - numRemoved > this.acceptableWaterMark && --numPasses >= 0) {
                oldestEntry = newOldestEntry == Long.MAX_VALUE ? oldestEntry : newOldestEntry;
                newOldestEntry = Long.MAX_VALUE;
                newestEntry = newNewestEntry;
                newNewestEntry = -1L;
                wantToKeep = this.lowerWaterMark - numKept;
                wantToRemove = sz - this.lowerWaterMark - numRemoved;
                for (int i = eSize - 1; i >= 0; --i) {
                    CacheEntry ce = eset[i];
                    long thisEntry = ce.lastAccessedCopy;
                    if (thisEntry > newestEntry - (long)wantToKeep) {
                        ++numKept;
                        eset[i] = eset[eSize - 1];
                        --eSize;
                        newOldestEntry = Math.min(thisEntry, newOldestEntry);
                        continue;
                    }
                    if (thisEntry < oldestEntry + (long)wantToRemove) {
                        this.evictEntry(ce.key);
                        ++numRemoved;
                        eset[i] = eset[eSize - 1];
                        --eSize;
                        continue;
                    }
                    newNewestEntry = Math.max(thisEntry, newNewestEntry);
                    newOldestEntry = Math.min(thisEntry, newOldestEntry);
                }
            }
            if (sz - numRemoved > this.acceptableWaterMark) {
                oldestEntry = newOldestEntry == Long.MAX_VALUE ? oldestEntry : newOldestEntry;
                newOldestEntry = Long.MAX_VALUE;
                newestEntry = newNewestEntry;
                newNewestEntry = -1L;
                wantToKeep = this.lowerWaterMark - numKept;
                wantToRemove = sz - this.lowerWaterMark - numRemoved;
                PQueue queue = new PQueue(wantToRemove);
                for (int i = eSize - 1; i >= 0; --i) {
                    CacheEntry ce = eset[i];
                    long thisEntry = ce.lastAccessedCopy;
                    if (thisEntry > newestEntry - (long)wantToKeep) {
                        ++numKept;
                        newOldestEntry = Math.min(thisEntry, newOldestEntry);
                        continue;
                    }
                    if (thisEntry < oldestEntry + (long)wantToRemove) {
                        this.evictEntry(ce.key);
                        ++numRemoved;
                        continue;
                    }
                    queue.myMaxSize = sz - this.lowerWaterMark - numRemoved;
                    while (queue.size() > queue.myMaxSize && queue.size() > 0) {
                        CacheEntry otherEntry = (CacheEntry)queue.pop();
                        newOldestEntry = Math.min(otherEntry.lastAccessedCopy, newOldestEntry);
                    }
                    if (queue.myMaxSize <= 0) break;
                    CacheEntry o = queue.myInsertWithOverflow(ce);
                    if (o == null) continue;
                    newOldestEntry = Math.min(o.lastAccessedCopy, newOldestEntry);
                }
                for (CacheEntry ce : queue.getValues()) {
                    if (ce == null) continue;
                    this.evictEntry(ce.key);
                    ++numRemoved;
                }
            }
            this.oldestEntry = oldestEntry = newOldestEntry == Long.MAX_VALUE ? oldestEntry : newOldestEntry;
        }
        finally {
            this.isCleaning = false;
            this.markAndSweepLock.unlock();
        }
    }

    private void evictEntry(long key) {
        CacheEntry<V> o = this.map.remove(key);
        if (o == null) {
            return;
        }
        this.stats.size.decrementAndGet();
        this.stats.evictionCounter.incrementAndGet();
        this.evictedEntry(o.key, o.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, V> getOldestAccessedItems(int n) {
        LinkedHashMap result = new LinkedHashMap();
        if (n <= 0) {
            return result;
        }
        TreeSet<CacheEntry<V>> tree = new TreeSet<CacheEntry<V>>();
        this.markAndSweepLock.lock();
        try {
            Iterator<CacheEntry<V>> iter = this.map.valuesIterator();
            while (iter.hasNext()) {
                CacheEntry<V> cacheEntry = iter.next();
                cacheEntry.lastAccessedCopy = cacheEntry.lastAccessed;
                if (tree.size() < n) {
                    tree.add(cacheEntry);
                    continue;
                }
                if (cacheEntry.lastAccessedCopy >= ((CacheEntry)tree.first()).lastAccessedCopy) continue;
                tree.remove(tree.first());
                tree.add(cacheEntry);
            }
        }
        finally {
            this.markAndSweepLock.unlock();
        }
        for (CacheEntry cacheEntry : tree) {
            result.put(cacheEntry.key, cacheEntry.value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, V> getLatestAccessedItems(int n) {
        LinkedHashMap result = new LinkedHashMap();
        if (n <= 0) {
            return result;
        }
        TreeSet<CacheEntry<V>> tree = new TreeSet<CacheEntry<V>>();
        this.markAndSweepLock.lock();
        try {
            Iterator<CacheEntry<V>> iter = this.map.valuesIterator();
            while (iter.hasNext()) {
                CacheEntry<V> cacheEntry = iter.next();
                cacheEntry.lastAccessedCopy = cacheEntry.lastAccessed;
                if (tree.size() < n) {
                    tree.add(cacheEntry);
                    continue;
                }
                if (cacheEntry.lastAccessedCopy <= ((CacheEntry)tree.last()).lastAccessedCopy) continue;
                tree.remove(tree.last());
                tree.add(cacheEntry);
            }
        }
        finally {
            this.markAndSweepLock.unlock();
        }
        for (CacheEntry cacheEntry : tree) {
            result.put(cacheEntry.key, cacheEntry.value);
        }
        return result;
    }

    @Override
    public int size() {
        return this.stats.size.get();
    }

    @Override
    public Iterator<V> valuesIterator() {
        final Iterator<CacheEntry<V>> iter = this.map.valuesIterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public V next() {
                return ((CacheEntry)iter.next()).value;
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    @Override
    public LongMap.LongMapIterator<V> longMapIterator() {
        final LongMap.LongMapIterator<CacheEntry<V>> iter = this.map.longMapIterator();
        return new LongMap.LongMapIterator<V>(){

            @Override
            public boolean moveToNext() {
                return iter.moveToNext();
            }

            @Override
            public long key() {
                return iter.key();
            }

            @Override
            public V value() {
                return ((CacheEntry)iter.value()).value;
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public LongMap<CacheEntry<V>> getMap() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            if (this.cleanupThread != null) {
                this.cleanupThread.stopThread();
            }
        }
        finally {
            this.isDestroyed = true;
        }
    }

    public Stats getStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isDestroyed) {
                log.log(Level.SEVERE, "LongConcurrentLRUMap was not destroyed prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!");
                this.destroy();
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void evictedEntry(long key, V value) {
    }

    private static class CleanupThread
    extends Thread {
        private WeakReference<LongConcurrentLRUMap> cache;
        private boolean stop = false;

        public CleanupThread(LongConcurrentLRUMap c) {
            this.cache = new WeakReference<LongConcurrentLRUMap>(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                LongConcurrentLRUMap c;
                CleanupThread cleanupThread = this;
                synchronized (cleanupThread) {
                    if (this.stop) {
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.stop || (c = (LongConcurrentLRUMap)this.cache.get()) == null) break;
                c.markAndSweep();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wakeThread() {
            CleanupThread cleanupThread = this;
            synchronized (cleanupThread) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopThread() {
            CleanupThread cleanupThread = this;
            synchronized (cleanupThread) {
                this.stop = true;
                this.notify();
            }
        }
    }

    protected static class Stats {
        private final AtomicLong accessCounter = new AtomicLong(0L);
        private final AtomicLong putCounter = new AtomicLong(0L);
        private final AtomicLong nonLivePutCounter = new AtomicLong(0L);
        private final AtomicLong missCounter = new AtomicLong();
        private final AtomicInteger size = new AtomicInteger();
        private AtomicLong evictionCounter = new AtomicLong();

        protected Stats() {
        }

        public long getCumulativeLookups() {
            return this.accessCounter.get() - this.putCounter.get() - this.nonLivePutCounter.get() + this.missCounter.get();
        }

        public long getCumulativeHits() {
            return this.accessCounter.get() - this.putCounter.get() - this.nonLivePutCounter.get();
        }

        public long getCumulativePuts() {
            return this.putCounter.get();
        }

        public long getCumulativeEvictions() {
            return this.evictionCounter.get();
        }

        public int getCurrentSize() {
            return this.size.get();
        }

        public long getCumulativeNonLivePuts() {
            return this.nonLivePutCounter.get();
        }

        public long getCumulativeMisses() {
            return this.missCounter.get();
        }

        public void add(Stats other) {
            this.accessCounter.addAndGet(other.accessCounter.get());
            this.putCounter.addAndGet(other.putCounter.get());
            this.nonLivePutCounter.addAndGet(other.nonLivePutCounter.get());
            this.missCounter.addAndGet(other.missCounter.get());
            this.evictionCounter.addAndGet(other.evictionCounter.get());
            this.size.set(Math.max(this.size.get(), other.size.get()));
        }
    }

    private static class CacheEntry<V>
    implements Comparable<CacheEntry<V>> {
        long key;
        V value;
        volatile long lastAccessed = 0L;
        long lastAccessedCopy = 0L;

        public CacheEntry(long key, V value, long lastAccessed) {
            this.key = key;
            this.value = value;
            this.lastAccessed = lastAccessed;
        }

        public void setLastAccessed(long lastAccessed) {
            this.lastAccessed = lastAccessed;
        }

        @Override
        public int compareTo(CacheEntry<V> that) {
            if (this.lastAccessedCopy == that.lastAccessedCopy) {
                return 0;
            }
            return this.lastAccessedCopy < that.lastAccessedCopy ? 1 : -1;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return this.value.equals(obj);
        }

        public String toString() {
            return "key: " + this.key + " value: " + this.value + " lastAccessed:" + this.lastAccessed;
        }
    }

    private static abstract class PriorityQueue<T> {
        private int size = 0;
        private final int maxSize;
        private final T[] heap;

        public PriorityQueue(int maxSize) {
            this(maxSize, true);
        }

        public PriorityQueue(int maxSize, boolean prepopulate) {
            T sentinel;
            int heapSize = 0 == maxSize ? 2 : (maxSize == Integer.MAX_VALUE ? Integer.MAX_VALUE : maxSize + 1);
            this.heap = new Object[heapSize];
            this.maxSize = maxSize;
            if (prepopulate && (sentinel = this.getSentinelObject()) != null) {
                this.heap[1] = sentinel;
                for (int i = 2; i < this.heap.length; ++i) {
                    this.heap[i] = this.getSentinelObject();
                }
                this.size = maxSize;
            }
        }

        protected abstract boolean lessThan(T var1, T var2);

        protected T getSentinelObject() {
            return null;
        }

        public final T add(T element) {
            ++this.size;
            this.heap[this.size] = element;
            this.upHeap();
            return this.heap[1];
        }

        public T insertWithOverflow(T element) {
            if (this.size < this.maxSize) {
                this.add(element);
                return null;
            }
            if (this.size > 0 && !this.lessThan(element, this.heap[1])) {
                T ret = this.heap[1];
                this.heap[1] = element;
                this.updateTop();
                return ret;
            }
            return element;
        }

        public final T top() {
            return this.heap[1];
        }

        public final T pop() {
            if (this.size > 0) {
                T result = this.heap[1];
                this.heap[1] = this.heap[this.size];
                this.heap[this.size] = null;
                --this.size;
                this.downHeap();
                return result;
            }
            return null;
        }

        public final T updateTop() {
            this.downHeap();
            return this.heap[1];
        }

        public final int size() {
            return this.size;
        }

        public final void clear() {
            for (int i = 0; i <= this.size; ++i) {
                this.heap[i] = null;
            }
            this.size = 0;
        }

        private final void upHeap() {
            int i = this.size;
            T node = this.heap[i];
            for (int j = i >>> 1; j > 0 && this.lessThan(node, this.heap[j]); j >>>= 1) {
                this.heap[i] = this.heap[j];
                i = j;
            }
            this.heap[i] = node;
        }

        private final void downHeap() {
            int i = 1;
            T node = this.heap[i];
            int j = i << 1;
            int k = j + 1;
            if (k <= this.size && this.lessThan(this.heap[k], this.heap[j])) {
                j = k;
            }
            while (j <= this.size && this.lessThan(this.heap[j], node)) {
                this.heap[i] = this.heap[j];
                i = j;
                k = (j = i << 1) + 1;
                if (k > this.size || !this.lessThan(this.heap[k], this.heap[j])) continue;
                j = k;
            }
            this.heap[i] = node;
        }

        protected final Object[] getHeapArray() {
            return this.heap;
        }
    }

    private static class PQueue<V>
    extends PriorityQueue<CacheEntry<V>> {
        int myMaxSize;
        final Object[] heap = this.getHeapArray();

        PQueue(int maxSz) {
            super(maxSz);
            this.myMaxSize = maxSz;
        }

        Iterable<CacheEntry<V>> getValues() {
            return Collections.unmodifiableCollection(Arrays.asList(this.heap));
        }

        @Override
        protected boolean lessThan(CacheEntry a, CacheEntry b) {
            return b.lastAccessedCopy < a.lastAccessedCopy;
        }

        public CacheEntry<V> myInsertWithOverflow(CacheEntry<V> element) {
            if (this.size() < this.myMaxSize) {
                this.add(element);
                return null;
            }
            if (this.size() > 0 && !this.lessThan(element, (CacheEntry)this.heap[1])) {
                CacheEntry ret = (CacheEntry)this.heap[1];
                this.heap[1] = element;
                this.updateTop();
                return ret;
            }
            return element;
        }
    }
}

