/*
 * Decompiled with CFR 0.152.
 */
package smed;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import messages.Messages;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import panels.PanelMain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmedAction
extends JosmAction
implements SelectionChangedListener {
    private static final long serialVersionUID = 1L;
    private static String editor = I18n.tr((String)"SeaMap Editor", (Object[])new Object[0]);
    public static JFrame editFrame = null;
    private boolean isOpen = false;
    public static PanelMain panelMain = null;
    public DataSet data = null;
    public OsmPrimitive node = null;
    private Collection<? extends OsmPrimitive> selection = null;

    public SmedAction() {
        super(editor, "Smed", editor, null, true);
    }

    public void actionPerformed(ActionEvent arg0) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!SmedAction.this.isOpen) {
                    SmedAction.this.createFrame();
                } else {
                    editFrame.toFront();
                }
                SmedAction.this.isOpen = true;
            }
        });
    }

    protected void createFrame() {
        editFrame = new JFrame(editor);
        editFrame.setDefaultCloseOperation(2);
        editFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SmedAction.this.closeDialog();
            }
        });
        editFrame.setSize(new Dimension(420, 420));
        editFrame.setLocation(100, 200);
        editFrame.setResizable(true);
        editFrame.setAlwaysOnTop(true);
        editFrame.setVisible(true);
        editFrame.setLayout(null);
        panelMain = new PanelMain(this);
        panelMain.setBounds(10, 10, 400, 400);
        this.node = null;
        panelMain.syncPanel();
        editFrame.add(panelMain);
        DataSet.addSelectionListener((SelectionChangedListener)this);
    }

    public void closeDialog() {
        if (this.isOpen) {
            editFrame.setVisible(false);
            editFrame.dispose();
            this.data = null;
        }
        this.isOpen = false;
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        OsmPrimitive nextNode = null;
        this.selection = newSelection;
        Iterator<? extends OsmPrimitive> i$ = this.selection.iterator();
        while (i$.hasNext()) {
            OsmPrimitive osm;
            nextNode = osm = i$.next();
            if (this.selection.size() == 1) {
                if (nextNode.compareTo((Object)this.node) == 0) continue;
                this.node = nextNode;
                SmedAction.panelMain.mark.parseMark(this.node);
                continue;
            }
            this.node = null;
            SmedAction.panelMain.mark.clrMark();
            PanelMain.messageBar.setText(Messages.getString("OneNode"));
        }
        if (nextNode == null) {
            this.node = null;
            SmedAction.panelMain.mark.clrMark();
            PanelMain.messageBar.setText(Messages.getString("SelectNode"));
        }
    }
}

