/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.print;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.ParseException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.print.PrintPreview;
import org.openstreetmap.josm.plugins.print.PrintableMapView;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.WindowGeometry;

public class PrintDialog
extends JDialog
implements ActionListener {
    protected JTextField printerField;
    protected JTextField paperField;
    protected JTextField orientationField;
    protected JCheckBox previewCheckBox;
    protected SpinnerNumberModel resolutionModel;
    protected SpinnerNumberModel scaleModel;
    protected PrintPreview printPreview;
    protected PrintableMapView mapView;
    protected PrinterJob job;
    PrintRequestAttributeSet attrs = new HashPrintRequestAttributeSet();

    public PrintDialog(Component parent) {
        super((Window)JOptionPane.getFrameForComponent(parent), I18n.tr((String)"Print the Map", (Object[])new Object[0]), Dialog.ModalityType.DOCUMENT_MODAL);
        this.mapView = new PrintableMapView();
        this.job = PrinterJob.getPrinterJob();
        this.job.setJobName("JOSM Map");
        this.job.setPrintable(this.mapView);
        this.build();
        this.updateFields();
        this.pack();
        this.setMaximumSize(Toolkit.getDefaultToolkit().getScreenSize());
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            Insets i = this.getParent().getInsets();
            Dimension p = this.getParent().getSize();
            p = new Dimension(Math.min(p.width - i.left - i.right, 1000), Math.min(p.height - i.top - i.bottom, 700));
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow((Component)this.getParent(), (Dimension)p)).applySafe((Window)this);
        } else if (!visible && this.isShowing()) {
            new WindowGeometry((Window)this).remember(this.getClass().getName() + ".geometry");
            Main.pref.put("print.preview.enabled", this.previewCheckBox.isSelected());
        }
        super.setVisible(visible);
    }

    public void build() {
        this.setLayout(new GridBagLayout());
        GBC std = GBC.std().insets(0, 5, 5, 0);
        std.fill = 2;
        GBC twoColumns = GBC.std().insets(0, 5, 5, 0).span(2);
        twoColumns.fill = 2;
        GBC threeColumns = GBC.std().insets(0, 5, 5, 0).span(3);
        threeColumns.fill = 2;
        int row = 0;
        JLabel caption = new JLabel(I18n.tr((String)"Printer", (Object[])new Object[0]) + ":");
        this.add((Component)caption, twoColumns.grid(2, row));
        this.printerField = new JTextField();
        this.printerField.setEditable(false);
        this.add((Component)this.printerField, std.grid(-1, row));
        caption = new JLabel(I18n.tr((String)"Media", (Object[])new Object[0]) + ":");
        this.add((Component)caption, twoColumns.grid(2, ++row));
        this.paperField = new JTextField();
        this.paperField.setEditable(false);
        this.add((Component)this.paperField, std.grid(-1, row));
        caption = new JLabel(I18n.tr((String)"Orientation", (Object[])new Object[0]) + ":");
        this.add((Component)caption, twoColumns.grid(2, ++row));
        this.orientationField = new JTextField();
        this.orientationField.setEditable(false);
        this.add((Component)this.orientationField, std.grid(-1, row));
        JButton printerButton = new JButton(I18n.tr((String)"Printer settings", (Object[])new Object[0]) + "...");
        printerButton.setActionCommand("printer-dialog");
        printerButton.addActionListener(this);
        this.add((Component)printerButton, threeColumns.grid(2, ++row));
        this.add(GBC.glue((int)5, (int)10), GBC.std((int)1, (int)(++row)).fill(3));
        caption = new JLabel(I18n.tr((String)"Scale", (Object[])new Object[0]) + ":");
        this.add((Component)caption, std.grid(2, ++row));
        caption = new JLabel(" 1 :");
        this.add((Component)caption, std.grid(-1, row));
        int mapScale = Main.pref.getInteger("print.map-scale", 25000);
        this.mapView.setFixedMapScale(mapScale);
        this.scaleModel = new SpinnerNumberModel(mapScale, 500, 5000000, 500);
        final JSpinner scaleField = new JSpinner(this.scaleModel);
        scaleField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            scaleField.commitEdit();
                            Main.pref.put("print.map-scale", PrintDialog.this.scaleModel.getNumber().toString());
                            PrintDialog.this.mapView.setFixedMapScale(PrintDialog.this.scaleModel.getNumber().intValue());
                            PrintDialog.this.printPreview.repaint();
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        this.add((Component)scaleField, std.grid(-1, row));
        caption = new JLabel(I18n.tr((String)"Resolution", (Object[])new Object[0]) + ":");
        this.add((Component)caption, std.grid(2, ++row));
        caption = new JLabel("ppi");
        this.add((Component)caption, std.grid(-1, row));
        this.resolutionModel = new SpinnerNumberModel(Main.pref.getInteger("print.resolution.dpi", 100), 30, 1200, 10);
        final JSpinner resolutionField = new JSpinner(this.resolutionModel);
        resolutionField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            resolutionField.commitEdit();
                            Main.pref.put("print.resolution.dpi", PrintDialog.this.resolutionModel.getNumber().toString());
                            PrintDialog.this.printPreview.repaint();
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        this.add((Component)resolutionField, std.grid(-1, row));
        caption = new JLabel(I18n.tr((String)"Map information", (Object[])new Object[0]) + ":");
        this.add((Component)caption, threeColumns.grid(2, ++row));
        ++row;
        final JTextArea attributionText = new JTextArea(Main.pref.get("print.attribution", "\u00a9 OpenStreetMap contributors"));
        attributionText.setRows(10);
        attributionText.setLineWrap(true);
        attributionText.setWrapStyleWord(true);
        attributionText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Main.pref.put("print.attribution", attributionText.getText());
                        PrintDialog.this.printPreview.repaint();
                    }
                });
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.insertUpdate(evt);
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
            }
        });
        JScrollPane attributionPane = new JScrollPane(attributionText);
        this.add((Component)attributionPane, GBC.std().insets(0, 5, 5, 0).span(3).fill(1).weight(0.0, 1.0).grid(2, row));
        this.add(GBC.glue((int)5, (int)10), GBC.std((int)1, (int)(++row)).fill(3));
        this.previewCheckBox = new JCheckBox(I18n.tr((String)"Map Preview", (Object[])new Object[0]));
        this.previewCheckBox.setSelected(Main.pref.getBoolean("print.preview.enabled", false));
        this.previewCheckBox.setActionCommand("toggle-preview");
        this.previewCheckBox.addActionListener(this);
        this.add((Component)this.previewCheckBox, threeColumns.grid(2, ++row));
        JButton zoomInButton = new JButton(I18n.tr((String)"Zoom In", (Object[])new Object[0]));
        zoomInButton.setActionCommand("zoom-in");
        zoomInButton.addActionListener(this);
        this.add((Component)zoomInButton, threeColumns.grid(2, ++row));
        JButton zoomOutButton = new JButton(I18n.tr((String)"Zoom Out", (Object[])new Object[0]));
        zoomOutButton.setActionCommand("zoom-out");
        zoomOutButton.addActionListener(this);
        this.add((Component)zoomOutButton, threeColumns.grid(2, ++row));
        JButton zoomToPageButton = new JButton(I18n.tr((String)"Zoom To Page", (Object[])new Object[0]));
        zoomToPageButton.setActionCommand("zoom-to-page");
        zoomToPageButton.addActionListener(this);
        this.add((Component)zoomToPageButton, threeColumns.grid(2, ++row));
        JButton zoomToActualSize = new JButton(I18n.tr((String)"Zoom To Actual Size", (Object[])new Object[0]));
        zoomToActualSize.setActionCommand("zoom-to-actual-size");
        zoomToActualSize.addActionListener(this);
        this.add((Component)zoomToActualSize, threeColumns.grid(2, ++row));
        this.printPreview = new PrintPreview();
        if (this.previewCheckBox.isSelected()) {
            this.printPreview.setPrintable(this.mapView);
        }
        JScrollPane previewPane = new JScrollPane(this.printPreview, 20, 30);
        previewPane.setPreferredSize(Main.main != null ? Main.map.mapView.getSize() : new Dimension(210, 297));
        this.add((Component)previewPane, GBC.std((int)0, (int)0).span(1, -1).fill().weight(5.0, 5.0));
        ++row;
        JPanel actionPanel = new JPanel();
        JButton printButton = new JButton(I18n.tr((String)"Print", (Object[])new Object[0]));
        printButton.setActionCommand("print");
        printButton.addActionListener(this);
        actionPanel.add(printButton);
        JButton cancelButton = new JButton(I18n.tr((String)"Cancel", (Object[])new Object[0]));
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        actionPanel.add(cancelButton);
        this.add((Component)actionPanel, GBC.std((int)0, (int)row).insets(5, 5, 5, 5).span(0).fill(2));
    }

    protected void updateFields() {
        PrintService service = this.job.getPrintService();
        if (service == null) {
            this.printerField.setText("-");
            this.paperField.setText("-");
            this.orientationField.setText("-");
        } else {
            PageFormat pf;
            this.printerField.setText(service.getName());
            if (!this.attrs.containsKey(Media.class)) {
                this.attrs.add((Attribute)service.getDefaultAttributeValue(Media.class));
            }
            if (this.attrs.containsKey(Media.class)) {
                this.paperField.setText(this.attrs.get(Media.class).toString());
            }
            if (!this.attrs.containsKey(OrientationRequested.class)) {
                this.attrs.add((Attribute)service.getDefaultAttributeValue(OrientationRequested.class));
            }
            if (this.attrs.containsKey(OrientationRequested.class)) {
                this.orientationField.setText(this.attrs.get(OrientationRequested.class).toString());
            }
            if (!this.attrs.containsKey(MediaPrintableArea.class)) {
                pf = this.job.defaultPage();
                this.attrs.add(new MediaPrintableArea((float)pf.getImageableX() / 72.0f, (float)pf.getImageableY() / 72.0f, (float)pf.getImageableWidth() / 72.0f, (float)pf.getImageableHeight() / 72.0f, 25400));
            }
            pf = this.job.getPageFormat(this.attrs);
            this.printPreview.setPageFormat(pf);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("printer-dialog")) {
            PrintServiceLookup.lookupPrintServices(null, null);
            PrintServiceLookup.lookupDefaultPrintService();
            if (this.job.printDialog(this.attrs)) {
                this.updateFields();
            }
        } else if (cmd.equals("toggle-preview")) {
            Main.pref.put("print.preview.enabled", this.previewCheckBox.isSelected());
            if (this.previewCheckBox.isSelected()) {
                this.printPreview.setPrintable(this.mapView);
            } else {
                this.printPreview.setPrintable(null);
            }
        } else if (cmd.equals("zoom-in")) {
            this.printPreview.zoomIn();
        } else if (cmd.equals("zoom-out")) {
            this.printPreview.zoomOut();
        } else if (cmd.equals("zoom-to-page")) {
            this.printPreview.zoomToPage();
        } else if (cmd.equals("zoom-to-actual-size")) {
            this.printPreview.setZoom(1.0);
        } else if (cmd.equals("print")) {
            try {
                this.job.print(this.attrs);
            }
            catch (PrinterAbortException ex) {
                String msg = ex.getLocalizedMessage();
                if (msg.length() == 0) {
                    msg = I18n.tr((String)"Printing has been cancelled.", (Object[])new Object[0]);
                }
                JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr((String)"Printing stopped", (Object[])new Object[0]), 2);
            }
            catch (PrinterException ex) {
                String msg = ex.getLocalizedMessage();
                if (msg.length() == 0) {
                    msg = I18n.tr((String)"Printing has failed.", (Object[])new Object[0]);
                }
                JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr((String)"Printing stopped", (Object[])new Object[0]), 0);
            }
            this.dispose();
        } else if (cmd.equals("cancel")) {
            this.dispose();
        }
    }
}

