/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.tools.I18n;

public class RequiredTagMissingError
extends Issue {
    private static final Logger logger = Logger.getLogger(RequiredTagMissingError.class.getName());
    private String tagKey;
    private String tagValue;

    public RequiredTagMissingError(IssuesModel parent, String tagKey, String tagValue) {
        super(parent, Severity.ERROR);
        this.tagKey = tagKey;
        this.tagValue = tagValue;
        this.actions.add(new AddTagAction());
    }

    @Override
    public String getText() {
        return I18n.tr((String)"The required tag <tt>{0}={1}</tt> is missing.", (Object[])new Object[]{this.tagKey, this.tagValue});
    }

    private class AddTagAction
    extends AbstractAction {
        public AddTagAction() {
            this.putValue("Name", I18n.tr((String)"Add missing tag"));
            this.putValue("ShortDescription", I18n.tr((String)"Add the missing tag {0}={1}", (Object[])new Object[]{RequiredTagMissingError.this.tagKey, RequiredTagMissingError.this.tagValue}));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TagEditorModel model = RequiredTagMissingError.this.getIssuesModel().getEditorModel().getTagEditorModel();
            TagModel t = model.get(RequiredTagMissingError.this.tagKey);
            if (t == null) {
                t = new TagModel(RequiredTagMissingError.this.tagKey, RequiredTagMissingError.this.tagValue);
                model.prepend(t);
            }
        }
    }
}

