/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.tools.I18n;

public class IdenticalTurnRestrictionLegsError
extends Issue {
    private OsmPrimitive leg;

    public IdenticalTurnRestrictionLegsError(IssuesModel parent, OsmPrimitive leg) {
        super(parent, Severity.ERROR);
        this.actions.add(new DeleteFromAction());
        this.actions.add(new DeleteToAction());
        this.actions.add(new FixInEditorAction());
        this.leg = leg;
    }

    @Override
    public String getText() {
        return I18n.tr((String)"This turn restriction uses the OSM way <span class=\"object-name\">{0}</span> with role <tt>from</tt> <strong>and</strong> with role <tt>to</tt>. In a turn restriction, the way with role <tt>from</tt> should be different from the way with role <tt>to</tt>, though.", (Object[])new Object[]{this.leg.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
    }

    class DeleteFromAction
    extends AbstractAction {
        public DeleteFromAction() {
            this.putValue("Name", I18n.tr((String)"Delete ''from''"));
            this.putValue("ShortDescription", I18n.tr((String)"Removes the member with role ''from''"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdenticalTurnRestrictionLegsError.this.getIssuesModel().getEditorModel().getRelationMemberEditorModel().setFromPrimitive(null);
        }
    }

    class DeleteToAction
    extends AbstractAction {
        public DeleteToAction() {
            this.putValue("Name", I18n.tr((String)"Delete ''to''"));
            this.putValue("ShortDescription", I18n.tr((String)"Removes the member with role ''to''"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdenticalTurnRestrictionLegsError.this.getIssuesModel().getEditorModel().getRelationMemberEditorModel().setToPrimitive(null);
        }
    }

    class FixInEditorAction
    extends AbstractAction {
        public FixInEditorAction() {
            this.putValue("Name", I18n.tr((String)"Fix in editor"));
            this.putValue("ShortDescription", I18n.tr((String)"Go to Basic Editor and manually choose members with roles ''from'' and ''to''"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdenticalTurnRestrictionLegsError.this.getIssuesModel().getNavigationControler().gotoBasicEditor();
        }
    }
}

