/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdListProvider;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdListTransferHandler;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.NavigationControler;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionLegEditor;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionLegRole;

public class TurnRestrictionLegEditorTest
extends JFrame {
    private JTextArea taTest;
    private TurnRestrictionLegEditor editor;
    private TurnRestrictionEditorModel model;
    private JList lstObjects;
    private DefaultListModel listModel;
    private DataSet dataSet;

    protected JPanel buildLegEditorPanel() {
        DataSet ds = new DataSet();
        OsmDataLayer layer = new OsmDataLayer(ds, "test", null);
        NavigationControler controler = new NavigationControler(){

            @Override
            public void gotoAdvancedEditor() {
            }

            @Override
            public void gotoBasicEditor() {
            }

            @Override
            public void gotoBasicEditor(NavigationControler.BasicEditorFokusTargets focusTarget) {
            }
        };
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel("From"), gc);
        gc.weightx = 1.0;
        gc.gridx = 1;
        this.model = new TurnRestrictionEditorModel(layer, controler);
        this.dataSet = new DataSet();
        this.model.populate(new Relation());
        this.editor = new TurnRestrictionLegEditor(this.model, TurnRestrictionLegRole.FROM);
        pnl.add((Component)this.editor, gc);
        return pnl;
    }

    protected JPanel buildObjectListPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.lstObjects = new JList(this.listModel);
        pnl.add((Component)new JScrollPane(this.lstObjects), "Center");
        this.lstObjects.setCellRenderer(new OsmPrimitivRenderer());
        PrimitiveIdListProvider provider = new PrimitiveIdListProvider(){

            @Override
            public List<PrimitiveId> getSelectedPrimitiveIds() {
                int[] sel;
                ArrayList<PrimitiveId> ret = new ArrayList<PrimitiveId>();
                int[] nArray = sel = TurnRestrictionLegEditorTest.this.lstObjects.getSelectedIndices();
                int n = sel.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    ret.add(((OsmPrimitive)TurnRestrictionLegEditorTest.this.lstObjects.getModel().getElementAt(i)).getPrimitiveId());
                    ++n2;
                }
                return ret;
            }
        };
        this.lstObjects.setTransferHandler(new PrimitiveIdListTransferHandler(provider));
        this.lstObjects.setDragEnabled(true);
        return pnl;
    }

    protected void build() {
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.insets = new Insets(20, 0, 20, 0);
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.add((Component)this.buildLegEditorPanel(), gc);
        gc.gridy = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)this.buildObjectListPanel(), gc);
        this.setSize(600, 600);
    }

    protected void initForTest1() {
        Way w = new Way(1L);
        w.put("name", "way-1");
        this.editor.getModel().setTurnRestrictionLeg(TurnRestrictionLegRole.FROM, w);
    }

    protected void initForTest2() {
        Way w = new Way(1L);
        w.put("name", "way-1");
        this.dataSet.addPrimitive((OsmPrimitive)w);
        this.editor.getModel().setTurnRestrictionLeg(TurnRestrictionLegRole.FROM, w);
        Node n = new Node(new LatLon(1.0, 1.0));
        n.setOsmId(1L, 1);
        n.put("name", "node.1");
        this.dataSet.addPrimitive((OsmPrimitive)n);
        this.listModel.addElement(n);
        w = new Way();
        w.setOsmId(2L, 1);
        w.put("name", "way.1");
        this.dataSet.addPrimitive((OsmPrimitive)w);
        this.listModel.addElement(w);
        Relation r = new Relation();
        r.setOsmId(3L, 1);
        r.put("name", "relation.1");
        this.dataSet.addPrimitive((OsmPrimitive)r);
        this.listModel.addElement(r);
    }

    public TurnRestrictionLegEditorTest() {
        this.build();
        this.initForTest2();
    }

    public static void main(String[] args) {
        new TurnRestrictionLegEditorTest().setVisible(true);
    }
}

