/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.canvec_helper;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.canvec_helper.CanVecTile;
import org.openstreetmap.josm.plugins.canvec_helper.SetMaxZoom;
import org.openstreetmap.josm.plugins.canvec_helper.canvec_helper;
import org.openstreetmap.josm.tools.I18n;

public class canvec_layer
extends Layer
implements MouseListener {
    private Icon layerIcon = null;
    private int max_zoom = 4;
    public canvec_helper plugin_self;
    private ArrayList<CanVecTile> tiles = new ArrayList();
    public ArrayList<CanVecTile> downloadable = new ArrayList();
    public ArrayList<CanVecTile> openable = new ArrayList();

    public canvec_layer(String name, canvec_helper self) {
        super(name);
        this.plugin_self = self;
        this.setBackgroundLayer(true);
        this.layerIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/images/layericon.png")));
        try {
            String line;
            long start = System.currentTimeMillis();
            Pattern p = Pattern.compile("(\\d\\d\\d)([A-Z]\\d\\d).*");
            MirroredInputStream index = new MirroredInputStream("http://ftp2.cits.rncan.gc.ca/osm/pub/ZippedOsm.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)index));
            int last_cell = -1;
            ArrayList<String> list = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (m.find()) {
                    int cell = Integer.parseInt(m.group(1));
                    if (cell == last_cell) {
                        list.add(m.group(0));
                    } else if (last_cell != -1) {
                        CanVecTile tile = new CanVecTile(last_cell, "", 0, "", this, list);
                        if (tile.isValid()) {
                            this.tiles.add(tile);
                        }
                        list = new ArrayList();
                        list.add(m.group(0));
                    }
                    last_cell = cell;
                    continue;
                }
                System.out.print("bad line '" + line + "'\n");
            }
            CanVecTile tile = new CanVecTile(last_cell, "", 0, "", this, list);
            if (tile.isValid()) {
                this.tiles.add(tile);
            }
            long end = System.currentTimeMillis();
            System.out.println(end - start + "ms spent");
        }
        catch (IOException e) {
            System.out.println("exception getting index");
        }
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this), new MaxZoomAction(this), new DownloadCanvecAction(this), new OpenOsmAction(this)};
    }

    public void setMaxZoom(int max_zoom) {
        this.max_zoom = max_zoom;
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public String getToolTipText() {
        return I18n.tr((String)"canvec tile helper", (Object[])new Object[0]);
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public Icon getIcon() {
        return this.layerIcon;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        this.downloadable = new ArrayList();
        this.openable = new ArrayList();
        g.setColor(Color.red);
        for (int i = 0; i < this.tiles.size(); ++i) {
            CanVecTile tile = this.tiles.get(i);
            tile.paint(g, mv, bounds, this.max_zoom);
        }
        long end = System.currentTimeMillis();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        System.out.println("click!");
    }

    private class DownloadCanvecAction
    extends AbstractAction
    implements Layer.LayerAction {
        private canvec_layer parent;

        public DownloadCanvecAction(canvec_layer parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public boolean supportLayers(List<Layer> layers) {
            return false;
        }

        public Component createMenuComponent() {
            JMenu downloadCanvec = new JMenu("Download zip's");
            for (int i = 0; i < this.parent.downloadable.size(); ++i) {
                downloadCanvec.add(new JMenuItem(new AllowDownload(this.parent.downloadable.get(i))));
            }
            return downloadCanvec;
        }
    }

    private class DoOpenOsm
    extends AbstractAction {
        CanVecTile tile;

        public DoOpenOsm(CanVecTile tile) {
            super(tile.tileid);
            this.tile = tile;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.tile.load_raw_osm();
        }
    }

    private class OpenOsmAction
    extends AbstractAction
    implements Layer.LayerAction {
        private canvec_layer layer;

        public OpenOsmAction(canvec_layer layer) {
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public Component createMenuComponent() {
            JMenu OpenOsm = new JMenu("Open tile");
            for (int i = 0; i < this.layer.openable.size(); ++i) {
                OpenOsm.add(new JMenuItem(new DoOpenOsm(this.layer.openable.get(i))));
            }
            return OpenOsm;
        }

        public boolean supportLayers(List<Layer> layers) {
            return false;
        }
    }

    private class AllowDownload
    extends AbstractAction {
        CanVecTile tile;

        public AllowDownload(CanVecTile tile) {
            super(tile.tileid);
            this.tile = tile;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.tile.can_download = true;
        }
    }

    public class MaxZoomAction
    extends AbstractAction
    implements Layer.LayerAction {
        private canvec_layer parent;

        public MaxZoomAction(canvec_layer parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public boolean supportLayers(List<Layer> layers) {
            return false;
        }

        public Component createMenuComponent() {
            JMenu max_zoom = new JMenu("max zoom");
            max_zoom.add(new JMenuItem(new SetMaxZoom(this.parent, 1)));
            max_zoom.add(new JMenuItem(new SetMaxZoom(this.parent, 2)));
            max_zoom.add(new JMenuItem(new SetMaxZoom(this.parent, 3)));
            max_zoom.add(new JMenuItem(new SetMaxZoom(this.parent, 4)));
            return max_zoom;
        }
    }
}

