/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.persistence.util.COSHEXTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class COSName
extends COSBase
implements Comparable<COSName> {
    private static Map<String, COSName> nameMap = new ConcurrentHashMap<String, COSName>(8192);
    private static Map<String, COSName> commonNameMap = new HashMap<String, COSName>();
    public static final COSName A = new COSName("A");
    public static final COSName AA = new COSName("AA");
    public static final COSName ACRO_FORM = new COSName("AcroForm");
    public static final COSName ACTUAL_TEXT = new COSName("ActualText");
    public static final COSName AIS = new COSName("AIS");
    public static final COSName ALT = new COSName("Alt");
    public static final COSName ALTERNATE = new COSName("Alternate");
    public static final COSName ANNOTS = new COSName("Annots");
    public static final COSName ARTIFACT = new COSName("Artifact");
    public static final COSName ART_BOX = new COSName("ArtBox");
    public static final COSName ASCII85_DECODE = new COSName("ASCII85Decode");
    public static final COSName ASCII85_DECODE_ABBREVIATION = new COSName("A85");
    public static final COSName ATTACHED = new COSName("Attached");
    public static final COSName ASCII_HEX_DECODE = new COSName("ASCIIHexDecode");
    public static final COSName ASCII_HEX_DECODE_ABBREVIATION = new COSName("AHx");
    public static final COSName AP = new COSName("AP");
    public static final COSName AUTHOR = new COSName("Author");
    public static final COSName B = new COSName("B");
    public static final COSName BASE_ENCODING = new COSName("BaseEncoding");
    public static final COSName BASE_FONT = new COSName("BaseFont");
    public static final COSName BBOX = new COSName("BBox");
    public static final COSName BLACK_IS_1 = new COSName("BlackIs1");
    public static final COSName BLACK_POINT = new COSName("BlackPoint");
    public static final COSName BLEED_BOX = new COSName("BleedBox");
    public static final COSName BITS_PER_COMPONENT = new COSName("BitsPerComponent");
    public static final COSName BITS_PER_SAMPLE = new COSName("BitsPerSample");
    public static final COSName BOUNDS = new COSName("Bounds");
    public static final COSName BPC = new COSName("BPC");
    public static final COSName CATALOG = new COSName("Catalog");
    public static final COSName C = new COSName("C");
    public static final COSName C0 = new COSName("C0");
    public static final COSName C1 = new COSName("C1");
    public static final COSName CA = new COSName("CA");
    public static final COSName CA_NS = new COSName("ca");
    public static final COSName CALGRAY = new COSName("CalGray");
    public static final COSName CALRGB = new COSName("CalRGB");
    public static final COSName CCITTFAX_DECODE = new COSName("CCITTFaxDecode");
    public static final COSName CCITTFAX_DECODE_ABBREVIATION = new COSName("CCF");
    public static final COSName CF = new COSName("CF");
    public static final COSName CFM = new COSName("CFM");
    public static final COSName CHAR_PROCS = new COSName("CharProcs");
    public static final COSName CHAR_SET = new COSName("CharSet");
    public static final COSName CID_FONT_TYPE0 = new COSName("CIDFontType0");
    public static final COSName CID_FONT_TYPE2 = new COSName("CIDFontType2");
    public static final COSName CIDSYSTEMINFO = new COSName("CIDSystemInfo");
    public static final COSName COLORANTS = new COSName("Colorants");
    public static final COSName COLORSPACE = new COSName("ColorSpace");
    public static final COSName COLUMNS = new COSName("Columns");
    public static final COSName CONTENTS = new COSName("Contents");
    public static final COSName COUNT = new COSName("Count");
    public static final COSName CREATION_DATE = new COSName("CreationDate");
    public static final COSName CREATOR = new COSName("Creator");
    public static final COSName CROP_BOX = new COSName("CropBox");
    public static final COSName CRYPT = new COSName("Crypt");
    public static final COSName CS = new COSName("CS");
    public static final COSName D = new COSName("D");
    public static final COSName DCT_DECODE = new COSName("DCTDecode");
    public static final COSName DCT_DECODE_ABBREVIATION = new COSName("DCT");
    public static final COSName DECODE = new COSName("Decode");
    public static final COSName DECODE_PARMS = new COSName("DecodeParms");
    public static final COSName DESCENDANT_FONTS = new COSName("DescendantFonts");
    public static final COSName DEST = new COSName("Dest");
    public static final COSName DESTS = new COSName("Dests");
    public static final COSName DEVICECMYK = new COSName("DeviceCMYK");
    public static final COSName DEVICEGRAY = new COSName("DeviceGray");
    public static final COSName DEVICEN = new COSName("DeviceN");
    public static final COSName DEVICERGB = new COSName("DeviceRGB");
    public static final COSName DIFFERENCES = new COSName("Differences");
    public static final COSName DL = new COSName("DL");
    public static final COSName DOMAIN = new COSName("Domain");
    public static final COSName DP = new COSName("DP");
    public static final COSName DV = new COSName("DV");
    public static final COSName DW = new COSName("DW");
    public static final COSName E = new COSName("E");
    public static final COSName EMBEDDED_FILES = new COSName("EmbeddedFiles");
    public static final COSName ENCODE = new COSName("Encode");
    public static final COSName ENCODING = new COSName("Encoding");
    public static final COSName ENCODING_90MS_RKSJ_H = new COSName("90ms-RKSJ-H");
    public static final COSName ENCODING_90MS_RKSJ_V = new COSName("90ms-RKSJ-V");
    public static final COSName ENCODING_ETEN_B5_H = new COSName("ETen?B5?H");
    public static final COSName ENCODING_ETEN_B5_V = new COSName("ETen?B5?V");
    public static final COSName ENCRYPT = new COSName("Encrypt");
    public static final COSName EXT_G_STATE = new COSName("ExtGState");
    public static final COSName EXTENDS = new COSName("Extends");
    public static final COSName F = new COSName("F");
    public static final COSName F_DECODE_PARMS = new COSName("FDecodeParms");
    public static final COSName F_FILTER = new COSName("FFilter");
    public static final COSName FIELDS = new COSName("Fields");
    public static final COSName FILTER = new COSName("Filter");
    public static final COSName FIRST_CHAR = new COSName("FirstChar");
    public static final COSName FL = new COSName("FL");
    public static final COSName FLATE_DECODE = new COSName("FlateDecode");
    public static final COSName FLATE_DECODE_ABBREVIATION = new COSName("Fl");
    public static final COSName FONT = new COSName("Font");
    public static final COSName FONT_BBOX = new COSName("FontBBox");
    public static final COSName FONT_FAMILY = new COSName("FontFamily");
    public static final COSName FONT_FILE = new COSName("FontFile");
    public static final COSName FONT_FILE2 = new COSName("FontFile2");
    public static final COSName FONT_FILE3 = new COSName("FontFile3");
    public static final COSName FONT_DESC = new COSName("FontDescriptor");
    public static final COSName FONT_MATRIX = new COSName("FontMatrix");
    public static final COSName FONT_NAME = new COSName("FontName");
    public static final COSName FONT_STRETCH = new COSName("FontStretch");
    public static final COSName FORMTYPE = new COSName("FormType");
    public static final COSName FRM = new COSName("FRM");
    public static final COSName FUNCTION_TYPE = new COSName("FunctionType");
    public static final COSName FUNCTIONS = new COSName("Functions");
    public static final COSName GAMMA = new COSName("Gamma");
    public static final COSName H = new COSName("H");
    public static final COSName HEIGHT = new COSName("Height");
    public static final COSName ICCBASED = new COSName("ICCBased");
    public static final COSName ID = new COSName("ID");
    public static final COSName ID_TREE = new COSName("IDTree");
    public static final COSName IDENTITY = new COSName("Identity");
    public static final COSName IDENTITY_H = new COSName("Identity-H");
    public static final COSName IMAGE = new COSName("Image");
    public static final COSName IMAGE_MASK = new COSName("ImageMask");
    public static final COSName INDEX = new COSName("Index");
    public static final COSName INDEXED = new COSName("Indexed");
    public static final COSName INFO = new COSName("Info");
    public static final COSName JAVA_SCRIPT = new COSName("JavaScript");
    public static final COSName JBIG2_DECODE = new COSName("JBIG2Decode");
    public static final COSName JPX_DECODE = new COSName("JPXDecode");
    public static final COSName K = new COSName("K");
    public static final COSName KEYWORDS = new COSName("Keywords");
    public static final COSName KIDS = new COSName("Kids");
    public static final COSName LAB = new COSName("Lab");
    public static final COSName LANG = new COSName("Lang");
    public static final COSName LAST_CHAR = new COSName("LastChar");
    public static final COSName LC = new COSName("LC");
    public static final COSName LENGTH = new COSName("Length");
    public static final COSName LENGTH1 = new COSName("Length1");
    public static final COSName LIMITS = new COSName("Limits");
    public static final COSName LJ = new COSName("LJ");
    public static final COSName LW = new COSName("LW");
    public static final COSName LZW_DECODE = new COSName("LZWDecode");
    public static final COSName LZW_DECODE_ABBREVIATION = new COSName("LZW");
    public static final COSName MAC_ROMAN_ENCODING = new COSName("MacRomanEncoding");
    public static final COSName MARK_INFO = new COSName("MarkInfo");
    public static final COSName MASK = new COSName("Mask");
    public static final COSName MATRIX = new COSName("Matrix");
    public static final COSName MCID = new COSName("MCID");
    public static final COSName MEDIA_BOX = new COSName("MediaBox");
    public static final COSName METADATA = new COSName("Metadata");
    public static final COSName ML = new COSName("ML");
    public static final COSName MM_TYPE1 = new COSName("MMType1");
    public static final COSName MOD_DATE = new COSName("ModDate");
    public static final COSName N = new COSName("N");
    public static final COSName NAME = new COSName("Name");
    public static final COSName NAMES = new COSName("Names");
    public static final COSName NUMS = new COSName("Nums");
    public static final COSName O = new COSName("O");
    public static final COSName OBJ = new COSName("Obj");
    public static final COSName OP = new COSName("OP");
    public static final COSName OP_NS = new COSName("op");
    public static final COSName OPM = new COSName("OPM");
    public static final COSName OUTLINES = new COSName("Outlines");
    public static final COSName OPEN_ACTION = new COSName("OpenAction");
    public static final COSName ORDERING = new COSName("Ordering");
    public static final COSName P = new COSName("P");
    public static final COSName PAGE = new COSName("Page");
    public static final COSName PAGE_LABELS = new COSName("PageLabels");
    public static final COSName PAGE_LAYOUT = new COSName("PageLayout");
    public static final COSName PAGE_MODE = new COSName("PageMode");
    public static final COSName PAGES = new COSName("Pages");
    public static final COSName PARENT = new COSName("Parent");
    public static final COSName PARENT_TREE_NEXT_KEY = new COSName("ParentTreeNextKey");
    public static final COSName PATTERN = new COSName("Pattern");
    public static final COSName PDF_DOC_ENCODING = new COSName("PDFDocEncoding");
    public static final COSName PG = new COSName("Pg");
    public static final COSName PREDICTOR = new COSName("Predictor");
    public static final COSName PREV = new COSName("Prev");
    public static final COSName PROC_SET = new COSName("ProcSet");
    public static final COSName PRODUCER = new COSName("Producer");
    public static final COSName R = new COSName("R");
    public static final COSName RANGE = new COSName("Range");
    public static final COSName RECIPIENTS = new COSName("Recipients");
    public static final COSName REGISTRY = new COSName("Registry");
    public static final COSName RESOURCES = new COSName("Resources");
    public static final COSName RI = new COSName("RI");
    public static final COSName ROLE_MAP = new COSName("RoleMap");
    public static final COSName ROOT = new COSName("Root");
    public static final COSName ROTATE = new COSName("Rotate");
    public static final COSName ROWS = new COSName("Rows");
    public static final COSName RUN_LENGTH_DECODE = new COSName("RunLengthDecode");
    public static final COSName RUN_LENGTH_DECODE_ABBREVIATION = new COSName("RL");
    public static final COSName S = new COSName("S");
    public static final COSName SA = new COSName("SA");
    public static final COSName SEPARATION = new COSName("Separation");
    public static final COSName SHADING = new COSName("Shading");
    public static final COSName SM = new COSName("SM");
    public static final COSName SMASK = new COSName("SMask");
    public static final COSName SIZE = new COSName("Size");
    public static final COSName STANDARD_ENCODING = new COSName("StandardEncoding");
    public static final COSName STD_CF = new COSName("StdCF");
    public static final COSName STM_F = new COSName("StmF");
    public static final COSName STR_F = new COSName("StrF");
    public static final COSName STRUCT_TREE_ROOT = new COSName("StructTreeRoot");
    public static final COSName SUB_FILTER = new COSName("SubFilter");
    public static final COSName SUBJECT = new COSName("Subject");
    public static final COSName SUPPLEMENT = new COSName("Supplement");
    public static final COSName SUBTYPE = new COSName("Subtype");
    public static final COSName T = new COSName("T");
    public static final COSName THREADS = new COSName("Threads");
    public static final COSName TITLE = new COSName("Title");
    public static final COSName TK = new COSName("TK");
    public static final COSName TRAPPED = new COSName("Trapped");
    public static final COSName TRIM_BOX = new COSName("TrimBox");
    public static final COSName TRUE_TYPE = new COSName("TrueType");
    public static final COSName TO_UNICODE = new COSName("ToUnicode");
    public static final COSName TYPE = new COSName("Type");
    public static final COSName TYPE0 = new COSName("Type0");
    public static final COSName TYPE1 = new COSName("Type1");
    public static final COSName TYPE3 = new COSName("Type3");
    public static final COSName U = new COSName("U");
    public static final COSName URI = new COSName("URI");
    public static final COSName V = new COSName("V");
    public static final COSName VERSION = new COSName("Version");
    public static final COSName VIEWER_PREFERENCES = new COSName("ViewerPreferences");
    public static final COSName W = new COSName("W");
    public static final COSName WIDTH = new COSName("Width");
    public static final COSName WIDTHS = new COSName("Widths");
    public static final COSName WIN_ANSI_ENCODING = new COSName("WinAnsiEncoding");
    public static final COSName WHITE_POINT = new COSName("WhitePoint");
    public static final COSName XOBJECT = new COSName("XObject");
    public static final byte[] NAME_PREFIX = new byte[]{47};
    public static final byte[] NAME_ESCAPE = new byte[]{35};
    private String name;
    private int hashCode;

    public static final COSName getPDFName(String aName) {
        COSName name = null;
        if (aName != null && (name = commonNameMap.get(aName)) == null && (name = nameMap.get(aName)) == null) {
            name = new COSName(aName, false);
        }
        return name;
    }

    private COSName(String aName, boolean staticValue) {
        this.name = aName;
        if (staticValue) {
            commonNameMap.put(aName, this);
        } else {
            nameMap.put(aName, this);
        }
        this.hashCode = this.name.hashCode();
    }

    private COSName(String aName) {
        this(aName, true);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "COSName{" + this.name + "}";
    }

    public boolean equals(Object o) {
        boolean retval;
        boolean bl = retval = this == o;
        if (!retval && o instanceof COSName) {
            COSName other = (COSName)o;
            retval = this.name == other.name || this.name.equals(other.name);
        }
        return retval;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(COSName other) {
        return this.name.compareTo(other.name);
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromName(this);
    }

    public void writePDF(OutputStream output) throws IOException {
        output.write(NAME_PREFIX);
        byte[] bytes = this.getName().getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            int current = (bytes[i] + 256) % 256;
            if (current <= 32 || current >= 127 || current == 40 || current == 41 || current == 91 || current == 93 || current == 47 || current == 37 || current == 60 || current == 62 || current == NAME_ESCAPE[0]) {
                output.write(NAME_ESCAPE);
                output.write(COSHEXTable.TABLE[current]);
                continue;
            }
            output.write(current);
        }
    }

    public static synchronized void clearResources() {
        nameMap.clear();
    }
}

