/*
 * Decompiled with CFR 0.152.
 */
package pdfimport.pdfbox;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import pdfimport.LayerInfo;
import pdfimport.PathOptimizer;
import pdfimport.PdfPath;

public class GraphicsProcessor {
    public PathOptimizer target;
    private Shape clipShape;
    private List<PdfPath> clipPath;
    private final LayerInfo info = new LayerInfo();
    int pathNo = 0;
    private boolean complexClipShape;
    private boolean clipAreaDrawn;
    private final AffineTransform transform;
    private final ProgressMonitor monitor;
    private final int maxPaths;

    public GraphicsProcessor(PathOptimizer target, int rotation, int maxPaths, ProgressMonitor monitor) {
        this.maxPaths = maxPaths;
        this.target = target;
        this.transform = new AffineTransform();
        this.transform.rotate(-Math.toRadians(rotation));
        this.info.stroke = Color.BLACK;
        this.info.fill = Color.BLACK;
        this.monitor = monitor;
    }

    private void addPath(Shape s, boolean closed) {
        ++this.pathNo;
        if (this.pathNo % 100 == 0) {
            this.monitor.setCustomText(I18n.tr((String)" {0} objects so far", (Object[])new Object[]{this.pathNo}));
        }
        if (this.pathNo >= this.maxPaths) {
            return;
        }
        List<PdfPath> paths = this.parsePath(s, closed);
        for (PdfPath p : paths) {
            p.nr = this.pathNo;
        }
        if (paths.size() > 1) {
            this.target.addMultiPath(this.info, paths);
            this.parsePath(s, closed);
        } else if (paths.size() == 1) {
            this.target.addPath(this.info, paths.get(0));
        }
    }

    private List<PdfPath> parsePath(Shape s, boolean closed) {
        ArrayList<PdfPath> result = new ArrayList<PdfPath>(2);
        ArrayList<Point2D> points = new ArrayList<Point2D>(2);
        PathIterator iter = s.getPathIterator(null);
        double[] coords = new double[6];
        while (!iter.isDone()) {
            int type = iter.currentSegment(coords);
            if (type == 4) {
                this.addPoint(points, (Point2D)points.get(0));
                if (points.size() > 1) {
                    result.add(new PdfPath(points));
                }
                points = new ArrayList(2);
            } else if (type == 3) {
                this.addPoint(points, this.parsePoint(coords, 4));
            } else if (type == 1) {
                this.addPoint(points, this.parsePoint(coords, 0));
            } else if (type == 0) {
                if (points.size() > 1) {
                    result.add(new PdfPath(points));
                }
                points = new ArrayList(2);
                this.addPoint(points, this.parsePoint(coords, 0));
            } else if (type == 2) {
                this.addPoint(points, this.parsePoint(coords, 2));
            } else if (type != 0 && type != 1) {
                int a = 10;
                ++a;
            }
            iter.next();
        }
        if (points.size() > 1) {
            if (closed) {
                this.addPoint(points, (Point2D)points.get(0));
            }
            result.add(new PdfPath(points));
        }
        return result;
    }

    private void addPoint(List<Point2D> points, Point2D point) {
        Point2D prevPoint;
        if (points.size() > 0 && (prevPoint = points.get(points.size() - 1)).getX() == point.getX() && prevPoint.getY() == point.getY()) {
            return;
        }
        points.add(point);
    }

    private Point2D parsePoint(double[] buffer, int offset) {
        Point2D.Double point = new Point2D.Double(buffer[offset], buffer[offset + 1]);
        Point2D.Double dest = new Point2D.Double();
        this.transform.transform(point, dest);
        return this.target.getUniquePoint(dest);
    }

    public void drawPath(Shape path, Color stroke, Color fill, int windingRule) {
        if (this.complexClipShape && !this.clipAreaDrawn) {
            this.info.stroke = null;
            this.info.fill = Color.CYAN;
            this.addPath(this.clipShape, true);
            this.clipAreaDrawn = true;
        }
        if (!this.complexClipShape || fill != null) {
            this.info.stroke = stroke;
            this.info.fill = fill;
            this.addPath(path, fill != null);
        }
    }

    public void drawImage() {
        if (!this.clipAreaDrawn) {
            this.info.stroke = null;
            this.info.fill = Color.CYAN;
            this.addPath(this.clipShape, true);
            this.clipAreaDrawn = true;
        }
    }

    public void setClip(Shape clip) {
        if (this.shapesEqual(this.clipShape, clip)) {
            return;
        }
        this.clipPath = this.parsePath(clip, true);
        boolean complexClipPath = false;
        if (this.clipPath.size() > 1) {
            complexClipPath = true;
        } else if (this.clipPath.size() == 1 && this.clipPath.get((int)0).points.size() > 5) {
            complexClipPath = true;
        }
        this.complexClipShape = complexClipPath;
        this.clipAreaDrawn = false;
        this.clipShape = clip;
    }

    private boolean shapesEqual(Shape shape1, Shape shape2) {
        if (shape1 == null || shape2 == null) {
            return false;
        }
        return shape1.getBounds2D().equals(shape2.getBounds2D());
    }

    public void setStroke(Stroke s) {
        BasicStroke stroke = (BasicStroke)s;
        this.info.width = stroke.getLineWidth();
        this.info.dash = 0;
        if (stroke.getDashArray() != null) {
            this.info.dash = stroke.getDashArray().hashCode();
        }
    }

    public void drawString(float x, float y, String character, Color color) {
    }
}

