/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.czechaddress.MapUtils;
import org.openstreetmap.josm.plugins.czechaddress.NotNullList;
import org.openstreetmap.josm.plugins.czechaddress.PrimUtils;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.gui.FactoryDialog;
import org.openstreetmap.josm.plugins.czechaddress.gui.utils.UniversalListRenderer;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.ReasonerListener;
import org.openstreetmap.josm.tools.ImageProvider;

public class ConflictResolver
extends ExtendedDialog {
    private static ConflictResolver singleton = null;
    public static Logger logger = Logger.getLogger(ConflictResolver.class.getName());
    private JComboBox candField;
    private JLabel candLabel;
    private JButton candPickButton;
    private JButton candZoomButton;
    private JComboBox mainField;
    private JLabel mainLabel;
    private JPanel mainPanel;
    private JButton mainPickButton;
    private JButton mainZoomButton;
    private JButton reassignButton;
    private ConflictsModel conflictModel = new ConflictsModel();

    public static ConflictResolver getInstance() {
        if (singleton == null) {
            singleton = new ConflictResolver();
        }
        return singleton;
    }

    private ConflictResolver() {
        super(Main.parent, "\u0158e\u0161en\u00ed konflikt\u016f", new String[0], true);
        this.initComponents();
        this.mainField.setModel(this.conflictModel);
        Reasoner.getInstance().addListener(new ReasonerHook());
        ImageIcon zoomIcon = ImageProvider.get((String)"zoom.png");
        this.mainZoomButton.setIcon(zoomIcon);
        this.mainZoomButton.setText("");
        this.candZoomButton.setIcon(zoomIcon);
        this.candZoomButton.setText("");
        ImageIcon cursorIcon = ImageProvider.get((String)"cursor.png");
        this.mainPickButton.setIcon(cursorIcon);
        this.mainPickButton.setText("");
        this.candPickButton.setIcon(cursorIcon);
        this.candPickButton.setText("");
        this.setContent(this.mainPanel);
        this.setupDialog();
        this.setModal(false);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.candZoomButton = new JButton();
        this.mainLabel = new JLabel();
        this.reassignButton = new JButton();
        this.candLabel = new JLabel();
        this.mainZoomButton = new JButton();
        this.mainField = new JComboBox();
        this.candField = new JComboBox();
        this.candPickButton = new JButton();
        this.mainPickButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.candZoomButton.setText("     ");
        this.candZoomButton.setEnabled(false);
        this.candZoomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConflictResolver.this.candZoomButtonActionPerformed(evt);
            }
        });
        this.mainLabel.setText("Nejednozna\u010dn\u00fd prvek:");
        this.reassignButton.setText("Ur\u010dit jako nejlep\u0161\u00ed p\u0159i\u0159a\u017een\u00ed");
        this.reassignButton.setEnabled(false);
        this.reassignButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConflictResolver.this.reassignButtonActionPerformed(evt);
            }
        });
        this.candLabel.setText("Kandid\u00e1ti na p\u0159i\u0159azen\u00ed:");
        this.mainZoomButton.setText("     ");
        this.mainZoomButton.setEnabled(false);
        this.mainZoomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConflictResolver.this.mainZoomButtonActionPerformed(evt);
            }
        });
        this.mainField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.mainField.setRenderer(new UniversalListRenderer());
        this.candField.setModel(new DefaultComboBoxModel<String>(new String[]{" "}));
        this.candField.setRenderer(new UniversalListRenderer());
        this.candPickButton.setText("     ");
        this.candPickButton.setEnabled(false);
        this.candPickButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConflictResolver.this.candPickButtonActionPerformed(evt);
            }
        });
        this.mainPickButton.setText("     ");
        this.mainPickButton.setEnabled(false);
        this.mainPickButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConflictResolver.this.mainPickButtonActionPerformed(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.candLabel).addComponent(this.mainLabel)).addGap(6, 6, 6).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.candField, GroupLayout.Alignment.TRAILING, 0, 430, Short.MAX_VALUE).addComponent(this.mainField, 0, 430, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.candZoomButton).addComponent(this.mainZoomButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPickButton).addComponent(this.candPickButton))).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.reassignButton)));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainField, -2, -1, -2).addComponent(this.mainLabel)).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainZoomButton).addComponent(this.mainPickButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.candPickButton).addComponent(this.candZoomButton).addComponent(this.candField, -2, -1, -2).addComponent(this.candLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.reassignButton)));
        this.getContentPane().add(this.mainPanel);
        this.pack();
    }

    private void mainZoomButtonActionPerformed(ActionEvent evt) {
        this.zoomTo(this.mainField.getSelectedItem());
    }

    private void candZoomButtonActionPerformed(ActionEvent evt) {
        this.zoomTo(this.candField.getSelectedItem());
    }

    private void zoomTo(Object item) {
        OsmPrimitive prim;
        if (item instanceof OsmPrimitive) {
            MapUtils.zoomTo((OsmPrimitive)item);
        } else if (item instanceof AddressElement && (prim = Reasoner.getInstance().translate((AddressElement)item)) != null) {
            MapUtils.zoomTo(prim);
        }
    }

    public void focusElement(AddressElement elem) {
        int index = Collections.binarySearch(this.conflictModel.elements, elem);
        if (index >= 0) {
            this.mainField.setSelectedIndex(index);
            this.mainField.repaint();
            this.showDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reassignButtonActionPerformed(ActionEvent evt) {
        Reasoner r;
        Reasoner reasoner = r = Reasoner.getInstance();
        synchronized (reasoner) {
            int i;
            ComboBoxModel model;
            r.openTransaction();
            if (this.conflictModel.getSelectedItem() instanceof OsmPrimitive) {
                OsmPrimitive prim = (OsmPrimitive)this.conflictModel.getSelectedItem();
                if (r.translate(prim) != null) {
                    r.unOverwrite(prim, r.translate(prim));
                }
                model = this.candField.getModel();
                for (i = 0; i < model.getSize(); ++i) {
                    AddressElement elem = (AddressElement)model.getElementAt(i);
                    r.unOverwrite(prim, elem);
                    if (r.translate(elem) == null) continue;
                    r.unOverwrite(r.translate(elem), elem);
                }
                r.doOverwrite(prim, (AddressElement)model.getSelectedItem());
            }
            if (this.conflictModel.getSelectedItem() instanceof AddressElement) {
                AddressElement elem = (AddressElement)this.conflictModel.getSelectedItem();
                if (r.translate(elem) != null) {
                    r.unOverwrite(r.translate(elem), elem);
                }
                model = this.candField.getModel();
                for (i = 0; i < model.getSize(); ++i) {
                    OsmPrimitive prim = (OsmPrimitive)model.getElementAt(i);
                    r.unOverwrite(prim, elem);
                    if (r.translate(prim) == null) continue;
                    r.unOverwrite(prim, r.translate(prim));
                }
                r.doOverwrite((OsmPrimitive)model.getSelectedItem(), elem);
            }
            r.closeTransaction();
        }
    }

    private void mainPickButtonActionPerformed(ActionEvent evt) {
        if (this.mainField.getSelectedItem() instanceof House) {
            FactoryDialog.getInstance().setSelectedHouse((House)this.mainField.getSelectedItem());
        }
    }

    private void candPickButtonActionPerformed(ActionEvent evt) {
        if (this.candField.getSelectedItem() instanceof House) {
            FactoryDialog.getInstance().setSelectedHouse((House)this.candField.getSelectedItem());
        }
    }

    private void updateCandidatesModel(Object selected) {
        if (selected instanceof AddressElement) {
            AddressElement selElem = (AddressElement)selected;
            NotNullList<OsmPrimitive> conflPrims = new NotNullList<OsmPrimitive>();
            conflPrims.addAll(Reasoner.getInstance().getCandidates(selElem));
            Collections.sort(conflPrims, PrimUtils.comparator);
            this.candField.setModel(new CandidatesModel(conflPrims));
        } else if (selected instanceof OsmPrimitive) {
            OsmPrimitive selElem = (OsmPrimitive)selected;
            NotNullList<AddressElement> conflElems = new NotNullList<AddressElement>();
            conflElems.addAll(Reasoner.getInstance().getCandidates(selElem));
            Collections.sort(conflElems);
            this.candField.setModel(new CandidatesModel(conflElems));
        } else {
            this.candField.setModel(new DefaultComboBoxModel());
            this.candZoomButton.setEnabled(false);
            this.reassignButton.setEnabled(false);
        }
        this.candZoomButton.setEnabled(false);
        this.candPickButton.setEnabled(false);
        this.reassignButton.setEnabled(false);
        if (this.candField.getModel().getSize() > 0) {
            this.candField.setSelectedIndex(0);
        } else {
            this.candField.setSelectedIndex(-1);
        }
    }

    private void updateZoomButtons(Object selected, JButton button) {
        if (selected instanceof OsmPrimitive) {
            button.setEnabled(true);
        } else if (selected instanceof AddressElement) {
            button.setEnabled(Reasoner.getInstance().translate((AddressElement)selected) != null);
        } else {
            button.setEnabled(false);
        }
    }

    private void updatePickButtons(Object selected, JButton button) {
        button.setEnabled(selected instanceof House || selected instanceof Street);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CandidatesModel<E>
    implements ComboBoxModel {
        Set<ListDataListener> listeners = new HashSet<ListDataListener>();
        List<? extends E> primitives;
        Object selected = null;

        public CandidatesModel(List<? extends E> data) {
            this.primitives = data;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selected = anItem;
            ConflictResolver.this.updateZoomButtons(this.selected, ConflictResolver.this.candZoomButton);
            ConflictResolver.this.updatePickButtons(this.selected, ConflictResolver.this.candPickButton);
            if (ConflictResolver.this.conflictModel.getSelectedItem() instanceof AddressElement) {
                ConflictResolver.this.reassignButton.setEnabled(this.selected != Reasoner.getInstance().getStrictlyBest((AddressElement)ConflictResolver.this.conflictModel.getSelectedItem()));
                ConflictResolver.this.reassignButton.setEnabled(true);
            } else if (ConflictResolver.this.conflictModel.getSelectedItem() instanceof OsmPrimitive) {
                ConflictResolver.this.reassignButton.setEnabled(this.selected != Reasoner.getInstance().getStrictlyBest((OsmPrimitive)ConflictResolver.this.conflictModel.getSelectedItem()));
                ConflictResolver.this.reassignButton.setEnabled(true);
            } else {
                ConflictResolver.this.reassignButton.setEnabled(false);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public int getSize() {
            return this.primitives.size();
        }

        @Override
        public Object getElementAt(int index) {
            if (index < this.primitives.size()) {
                return this.primitives.get(index);
            }
            return null;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }
    }

    private class ConflictsModel
    implements ComboBoxModel {
        ArrayList<AddressElement> elements = new ArrayList();
        ArrayList<OsmPrimitive> primitives = new ArrayList();
        Set<ListDataListener> listeners = new HashSet<ListDataListener>();
        Object selected = null;

        private ConflictsModel() {
        }

        public void put(AddressElement elem) {
            int index = Collections.binarySearch(this.elements, elem);
            if (index < 0) {
                logger.log(Level.FINE, "conflicts: adding element", "[" + String.valueOf(-index - 1) + "]=\u201e" + elem.getName() + "\u201c");
                this.elements.add(-index - 1, elem);
                ListDataEvent evt = new ListDataEvent(this, 1, -index - 1, -index - 1);
                for (ListDataListener listener : this.listeners) {
                    listener.intervalAdded(evt);
                }
                if (ConflictResolver.this.mainField.getSelectedItem() == null) {
                    ConflictResolver.this.mainField.setSelectedIndex(-index - 1);
                }
            }
        }

        public void put(OsmPrimitive prim) {
            int index = Collections.binarySearch(this.primitives, prim, PrimUtils.comparator);
            if (index < 0) {
                logger.log(Level.FINE, "conflicts: adding primitive", "[" + String.valueOf(-index - 1) + "]=\u201e" + AddressElement.getName(prim) + "\u201c");
                this.primitives.add(-index - 1, prim);
                ListDataEvent evt = new ListDataEvent(this, 1, -index - 1 + this.elements.size(), -index - 1 + this.elements.size());
                for (ListDataListener listener : this.listeners) {
                    listener.intervalAdded(evt);
                }
                if (ConflictResolver.this.mainField.getSelectedItem() == null) {
                    ConflictResolver.this.mainField.setSelectedIndex(-index - 1);
                }
            }
        }

        public void remove(AddressElement elem) {
            int index = Collections.binarySearch(this.elements, elem);
            if (index >= 0) {
                logger.log(Level.FINE, "conflicts: removing element", "[" + String.valueOf(index) + "]=\u201e" + elem.getName() + "\u201c");
                this.elements.remove(index);
                if (this.selected == elem) {
                    this.setSelectedItem(null);
                }
                ListDataEvent evt = new ListDataEvent(this, 2, index, index);
                for (ListDataListener listener : this.listeners) {
                    listener.intervalRemoved(evt);
                }
            }
        }

        public void remove(OsmPrimitive prim) {
            int index = Collections.binarySearch(this.primitives, prim);
            index = this.primitives.indexOf(prim);
            if (index >= 0) {
                logger.log(Level.FINE, "conflicts: removing primitive", "[" + String.valueOf(index) + "]=\u201e" + AddressElement.getName(prim) + "\u201c");
                this.primitives.remove(index);
                if (this.selected == prim) {
                    this.setSelectedItem(null);
                }
                ListDataEvent evt = new ListDataEvent(this, 2, index + this.elements.size(), index + this.elements.size());
                for (ListDataListener listener : this.listeners) {
                    listener.intervalRemoved(evt);
                }
            }
        }

        public void clear() {
            logger.log(Level.FINE, "conflicts: clearing");
            ListDataEvent evt = new ListDataEvent(this, 0, 0, this.elements.size() + this.primitives.size() - 1);
            this.elements.clear();
            this.primitives.clear();
            for (ListDataListener listener : this.listeners) {
                listener.contentsChanged(evt);
            }
        }

        public void setSelectedItem(Object anItem) {
            if (anItem == null && this.getSize() > 0) {
                ConflictResolver.this.mainField.setSelectedIndex(0);
                return;
            }
            this.selected = anItem;
            ConflictResolver.this.updateZoomButtons(this.selected, ConflictResolver.this.mainZoomButton);
            ConflictResolver.this.updatePickButtons(this.selected, ConflictResolver.this.mainPickButton);
            ConflictResolver.this.updateCandidatesModel(anItem);
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public int getSize() {
            return this.primitives.size() + this.elements.size();
        }

        public Object getElementAt(int index) {
            if (index < this.elements.size()) {
                return this.elements.get(index);
            }
            if ((index -= this.elements.size()) < this.primitives.size()) {
                return this.primitives.get(index);
            }
            return null;
        }

        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }
    }

    private class ReasonerHook
    implements ReasonerListener {
        private ReasonerHook() {
        }

        public void elementChanged(AddressElement elem) {
            if (!(elem instanceof House)) {
                return;
            }
            logger.log(Level.FINER, "hook: element changed", elem.getName());
            if (Reasoner.getInstance().inConflict(elem)) {
                ConflictResolver.this.conflictModel.put(elem);
            } else {
                ConflictResolver.this.conflictModel.remove(elem);
            }
        }

        public void primitiveChanged(OsmPrimitive prim) {
            if (!House.isMatchable(prim)) {
                return;
            }
            logger.log(Level.FINER, "hook: primitive changed", AddressElement.getName(prim));
            if (Reasoner.getInstance().inConflict(prim)) {
                ConflictResolver.this.conflictModel.put(prim);
            } else {
                ConflictResolver.this.conflictModel.remove(prim);
            }
        }

        public void resonerReseted() {
        }
    }
}

